/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.freebuilder.processor.util;

import java.util.Collection;
import java.util.List;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.type.TypeMirror;
import org.inferred.freebuilder.processor.util.Excerpt;
import org.inferred.freebuilder.processor.util.Excerpts;
import org.inferred.freebuilder.processor.util.ModelUtils;
import org.inferred.freebuilder.processor.util.QualifiedName;
import org.inferred.freebuilder.processor.util.SourceBuilder;
import org.inferred.freebuilder.processor.util.Type;
import org.inferred.freebuilder.processor.util.ValueType;
import org.inferred.freebuilder.processor.util.feature.Feature;
import org.inferred.freebuilder.shaded.com.google.common.base.Preconditions;
import org.inferred.freebuilder.shaded.com.google.common.collect.ImmutableList;
import org.inferred.freebuilder.shaded.com.google.common.collect.Iterables;

public class TypeClass
extends Type {
    private final QualifiedName qualifiedName;
    private final List<TypeParameterElement> typeParameters;

    public static TypeClass from(TypeElement typeElement) {
        return new TypeClass(QualifiedName.of(typeElement), typeElement.getTypeParameters());
    }

    public static TypeClass fromNonGeneric(Class<?> cls) {
        Preconditions.checkArgument(cls.getTypeParameters().length == 0, "%s is generic", cls);
        return new TypeClass(QualifiedName.of(cls), ImmutableList.of());
    }

    TypeClass(QualifiedName qualifiedName, Collection<? extends TypeParameterElement> typeParameters) {
        this.qualifiedName = qualifiedName;
        this.typeParameters = ImmutableList.copyOf(typeParameters);
    }

    @Override
    public QualifiedName getQualifiedName() {
        return this.qualifiedName;
    }

    public Excerpt declaration() {
        return Excerpts.add("%s%s", this.getSimpleName(), this.declarationParameters());
    }

    public Excerpt declarationParameters() {
        return code -> TypeClass.addDeclarationParameters(code, this.getTypeParameters());
    }

    protected List<TypeParameterElement> getTypeParameters() {
        return this.typeParameters;
    }

    @Override
    protected void addFields(ValueType.FieldReceiver fields) {
        fields.add("qualifiedName", this.qualifiedName);
        fields.add("typeParameters", this.typeParameters);
    }

    @Override
    public String toString() {
        return SourceBuilder.forTesting(new Feature[0]).add(this.declaration()).toString();
    }

    private static void addDeclarationParameters(SourceBuilder source, List<TypeParameterElement> typeParameters) {
        if (!typeParameters.isEmpty()) {
            String prefix = "<";
            for (TypeParameterElement typeParameter : typeParameters) {
                source.add("%s%s", prefix, typeParameter.getSimpleName());
                if (!TypeClass.extendsObject(typeParameter)) {
                    String separator = " extends ";
                    for (TypeMirror typeMirror : typeParameter.getBounds()) {
                        source.add("%s%s", separator, typeMirror);
                        separator = " & ";
                    }
                }
                prefix = ", ";
            }
            source.add(">", new Object[0]);
        }
    }

    private static boolean extendsObject(TypeParameterElement element) {
        if (element.getBounds().size() != 1) {
            return false;
        }
        TypeElement bound = ModelUtils.maybeAsTypeElement(Iterables.getOnlyElement(element.getBounds())).orElse(null);
        if (bound == null) {
            return false;
        }
        return bound.getQualifiedName().contentEquals(Object.class.getName());
    }
}

