/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.freebuilder.processor.util;

import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.SimpleTypeVisitor8;
import org.inferred.freebuilder.processor.util.ModelUtils;
import org.inferred.freebuilder.processor.util.QualifiedName;
import org.inferred.freebuilder.processor.util.QualifiedNameAppendable;

class TypeMirrorAppender
extends SimpleTypeVisitor8<Void, QualifiedNameAppendable> {
    private static final TypeMirrorAppender INSTANCE = new TypeMirrorAppender();

    public static void appendShortened(TypeMirror mirror, QualifiedNameAppendable a) {
        mirror.accept(INSTANCE, a);
    }

    private TypeMirrorAppender() {
    }

    @Override
    public Void visitDeclared(DeclaredType mirror, QualifiedNameAppendable a) {
        if (!TypeMirrorAppender.isInnerClass(mirror)) {
            a.append(QualifiedName.of(ModelUtils.asElement(mirror)));
        } else {
            mirror.getEnclosingType().accept(this, a);
            a.append('.');
            a.append(mirror.asElement().getSimpleName());
        }
        if (!mirror.getTypeArguments().isEmpty()) {
            String prefix = "<";
            for (TypeMirror typeMirror : mirror.getTypeArguments()) {
                a.append(prefix);
                typeMirror.accept(this, a);
                prefix = ", ";
            }
            a.append(">");
        }
        return null;
    }

    private static boolean isInnerClass(DeclaredType mirror) {
        if (mirror.getEnclosingType().getKind() == TypeKind.NONE) {
            return false;
        }
        TypeElement element = ModelUtils.asElement(mirror);
        return !element.getModifiers().contains((Object)Modifier.STATIC);
    }

    @Override
    public Void visitWildcard(WildcardType t, QualifiedNameAppendable a) {
        a.append("?");
        if (t.getSuperBound() != null) {
            a.append(" super ");
            t.getSuperBound().accept(this, a);
        }
        if (t.getExtendsBound() != null) {
            a.append(" extends ");
            t.getExtendsBound().accept(this, a);
        }
        return null;
    }

    @Override
    protected Void defaultAction(TypeMirror mirror, QualifiedNameAppendable a) {
        a.append(mirror.toString());
        return null;
    }
}

