/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.freebuilder.processor;

import java.util.EnumSet;
import java.util.Objects;
import java.util.function.UnaryOperator;
import org.inferred.freebuilder.processor.BuildableType;
import org.inferred.freebuilder.processor.BuilderFactory;
import org.inferred.freebuilder.processor.source.Excerpt;
import org.inferred.freebuilder.processor.source.Type;
import org.inferred.freebuilder.shaded.com.google.common.annotations.VisibleForTesting;
import org.inferred.freebuilder.shaded.com.google.common.base.Preconditions;

abstract class BuildableType_Builder {
    private Type type;
    private Type builderType;
    private BuildableType.MergeBuilderMethod mergeBuilder;
    private BuildableType.PartialToBuilderMethod partialToBuilder;
    private BuilderFactory builderFactory;
    private Excerpt suppressUnchecked;
    private final EnumSet<Property> _unsetProperties = EnumSet.allOf(Property.class);

    BuildableType_Builder() {
    }

    public static BuildableType.Builder from(BuildableType value) {
        return new BuildableType.Builder().mergeFrom(value);
    }

    public BuildableType.Builder type(Type type) {
        this.type = Objects.requireNonNull(type);
        this._unsetProperties.remove((Object)Property.TYPE);
        return (BuildableType.Builder)this;
    }

    public BuildableType.Builder mapType(UnaryOperator<Type> mapper) {
        Objects.requireNonNull(mapper);
        return this.type((Type)mapper.apply(this.type()));
    }

    public Type type() {
        Preconditions.checkState(!this._unsetProperties.contains((Object)Property.TYPE), "type not set");
        return this.type;
    }

    public BuildableType.Builder builderType(Type builderType) {
        this.builderType = Objects.requireNonNull(builderType);
        this._unsetProperties.remove((Object)Property.BUILDER_TYPE);
        return (BuildableType.Builder)this;
    }

    public BuildableType.Builder mapBuilderType(UnaryOperator<Type> mapper) {
        Objects.requireNonNull(mapper);
        return this.builderType((Type)mapper.apply(this.builderType()));
    }

    public Type builderType() {
        Preconditions.checkState(!this._unsetProperties.contains((Object)Property.BUILDER_TYPE), "builderType not set");
        return this.builderType;
    }

    public BuildableType.Builder mergeBuilder(BuildableType.MergeBuilderMethod mergeBuilder) {
        this.mergeBuilder = Objects.requireNonNull(mergeBuilder);
        this._unsetProperties.remove((Object)Property.MERGE_BUILDER);
        return (BuildableType.Builder)this;
    }

    public BuildableType.Builder mapMergeBuilder(UnaryOperator<BuildableType.MergeBuilderMethod> mapper) {
        Objects.requireNonNull(mapper);
        return this.mergeBuilder((BuildableType.MergeBuilderMethod)((Object)mapper.apply(this.mergeBuilder())));
    }

    public BuildableType.MergeBuilderMethod mergeBuilder() {
        Preconditions.checkState(!this._unsetProperties.contains((Object)Property.MERGE_BUILDER), "mergeBuilder not set");
        return this.mergeBuilder;
    }

    public BuildableType.Builder partialToBuilder(BuildableType.PartialToBuilderMethod partialToBuilder) {
        this.partialToBuilder = Objects.requireNonNull(partialToBuilder);
        this._unsetProperties.remove((Object)Property.PARTIAL_TO_BUILDER);
        return (BuildableType.Builder)this;
    }

    public BuildableType.Builder mapPartialToBuilder(UnaryOperator<BuildableType.PartialToBuilderMethod> mapper) {
        Objects.requireNonNull(mapper);
        return this.partialToBuilder((BuildableType.PartialToBuilderMethod)((Object)mapper.apply(this.partialToBuilder())));
    }

    public BuildableType.PartialToBuilderMethod partialToBuilder() {
        Preconditions.checkState(!this._unsetProperties.contains((Object)Property.PARTIAL_TO_BUILDER), "partialToBuilder not set");
        return this.partialToBuilder;
    }

    public BuildableType.Builder builderFactory(BuilderFactory builderFactory) {
        this.builderFactory = Objects.requireNonNull(builderFactory);
        this._unsetProperties.remove((Object)Property.BUILDER_FACTORY);
        return (BuildableType.Builder)this;
    }

    public BuildableType.Builder mapBuilderFactory(UnaryOperator<BuilderFactory> mapper) {
        Objects.requireNonNull(mapper);
        return this.builderFactory((BuilderFactory)((Object)mapper.apply(this.builderFactory())));
    }

    public BuilderFactory builderFactory() {
        Preconditions.checkState(!this._unsetProperties.contains((Object)Property.BUILDER_FACTORY), "builderFactory not set");
        return this.builderFactory;
    }

    public BuildableType.Builder suppressUnchecked(Excerpt suppressUnchecked) {
        this.suppressUnchecked = Objects.requireNonNull(suppressUnchecked);
        this._unsetProperties.remove((Object)Property.SUPPRESS_UNCHECKED);
        return (BuildableType.Builder)this;
    }

    public BuildableType.Builder mapSuppressUnchecked(UnaryOperator<Excerpt> mapper) {
        Objects.requireNonNull(mapper);
        return this.suppressUnchecked((Excerpt)mapper.apply(this.suppressUnchecked()));
    }

    public Excerpt suppressUnchecked() {
        Preconditions.checkState(!this._unsetProperties.contains((Object)Property.SUPPRESS_UNCHECKED), "suppressUnchecked not set");
        return this.suppressUnchecked;
    }

    public BuildableType.Builder mergeFrom(BuildableType value) {
        BuildableType.Builder _defaults = new BuildableType.Builder();
        if (_defaults._unsetProperties.contains((Object)Property.TYPE) || !Objects.equals(value.type(), ((BuildableType_Builder)_defaults).type())) {
            this.type(value.type());
        }
        if (_defaults._unsetProperties.contains((Object)Property.BUILDER_TYPE) || !Objects.equals(value.builderType(), ((BuildableType_Builder)_defaults).builderType())) {
            this.builderType(value.builderType());
        }
        if (_defaults._unsetProperties.contains((Object)Property.MERGE_BUILDER) || !Objects.equals((Object)value.mergeBuilder(), (Object)((BuildableType_Builder)_defaults).mergeBuilder())) {
            this.mergeBuilder(value.mergeBuilder());
        }
        if (_defaults._unsetProperties.contains((Object)Property.PARTIAL_TO_BUILDER) || !Objects.equals((Object)value.partialToBuilder(), (Object)((BuildableType_Builder)_defaults).partialToBuilder())) {
            this.partialToBuilder(value.partialToBuilder());
        }
        if (_defaults._unsetProperties.contains((Object)Property.BUILDER_FACTORY) || !Objects.equals((Object)value.builderFactory(), (Object)((BuildableType_Builder)_defaults).builderFactory())) {
            this.builderFactory(value.builderFactory());
        }
        if (_defaults._unsetProperties.contains((Object)Property.SUPPRESS_UNCHECKED) || !Objects.equals(value.suppressUnchecked(), ((BuildableType_Builder)_defaults).suppressUnchecked())) {
            this.suppressUnchecked(value.suppressUnchecked());
        }
        return (BuildableType.Builder)this;
    }

    public BuildableType.Builder mergeFrom(BuildableType.Builder template) {
        BuildableType.Builder base = template;
        BuildableType.Builder _defaults = new BuildableType.Builder();
        if (!(base._unsetProperties.contains((Object)Property.TYPE) || !_defaults._unsetProperties.contains((Object)Property.TYPE) && Objects.equals(template.type(), ((BuildableType_Builder)_defaults).type()))) {
            this.type(template.type());
        }
        if (!(base._unsetProperties.contains((Object)Property.BUILDER_TYPE) || !_defaults._unsetProperties.contains((Object)Property.BUILDER_TYPE) && Objects.equals(template.builderType(), ((BuildableType_Builder)_defaults).builderType()))) {
            this.builderType(template.builderType());
        }
        if (!(base._unsetProperties.contains((Object)Property.MERGE_BUILDER) || !_defaults._unsetProperties.contains((Object)Property.MERGE_BUILDER) && Objects.equals((Object)template.mergeBuilder(), (Object)((BuildableType_Builder)_defaults).mergeBuilder()))) {
            this.mergeBuilder(template.mergeBuilder());
        }
        if (!(base._unsetProperties.contains((Object)Property.PARTIAL_TO_BUILDER) || !_defaults._unsetProperties.contains((Object)Property.PARTIAL_TO_BUILDER) && Objects.equals((Object)template.partialToBuilder(), (Object)((BuildableType_Builder)_defaults).partialToBuilder()))) {
            this.partialToBuilder(template.partialToBuilder());
        }
        if (!(base._unsetProperties.contains((Object)Property.BUILDER_FACTORY) || !_defaults._unsetProperties.contains((Object)Property.BUILDER_FACTORY) && Objects.equals((Object)template.builderFactory(), (Object)((BuildableType_Builder)_defaults).builderFactory()))) {
            this.builderFactory(template.builderFactory());
        }
        if (!(base._unsetProperties.contains((Object)Property.SUPPRESS_UNCHECKED) || !_defaults._unsetProperties.contains((Object)Property.SUPPRESS_UNCHECKED) && Objects.equals(template.suppressUnchecked(), ((BuildableType_Builder)_defaults).suppressUnchecked()))) {
            this.suppressUnchecked(template.suppressUnchecked());
        }
        return (BuildableType.Builder)this;
    }

    public BuildableType.Builder clear() {
        BuildableType.Builder _defaults = new BuildableType.Builder();
        this.type = _defaults.type;
        this.builderType = _defaults.builderType;
        this.mergeBuilder = _defaults.mergeBuilder;
        this.partialToBuilder = _defaults.partialToBuilder;
        this.builderFactory = _defaults.builderFactory;
        this.suppressUnchecked = _defaults.suppressUnchecked;
        this._unsetProperties.clear();
        this._unsetProperties.addAll(_defaults._unsetProperties);
        return (BuildableType.Builder)this;
    }

    public BuildableType build() {
        Preconditions.checkState(this._unsetProperties.isEmpty(), "Not set: %s", this._unsetProperties);
        return new Value(this);
    }

    @VisibleForTesting
    public BuildableType buildPartial() {
        return new Partial(this);
    }

    private static final class Partial
    extends BuildableType {
        private final Type type;
        private final Type builderType;
        private final BuildableType.MergeBuilderMethod mergeBuilder;
        private final BuildableType.PartialToBuilderMethod partialToBuilder;
        private final BuilderFactory builderFactory;
        private final Excerpt suppressUnchecked;
        private final EnumSet<Property> _unsetProperties;

        Partial(BuildableType_Builder builder) {
            this.type = builder.type;
            this.builderType = builder.builderType;
            this.mergeBuilder = builder.mergeBuilder;
            this.partialToBuilder = builder.partialToBuilder;
            this.builderFactory = builder.builderFactory;
            this.suppressUnchecked = builder.suppressUnchecked;
            this._unsetProperties = builder._unsetProperties.clone();
        }

        @Override
        public Type type() {
            if (this._unsetProperties.contains((Object)Property.TYPE)) {
                throw new UnsupportedOperationException("type not set");
            }
            return this.type;
        }

        @Override
        public Type builderType() {
            if (this._unsetProperties.contains((Object)Property.BUILDER_TYPE)) {
                throw new UnsupportedOperationException("builderType not set");
            }
            return this.builderType;
        }

        @Override
        public BuildableType.MergeBuilderMethod mergeBuilder() {
            if (this._unsetProperties.contains((Object)Property.MERGE_BUILDER)) {
                throw new UnsupportedOperationException("mergeBuilder not set");
            }
            return this.mergeBuilder;
        }

        @Override
        public BuildableType.PartialToBuilderMethod partialToBuilder() {
            if (this._unsetProperties.contains((Object)Property.PARTIAL_TO_BUILDER)) {
                throw new UnsupportedOperationException("partialToBuilder not set");
            }
            return this.partialToBuilder;
        }

        @Override
        public BuilderFactory builderFactory() {
            if (this._unsetProperties.contains((Object)Property.BUILDER_FACTORY)) {
                throw new UnsupportedOperationException("builderFactory not set");
            }
            return this.builderFactory;
        }

        @Override
        public Excerpt suppressUnchecked() {
            if (this._unsetProperties.contains((Object)Property.SUPPRESS_UNCHECKED)) {
                throw new UnsupportedOperationException("suppressUnchecked not set");
            }
            return this.suppressUnchecked;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Partial)) {
                return false;
            }
            Partial other = (Partial)obj;
            return Objects.equals(this.type, other.type) && Objects.equals(this.builderType, other.builderType) && Objects.equals((Object)this.mergeBuilder, (Object)other.mergeBuilder) && Objects.equals((Object)this.partialToBuilder, (Object)other.partialToBuilder) && Objects.equals((Object)this.builderFactory, (Object)other.builderFactory) && Objects.equals(this.suppressUnchecked, other.suppressUnchecked) && Objects.equals(this._unsetProperties, other._unsetProperties);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.type, this.builderType, this.mergeBuilder, this.partialToBuilder, this.builderFactory, this.suppressUnchecked, this._unsetProperties});
        }

        public String toString() {
            StringBuilder result = new StringBuilder("partial BuildableType{");
            String separator = "";
            if (!this._unsetProperties.contains((Object)Property.TYPE)) {
                result.append("type=").append(this.type);
                separator = ", ";
            }
            if (!this._unsetProperties.contains((Object)Property.BUILDER_TYPE)) {
                result.append(separator).append("builderType=").append(this.builderType);
                separator = ", ";
            }
            if (!this._unsetProperties.contains((Object)Property.MERGE_BUILDER)) {
                result.append(separator).append("mergeBuilder=").append((Object)this.mergeBuilder);
                separator = ", ";
            }
            if (!this._unsetProperties.contains((Object)Property.PARTIAL_TO_BUILDER)) {
                result.append(separator).append("partialToBuilder=").append((Object)this.partialToBuilder);
                separator = ", ";
            }
            if (!this._unsetProperties.contains((Object)Property.BUILDER_FACTORY)) {
                result.append(separator).append("builderFactory=").append((Object)this.builderFactory);
                separator = ", ";
            }
            if (!this._unsetProperties.contains((Object)Property.SUPPRESS_UNCHECKED)) {
                result.append(separator).append("suppressUnchecked=").append(this.suppressUnchecked);
            }
            return result.append("}").toString();
        }
    }

    private static final class Value
    extends BuildableType {
        private final Type type;
        private final Type builderType;
        private final BuildableType.MergeBuilderMethod mergeBuilder;
        private final BuildableType.PartialToBuilderMethod partialToBuilder;
        private final BuilderFactory builderFactory;
        private final Excerpt suppressUnchecked;

        private Value(BuildableType_Builder builder) {
            this.type = builder.type;
            this.builderType = builder.builderType;
            this.mergeBuilder = builder.mergeBuilder;
            this.partialToBuilder = builder.partialToBuilder;
            this.builderFactory = builder.builderFactory;
            this.suppressUnchecked = builder.suppressUnchecked;
        }

        @Override
        public Type type() {
            return this.type;
        }

        @Override
        public Type builderType() {
            return this.builderType;
        }

        @Override
        public BuildableType.MergeBuilderMethod mergeBuilder() {
            return this.mergeBuilder;
        }

        @Override
        public BuildableType.PartialToBuilderMethod partialToBuilder() {
            return this.partialToBuilder;
        }

        @Override
        public BuilderFactory builderFactory() {
            return this.builderFactory;
        }

        @Override
        public Excerpt suppressUnchecked() {
            return this.suppressUnchecked;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Value)) {
                return false;
            }
            Value other = (Value)obj;
            return Objects.equals(this.type, other.type) && Objects.equals(this.builderType, other.builderType) && Objects.equals((Object)this.mergeBuilder, (Object)other.mergeBuilder) && Objects.equals((Object)this.partialToBuilder, (Object)other.partialToBuilder) && Objects.equals((Object)this.builderFactory, (Object)other.builderFactory) && Objects.equals(this.suppressUnchecked, other.suppressUnchecked);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.type, this.builderType, this.mergeBuilder, this.partialToBuilder, this.builderFactory, this.suppressUnchecked});
        }

        public String toString() {
            return "BuildableType{type=" + this.type + ", builderType=" + this.builderType + ", mergeBuilder=" + (Object)((Object)this.mergeBuilder) + ", partialToBuilder=" + (Object)((Object)this.partialToBuilder) + ", builderFactory=" + (Object)((Object)this.builderFactory) + ", suppressUnchecked=" + this.suppressUnchecked + "}";
        }
    }

    private static enum Property {
        TYPE("type"),
        BUILDER_TYPE("builderType"),
        MERGE_BUILDER("mergeBuilder"),
        PARTIAL_TO_BUILDER("partialToBuilder"),
        BUILDER_FACTORY("builderFactory"),
        SUPPRESS_UNCHECKED("suppressUnchecked");

        private final String name;

        private Property(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

