/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.freebuilder.processor.property;

import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import javax.lang.model.element.Element;
import javax.lang.model.type.TypeKind;
import javax.tools.Diagnostic;
import org.inferred.freebuilder.processor.BuilderMethods;
import org.inferred.freebuilder.processor.Datatype;
import org.inferred.freebuilder.processor.Declarations;
import org.inferred.freebuilder.processor.property.Property;
import org.inferred.freebuilder.processor.property.PropertyCodeGenerator;
import org.inferred.freebuilder.processor.source.Excerpt;
import org.inferred.freebuilder.processor.source.Excerpts;
import org.inferred.freebuilder.processor.source.FieldAccess;
import org.inferred.freebuilder.processor.source.FunctionalType;
import org.inferred.freebuilder.processor.source.ObjectsExcerpts;
import org.inferred.freebuilder.processor.source.PreconditionExcerpts;
import org.inferred.freebuilder.processor.source.SourceBuilder;
import org.inferred.freebuilder.processor.source.Variable;

public class DefaultProperty
extends PropertyCodeGenerator {
    public static final FieldAccess UNSET_PROPERTIES = new FieldAccess("_unsetProperties");
    private final boolean hasDefault;
    private final FunctionalType mapperType;
    private final TypeKind kind;

    DefaultProperty(Datatype datatype, Property property, boolean hasDefault, FunctionalType mapperType) {
        super(datatype, property);
        this.hasDefault = hasDefault;
        this.mapperType = mapperType;
        this.kind = property.getType().getKind();
    }

    @Override
    public PropertyCodeGenerator.Initially initialState() {
        return this.hasDefault ? PropertyCodeGenerator.Initially.HAS_DEFAULT : PropertyCodeGenerator.Initially.REQUIRED;
    }

    @Override
    public void addBuilderFieldDeclaration(SourceBuilder code) {
        code.addLine("private %s %s;", this.property.getType(), this.property.getField());
    }

    @Override
    public void addBuilderFieldAccessors(SourceBuilder code) {
        this.addSetter(code);
        this.addMapper(code);
        this.addGetter(code);
    }

    private void addSetter(SourceBuilder code) {
        code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Sets the value to be returned by %s.", this.datatype.getType().javadocNoArgMethodLink(this.property.getGetterName())).addLine(" *", new Object[0]).addLine(" * @return this {@code %s} object", this.datatype.getBuilder().getSimpleName());
        if (!this.kind.isPrimitive()) {
            code.addLine(" * @throws NullPointerException if {@code %s} is null", this.property.getName());
        }
        code.addLine(" */", new Object[0]);
        this.addAccessorAnnotations(code);
        code.addLine("public %s %s(%s %s) {", this.datatype.getBuilder(), BuilderMethods.setter(this.property), this.property.getType(), this.property.getName());
        if (this.kind.isPrimitive()) {
            code.addLine("  %s = %s;", this.property.getField(), this.property.getName());
        } else {
            code.addLine("  %s = %s.requireNonNull(%s);", this.property.getField(), Objects.class, this.property.getName());
        }
        if (!this.hasDefault) {
            code.addLine("  %s.remove(%s.%s);", UNSET_PROPERTIES, this.datatype.getPropertyEnum(), this.property.getAllCapsName());
        }
        if (this.datatype.getBuilder() == this.datatype.getGeneratedBuilder()) {
            code.addLine("  return this;", new Object[0]);
        } else {
            code.addLine("  return (%s) this;", this.datatype.getBuilder());
        }
        code.addLine("}", new Object[0]);
    }

    private void addMapper(SourceBuilder code) {
        code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Replaces the value to be returned by %s", this.datatype.getType().javadocNoArgMethodLink(this.property.getGetterName())).addLine(" * by applying {@code mapper} to it and using the result.", new Object[0]).addLine(" *", new Object[0]).addLine(" * @return this {@code %s} object", this.datatype.getBuilder().getSimpleName()).addLine(" * @throws NullPointerException if {@code mapper} is null", new Object[0]);
        if (this.mapperType.canReturnNull()) {
            code.addLine(" * or returns null", new Object[0]);
        }
        if (!this.hasDefault) {
            code.addLine(" * @throws IllegalStateException if the field has not been set", new Object[0]);
        }
        code.addLine(" */", new Object[0]).add("public %s %s(%s mapper) {", this.datatype.getBuilder(), BuilderMethods.mapper(this.property), this.mapperType.getFunctionalInterface());
        if (!this.hasDefault) {
            code.addLine("  %s.requireNonNull(mapper);", Objects.class);
        }
        code.addLine("  return %s(mapper.%s(%s()));", BuilderMethods.setter(this.property), this.mapperType.getMethodName(), BuilderMethods.getter(this.property)).addLine("}", new Object[0]);
    }

    private void addGetter(SourceBuilder code) {
        code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Returns the value that will be returned by %s.", this.datatype.getType().javadocNoArgMethodLink(this.property.getGetterName()));
        if (!this.hasDefault) {
            code.addLine(" *", new Object[0]).addLine(" * @throws IllegalStateException if the field has not been set", new Object[0]);
        }
        code.addLine(" */", new Object[0]).addLine("public %s %s() {", this.property.getType(), BuilderMethods.getter(this.property));
        if (!this.hasDefault) {
            code.add(PreconditionExcerpts.checkState("!%s.contains(%s.%s)", this.property.getName() + " not set", UNSET_PROPERTIES, this.datatype.getPropertyEnum(), this.property.getAllCapsName()));
        }
        code.addLine("  return %s;", this.property.getField()).addLine("}", new Object[0]);
    }

    @Override
    public void addValueFieldDeclaration(SourceBuilder code, FieldAccess finalField) {
        code.add("private final %s %s;\n", this.property.getType(), finalField);
    }

    @Override
    public void addFinalFieldAssignment(SourceBuilder code, Excerpt finalField, String builder) {
        code.addLine("%s = %s;", finalField, this.property.getField().on(builder));
    }

    @Override
    public void addMergeFromValue(SourceBuilder code, String value) {
        Excerpt defaults = Declarations.freshBuilder(code, this.datatype).orElse(null);
        if (defaults != null) {
            code.add("if (", new Object[0]);
            if (!this.hasDefault) {
                code.add("%s.contains(%s.%s) || ", UNSET_PROPERTIES.on(defaults), this.datatype.getPropertyEnum(), this.property.getAllCapsName());
            }
            code.add(ObjectsExcerpts.notEquals(Excerpts.add("%s.%s()", value, this.property.getGetterName()), Excerpts.add("%s.%s()", defaults, BuilderMethods.getter(this.property)), this.kind));
            code.add(") {%n", new Object[0]);
        }
        code.addLine("  %s(%s.%s());", BuilderMethods.setter(this.property), value, this.property.getGetterName());
        if (defaults != null) {
            code.addLine("}", new Object[0]);
        }
    }

    @Override
    public void addMergeFromBuilder(SourceBuilder code, String builder) {
        Variable base = this.hasDefault ? null : Declarations.upcastToGeneratedBuilder(code, this.datatype, builder);
        Excerpt defaults = Declarations.freshBuilder(code, this.datatype).orElse(null);
        if (defaults != null) {
            code.add("if (", new Object[0]);
            if (!this.hasDefault) {
                code.add("!%s.contains(%s.%s) && ", UNSET_PROPERTIES.on(base), this.datatype.getPropertyEnum(), this.property.getAllCapsName()).add("(%s.contains(%s.%s) ||", UNSET_PROPERTIES.on(defaults), this.datatype.getPropertyEnum(), this.property.getAllCapsName());
            }
            code.add(ObjectsExcerpts.notEquals(Excerpts.add("%s.%s()", builder, BuilderMethods.getter(this.property)), Excerpts.add("%s.%s()", defaults, BuilderMethods.getter(this.property)), this.kind));
            if (!this.hasDefault) {
                code.add(")", new Object[0]);
            }
            code.add(") {%n", new Object[0]);
        } else if (!this.hasDefault) {
            code.addLine("if (!%s.contains(%s.%s)) {", UNSET_PROPERTIES.on(base), this.datatype.getPropertyEnum(), this.property.getAllCapsName());
        }
        code.addLine("  %s(%s.%s());", BuilderMethods.setter(this.property), builder, BuilderMethods.getter(this.property));
        if (defaults != null || !this.hasDefault) {
            code.addLine("}", new Object[0]);
        }
    }

    @Override
    public void addSetBuilderFromPartial(SourceBuilder code, Variable builder) {
        if (!this.hasDefault) {
            code.add("if (!%s.contains(%s.%s)) {", UNSET_PROPERTIES, this.datatype.getPropertyEnum(), this.property.getAllCapsName());
        }
        code.addLine("  %s.%s(%s);", builder, BuilderMethods.setter(this.property), this.property.getField());
        if (!this.hasDefault) {
            code.addLine("}", new Object[0]);
        }
    }

    @Override
    public void addSetFromResult(SourceBuilder code, Excerpt builder, Excerpt variable) {
        code.addLine("%s.%s(%s);", builder, BuilderMethods.setter(this.property), variable);
    }

    @Override
    public void addClearField(SourceBuilder code) {
        Optional<Variable> defaults = Declarations.freshBuilder(code, this.datatype);
        if (defaults.isPresent()) {
            code.addLine("%s = %s;", this.property.getField(), this.property.getField().on(defaults.get()));
        }
    }

    @Override
    public void addToStringValue(SourceBuilder code) {
        if (this.kind == TypeKind.ARRAY) {
            code.add("%s.toString(%s)", Arrays.class, this.property.getField());
        } else {
            code.add(this.property.getField());
        }
    }

    static class Factory
    implements PropertyCodeGenerator.Factory {
        Factory() {
        }

        public Optional<DefaultProperty> create(PropertyCodeGenerator.Config config) {
            Property property = config.getProperty();
            boolean hasDefault = config.getMethodsInvokedInBuilderConstructor().contains(BuilderMethods.setter(property));
            Factory.issueMutabilityWarning(config);
            FunctionalType mapperType = FunctionalType.functionalTypeAcceptedByMethod(config.getBuilder(), BuilderMethods.mapper(property), FunctionalType.unboxedUnaryOperator(property.getType(), config.getTypes()), config.getElements(), config.getTypes());
            return Optional.of(new DefaultProperty(config.getDatatype(), property, hasDefault, mapperType));
        }

        private static void issueMutabilityWarning(PropertyCodeGenerator.Config config) {
            TypeKind kind = config.getProperty().getType().getKind();
            if (kind == TypeKind.ARRAY && !Factory.mutableWarningsSuppressed(config.getSourceElement())) {
                config.getEnvironment().getMessager().printMessage(Diagnostic.Kind.WARNING, "This property returns a mutable array that can be modified by the caller. FreeBuilder will use reference equality for this property. If possible, prefer an immutable type like List. You can suppress this warning with @SuppressWarnings(\"mutable\").", config.getSourceElement());
            }
        }

        private static boolean mutableWarningsSuppressed(Element element) {
            SuppressWarnings suppressed = element.getAnnotation(SuppressWarnings.class);
            if (suppressed != null && Arrays.asList(suppressed.value()).contains("mutable")) {
                return true;
            }
            Element parent = element.getEnclosingElement();
            if (parent != null) {
                return Factory.mutableWarningsSuppressed(parent);
            }
            return false;
        }
    }
}

