/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.freebuilder.processor.property;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Spliterator;
import java.util.stream.BaseStream;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.inferred.freebuilder.processor.BuilderMethods;
import org.inferred.freebuilder.processor.Datatype;
import org.inferred.freebuilder.processor.Declarations;
import org.inferred.freebuilder.processor.excerpt.CheckedList;
import org.inferred.freebuilder.processor.model.ModelUtils;
import org.inferred.freebuilder.processor.property.Property;
import org.inferred.freebuilder.processor.property.PropertyCodeGenerator;
import org.inferred.freebuilder.processor.source.Excerpt;
import org.inferred.freebuilder.processor.source.Excerpts;
import org.inferred.freebuilder.processor.source.FunctionalType;
import org.inferred.freebuilder.processor.source.LazyName;
import org.inferred.freebuilder.processor.source.SourceBuilder;
import org.inferred.freebuilder.processor.source.Type;
import org.inferred.freebuilder.processor.source.ValueType;
import org.inferred.freebuilder.processor.source.Variable;
import org.inferred.freebuilder.processor.source.feature.GuavaLibrary;
import org.inferred.freebuilder.shaded.com.google.common.annotations.VisibleForTesting;
import org.inferred.freebuilder.shaded.com.google.common.collect.ImmutableList;

class ListProperty
extends PropertyCodeGenerator {
    private final boolean needsSafeVarargs;
    private final boolean overridesAddMethod;
    private final boolean overridesVarargsAddMethod;
    private final TypeMirror elementType;
    private final Optional<TypeMirror> unboxedType;
    private final FunctionalType mutatorType;

    @VisibleForTesting
    ListProperty(Datatype datatype, Property property, boolean needsSafeVarargs, boolean overridesAddMethod, boolean overridesVarargsAddMethod, TypeMirror elementType, Optional<TypeMirror> unboxedType, FunctionalType mutatorType) {
        super(datatype, property);
        this.needsSafeVarargs = needsSafeVarargs;
        this.overridesAddMethod = overridesAddMethod;
        this.overridesVarargsAddMethod = overridesVarargsAddMethod;
        this.elementType = elementType;
        this.unboxedType = unboxedType;
        this.mutatorType = mutatorType;
    }

    @Override
    public void addBuilderFieldDeclaration(SourceBuilder code) {
        if (code.feature(GuavaLibrary.GUAVA).isAvailable()) {
            code.addLine("private %s<%s> %s = %s.of();", List.class, this.elementType, this.property.getField(), ImmutableList.class);
        } else {
            code.addLine("private final %1$s<%2$s> %3$s = new %1$s<>();", ArrayList.class, this.elementType, this.property.getField());
        }
    }

    @Override
    public void addBuilderFieldAccessors(SourceBuilder code) {
        this.addAdd(code);
        this.addVarargsAdd(code);
        this.addSpliteratorAddAll(code);
        this.addStreamAddAll(code);
        this.addIterableAddAll(code);
        this.addMutate(code);
        this.addClear(code);
        this.addGetter(code);
    }

    private void addAdd(SourceBuilder code) {
        code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Adds {@code element} to the list to be returned from %s.", this.datatype.getType().javadocNoArgMethodLink(this.property.getGetterName())).addLine(" *", new Object[0]).addLine(" * @return this {@code %s} object", this.datatype.getBuilder().getSimpleName());
        if (!this.unboxedType.isPresent()) {
            code.addLine(" * @throws NullPointerException if {@code element} is null", new Object[0]);
        }
        code.addLine(" */", new Object[0]).addLine("public %s %s(%s element) {", this.datatype.getBuilder(), BuilderMethods.addMethod(this.property), this.unboxedType.orElse(this.elementType));
        if (code.feature(GuavaLibrary.GUAVA).isAvailable()) {
            code.addLine("  if (%s instanceof %s) {", this.property.getField(), ImmutableList.class).addLine("    %1$s = new %2$s<>(%1$s);", this.property.getField(), ArrayList.class).addLine("  }", new Object[0]);
        }
        if (this.unboxedType.isPresent()) {
            code.addLine("  %s.add(element);", this.property.getField());
        } else {
            code.addLine("  %s.add(%s.requireNonNull(element));", this.property.getField(), Objects.class);
        }
        code.addLine("  return (%s) this;", this.datatype.getBuilder()).addLine("}", new Object[0]);
    }

    private void addVarargsAdd(SourceBuilder code) {
        code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Adds each element of {@code elements} to the list to be returned from", new Object[0]).addLine(" * %s.", this.datatype.getType().javadocNoArgMethodLink(this.property.getGetterName())).addLine(" *", new Object[0]).addLine(" * @return this {@code %s} object", this.datatype.getBuilder().getSimpleName());
        if (!this.unboxedType.isPresent()) {
            code.addLine(" * @throws NullPointerException if {@code elements} is null or contains a", new Object[0]).addLine(" *     null element", new Object[0]);
        }
        code.addLine(" */", new Object[0]);
        if (this.needsSafeVarargs) {
            if (!this.overridesVarargsAddMethod) {
                code.addLine("@%s", SafeVarargs.class).addLine("@%s({\"varargs\"})", SuppressWarnings.class);
            } else {
                code.addLine("@%s({\"unchecked\", \"varargs\"})", SuppressWarnings.class);
            }
        }
        code.add("public ", new Object[0]);
        if (this.needsSafeVarargs && !this.overridesVarargsAddMethod) {
            code.add("final ", new Object[0]);
        }
        code.add("%s %s(%s... elements) {\n", this.datatype.getBuilder(), BuilderMethods.addMethod(this.property), this.unboxedType.orElse(this.elementType));
        Optional<Class<?>> arrayUtils = code.feature(GuavaLibrary.GUAVA).arrayUtils(this.unboxedType.orElse(this.elementType));
        if (arrayUtils.isPresent()) {
            code.addLine("  return %s(%s.asList(elements));", BuilderMethods.addAllMethod(this.property), arrayUtils.get());
        } else {
            code.addLine("  %1$s.ensureCapacity(%1$s.size() + elements.length);", this.property.getField()).addLine("  for (%s element : elements) {", this.unboxedType.get()).addLine("    %s(element);", BuilderMethods.addMethod(this.property)).addLine("  }", new Object[0]).addLine("  return (%s) this;", this.datatype.getBuilder());
        }
        code.addLine("}", new Object[0]);
    }

    private void addSpliteratorAddAll(SourceBuilder code) {
        this.addJavadocForAddAll(code);
        code.addLine("public %s %s(%s<? extends %s> elements) {", this.datatype.getBuilder(), BuilderMethods.addAllMethod(this.property), Spliterator.class, this.elementType).addLine("  if ((elements.characteristics() & %s.SIZED) != 0) {", Spliterator.class).addLine("    long elementsSize = elements.estimateSize();", new Object[0]).addLine("    if (elementsSize > 0 && elementsSize <= Integer.MAX_VALUE) {", new Object[0]);
        if (code.feature(GuavaLibrary.GUAVA).isAvailable()) {
            code.addLine("      if (%s instanceof %s) {", this.property.getField(), ImmutableList.class).addLine("        %1$s = new %2$s<>(%1$s);", this.property.getField(), ArrayList.class).addLine("      }", new Object[0]).add("      ((%s<?>) %s)", ArrayList.class, this.property.getField());
        } else {
            code.add("      %s", this.property.getField());
        }
        code.add(".ensureCapacity(%s.size() + (int) elementsSize);%n", this.property.getField()).addLine("    }", new Object[0]).addLine("  }", new Object[0]).addLine("  elements.forEachRemaining(this::%s);", BuilderMethods.addMethod(this.property)).addLine("  return (%s) this;", this.datatype.getBuilder()).addLine("}", new Object[0]);
    }

    private void addIterableAddAll(SourceBuilder code) {
        this.addJavadocForAddAll(code);
        this.addAccessorAnnotations(code);
        code.addLine("public %s %s(%s<? extends %s> elements) {", this.datatype.getBuilder(), BuilderMethods.addAllMethod(this.property), Iterable.class, this.elementType).addLine("  return %s(elements.spliterator());", BuilderMethods.addAllMethod(this.property)).addLine("}", new Object[0]);
    }

    private void addStreamAddAll(SourceBuilder code) {
        this.addJavadocForAddAll(code);
        code.addLine("public %s %s(%s<? extends %s, ?> elements) {", this.datatype.getBuilder(), BuilderMethods.addAllMethod(this.property), BaseStream.class, this.elementType).addLine("  return %s(elements.spliterator());", BuilderMethods.addAllMethod(this.property)).addLine("}", new Object[0]);
    }

    private void addJavadocForAddAll(SourceBuilder code) {
        code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Adds each element of {@code elements} to the list to be returned from", new Object[0]).addLine(" * %s.", this.datatype.getType().javadocNoArgMethodLink(this.property.getGetterName())).addLine(" *", new Object[0]).addLine(" * @return this {@code %s} object", this.datatype.getBuilder().getSimpleName()).addLine(" * @throws NullPointerException if {@code elements} is null or contains a", new Object[0]).addLine(" *     null element", new Object[0]).addLine(" */", new Object[0]);
    }

    private void addMutate(SourceBuilder code) {
        code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Applies {@code mutator} to the list to be returned from %s.", this.datatype.getType().javadocNoArgMethodLink(this.property.getGetterName())).addLine(" *", new Object[0]).addLine(" * <p>This method mutates the list in-place. {@code mutator} is a void", new Object[0]).addLine(" * consumer, so any value returned from a lambda will be ignored. Take care", new Object[0]).addLine(" * not to call pure functions, like %s.", Type.from(Collection.class).javadocNoArgMethodLink("stream")).addLine(" *", new Object[0]).addLine(" * @return this {@code Builder} object", new Object[0]).addLine(" * @throws NullPointerException if {@code mutator} is null", new Object[0]).addLine(" */", new Object[0]).addLine("public %s %s(%s mutator) {", this.datatype.getBuilder(), BuilderMethods.mutator(this.property), this.mutatorType.getFunctionalInterface());
        if (code.feature(GuavaLibrary.GUAVA).isAvailable()) {
            code.addLine("  if (%s instanceof %s) {", this.property.getField(), ImmutableList.class).addLine("    %1$s = new %2$s<>(%1$s);", this.property.getField(), ArrayList.class).addLine("  }", new Object[0]);
        }
        if (this.overridesAddMethod) {
            code.addLine("  mutator.%s(new %s<>(%s, this::%s));", this.mutatorType.getMethodName(), CheckedList.TYPE, this.property.getField(), BuilderMethods.addMethod(this.property));
        } else {
            code.addLine("  // If %s is overridden, this method will be updated to delegate to it", BuilderMethods.addMethod(this.property)).addLine("  mutator.%s(%s);", this.mutatorType.getMethodName(), this.property.getField());
        }
        code.addLine("  return (%s) this;", this.datatype.getBuilder()).addLine("}", new Object[0]);
    }

    private void addClear(SourceBuilder code) {
        code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Clears the list to be returned from %s.", this.datatype.getType().javadocNoArgMethodLink(this.property.getGetterName())).addLine(" *", new Object[0]).addLine(" * @return this {@code %s} object", this.datatype.getBuilder().getSimpleName()).addLine(" */", new Object[0]).addLine("public %s %s() {", this.datatype.getBuilder(), BuilderMethods.clearMethod(this.property));
        if (code.feature(GuavaLibrary.GUAVA).isAvailable()) {
            code.addLine("  if (%s instanceof %s) {", this.property.getField(), ImmutableList.class).addLine("    %s = %s.of();", this.property.getField(), ImmutableList.class).addLine("  } else {", new Object[0]);
        }
        code.addLine("    %s.clear();", this.property.getField());
        if (code.feature(GuavaLibrary.GUAVA).isAvailable()) {
            code.addLine("  }", new Object[0]);
        }
        code.addLine("  return (%s) this;", this.datatype.getBuilder()).addLine("}", new Object[0]);
    }

    private void addGetter(SourceBuilder code) {
        code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Returns an unmodifiable view of the list that will be returned by", new Object[0]).addLine(" * %s.", this.datatype.getType().javadocNoArgMethodLink(this.property.getGetterName())).addLine(" * Changes to this builder will be reflected in the view.", new Object[0]).addLine(" */", new Object[0]).addLine("public %s<%s> %s() {", List.class, this.elementType, BuilderMethods.getter(this.property));
        if (code.feature(GuavaLibrary.GUAVA).isAvailable()) {
            code.addLine("  if (%s instanceof %s) {", this.property.getField(), ImmutableList.class).addLine("    %1$s = new %2$s<>(%1$s);", this.property.getField(), ArrayList.class).addLine("  }", new Object[0]);
        }
        code.addLine("  return %s.unmodifiableList(%s);", Collections.class, this.property.getField()).addLine("}", new Object[0]);
    }

    @Override
    public void addFinalFieldAssignment(SourceBuilder code, Excerpt finalField, String builder) {
        Excerpt immutableListMethod = code.feature(GuavaLibrary.GUAVA).isAvailable() ? Excerpts.add("%s.copyOf", ImmutableList.class) : ImmutableListMethod.REFERENCE;
        code.addLine("%s = %s(%s);", finalField, immutableListMethod, this.property.getField().on(builder));
    }

    @Override
    public void addMergeFromValue(SourceBuilder code, String value) {
        if (code.feature(GuavaLibrary.GUAVA).isAvailable()) {
            code.addLine("if (%s instanceof %s && %s == %s.<%s>of()) {", value, this.datatype.getValueType().getQualifiedName(), this.property.getField(), ImmutableList.class, this.elementType).addLine("  %s = %s.copyOf(%s.%s());", this.property.getField(), ImmutableList.class, value, this.property.getGetterName()).addLine("} else {", new Object[0]);
        }
        code.addLine("%s(%s.%s());", BuilderMethods.addAllMethod(this.property), value, this.property.getGetterName());
        if (code.feature(GuavaLibrary.GUAVA).isAvailable()) {
            code.addLine("}", new Object[0]);
        }
    }

    @Override
    public void addMergeFromBuilder(SourceBuilder code, String builder) {
        Variable base = Declarations.upcastToGeneratedBuilder(code, this.datatype, builder);
        code.addLine("%s(%s);", BuilderMethods.addAllMethod(this.property), this.property.getField().on(base));
    }

    @Override
    public void addSetFromResult(SourceBuilder code, Excerpt builder, Excerpt variable) {
        code.addLine("%s.%s(%s);", builder, BuilderMethods.addAllMethod(this.property), variable);
    }

    @Override
    public void addClearField(SourceBuilder code) {
        code.addLine("%s();", BuilderMethods.clearMethod(this.property));
    }

    private static class ImmutableListMethod
    extends ValueType
    implements Excerpt {
        static final LazyName REFERENCE = LazyName.of("immutableList", new ImmutableListMethod());

        private ImmutableListMethod() {
        }

        @Override
        public void addTo(SourceBuilder code) {
            code.addLine("", new Object[0]).addLine("@%s(\"unchecked\")", SuppressWarnings.class).addLine("private static <E> %1$s<E> %2$s(%1$s<E> elements) {", List.class, REFERENCE).addLine("  switch (elements.size()) {", new Object[0]).addLine("  case 0:", new Object[0]).addLine("    return %s.emptyList();", Collections.class).addLine("  case 1:", new Object[0]).addLine("    return %s.singletonList(elements.get(0));", Collections.class).addLine("  default:", new Object[0]).addLine("    return (%1$s<E>)(%1$s<?>) %2$s.unmodifiableList(%3$s.asList(", List.class, Collections.class, Arrays.class).addLine("        elements.toArray()));", Array.class).addLine("  }", new Object[0]).addLine("}", new Object[0]);
        }

        @Override
        protected void addFields(ValueType.FieldReceiver fields) {
        }
    }

    static class Factory
    implements PropertyCodeGenerator.Factory {
        Factory() {
        }

        public Optional<ListProperty> create(PropertyCodeGenerator.Config config) {
            DeclaredType type = ModelUtils.maybeDeclared(config.getProperty().getType()).orElse(null);
            if (!ModelUtils.erasesToAnyOf(type, Collection.class, List.class, ImmutableList.class)) {
                return Optional.empty();
            }
            TypeMirror elementType = ModelUtils.upperBound(config.getElements(), type.getTypeArguments().get(0));
            Optional<TypeMirror> unboxedType = ModelUtils.maybeUnbox(elementType, config.getTypes());
            boolean needsSafeVarargs = ModelUtils.needsSafeVarargs(unboxedType.orElse(elementType));
            boolean overridesAddMethod = Factory.hasAddMethodOverride(config, unboxedType.orElse(elementType));
            boolean overridesVarargsAddMethod = Factory.hasVarargsAddMethodOverride(config, unboxedType.orElse(elementType));
            FunctionalType mutatorType = FunctionalType.functionalTypeAcceptedByMethod(config.getBuilder(), BuilderMethods.mutator(config.getProperty()), FunctionalType.consumer(Factory.wildcardSuperList(elementType, config.getElements(), config.getTypes())), config.getElements(), config.getTypes());
            return Optional.of(new ListProperty(config.getDatatype(), config.getProperty(), needsSafeVarargs, overridesAddMethod, overridesVarargsAddMethod, elementType, unboxedType, mutatorType));
        }

        private static boolean hasAddMethodOverride(PropertyCodeGenerator.Config config, TypeMirror elementType) {
            return ModelUtils.overrides(config.getBuilder(), config.getTypes(), BuilderMethods.addMethod(config.getProperty()), elementType);
        }

        private static boolean hasVarargsAddMethodOverride(PropertyCodeGenerator.Config config, TypeMirror elementType) {
            return ModelUtils.overrides(config.getBuilder(), config.getTypes(), BuilderMethods.addMethod(config.getProperty()), config.getTypes().getArrayType(elementType));
        }

        private static TypeMirror wildcardSuperList(TypeMirror elementType, Elements elements, Types types) {
            TypeElement listType = elements.getTypeElement(List.class.getName());
            return types.getWildcardType(null, types.getDeclaredType(listType, elementType));
        }
    }
}

