/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.freebuilder.processor.property;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.tools.Diagnostic;
import org.inferred.freebuilder.processor.BuilderMethods;
import org.inferred.freebuilder.processor.Datatype;
import org.inferred.freebuilder.processor.Declarations;
import org.inferred.freebuilder.processor.model.MethodIntrospector;
import org.inferred.freebuilder.processor.model.ModelUtils;
import org.inferred.freebuilder.processor.property.Property;
import org.inferred.freebuilder.processor.property.PropertyCodeGenerator;
import org.inferred.freebuilder.processor.source.Excerpt;
import org.inferred.freebuilder.processor.source.FieldAccess;
import org.inferred.freebuilder.processor.source.FunctionalType;
import org.inferred.freebuilder.processor.source.QualifiedName;
import org.inferred.freebuilder.processor.source.SourceBuilder;
import org.inferred.freebuilder.processor.source.TypeClass;
import org.inferred.freebuilder.processor.source.Variable;
import org.inferred.freebuilder.shaded.com.google.common.annotations.VisibleForTesting;
import org.inferred.freebuilder.shaded.com.google.common.primitives.Primitives;

public class PrimitiveOptionalProperty
extends PropertyCodeGenerator {
    private final OptionalType optional;
    private final Optional<FunctionalType> primitiveOperator;
    private final Optional<FunctionalType> optionalOperator;

    @VisibleForTesting
    PrimitiveOptionalProperty(Datatype datatype, Property property, OptionalType optional, Optional<FunctionalType> primitiveOperator, Optional<FunctionalType> optionalOperator) {
        super(datatype, property);
        this.optional = optional;
        this.primitiveOperator = primitiveOperator;
        this.optionalOperator = optionalOperator;
    }

    @Override
    public PropertyCodeGenerator.Initially initialState() {
        return PropertyCodeGenerator.Initially.OPTIONAL;
    }

    @Override
    public void addValueFieldDeclaration(SourceBuilder code, FieldAccess finalField) {
        code.addLine("private final %s %s;", this.optional.type, finalField);
    }

    @Override
    public void addBuilderFieldDeclaration(SourceBuilder code) {
        code.addLine("private %1$s %2$s = %1$s.empty();", this.optional.type, this.property.getField());
    }

    @Override
    public void addBuilderFieldAccessors(SourceBuilder code) {
        this.addSetter(code);
        this.addOptionalSetter(code);
        this.primitiveOperator.ifPresent(operator -> this.addPrimitiveMapper(code, (FunctionalType)operator));
        this.optionalOperator.ifPresent(operator -> this.addOptionalMapper(code, (FunctionalType)operator));
        this.addClear(code);
        this.addGetter(code);
    }

    private void addSetter(SourceBuilder code) {
        code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Sets the value to be returned by %s.", this.datatype.getType().javadocNoArgMethodLink(this.property.getGetterName())).addLine(" *", new Object[0]).addLine(" * @return this {@code %s} object", this.datatype.getBuilder().getSimpleName()).addLine(" */", new Object[0]).addLine("public %s %s(%s %s) {", this.datatype.getBuilder(), BuilderMethods.setter(this.property), this.optional.primitiveType, this.property.getName()).addLine("  %s = %s.of(%s);", this.property.getField(), this.optional.type, this.property.getName()).addLine("  return (%s) this;", this.datatype.getBuilder()).addLine("}", new Object[0]);
    }

    private void addOptionalSetter(SourceBuilder code) {
        code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Sets the value to be returned by %s.", this.datatype.getType().javadocNoArgMethodLink(this.property.getGetterName())).addLine(" *", new Object[0]).addLine(" * @return this {@code %s} object", this.datatype.getBuilder().getSimpleName()).addLine(" * @throws %s if {@code %s} is null", NullPointerException.class, this.property.getName()).addLine(" */", new Object[0]);
        this.addAccessorAnnotations(code);
        code.addLine("public %s %s(%s %s) {", this.datatype.getBuilder(), BuilderMethods.setter(this.property), this.optional.type, this.property.getName()).addLine("  if (%s.isPresent()) {", this.property.getName()).addLine("    return %s(%s.%s());", BuilderMethods.setter(this.property), this.property.getName(), this.optional.getter).addLine("  } else {", new Object[0]).addLine("    return %s();", BuilderMethods.clearMethod(this.property)).addLine("  }", new Object[0]).addLine("}", new Object[0]);
    }

    private void addPrimitiveMapper(SourceBuilder code, FunctionalType mapperType) {
        code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * If the value to be returned by %s is present,", this.datatype.getType().javadocNoArgMethodLink(this.property.getGetterName())).addLine(" * replaces it by applying {@code mapper} to it and using the result.", new Object[0]);
        if (mapperType.canReturnNull()) {
            code.addLine(" *", new Object[0]).addLine(" * <p>If the result is null, clears the value.", new Object[0]);
        }
        code.addLine(" *", new Object[0]).addLine(" * @return this {@code %s} object", this.datatype.getBuilder().getSimpleName()).addLine(" * @throws NullPointerException if {@code mapper} is null", new Object[0]).addLine(" */", new Object[0]).addLine("public %s %s(%s mapper) {", this.datatype.getBuilder(), BuilderMethods.mapper(this.property), mapperType.getFunctionalInterface()).addLine("  %s.requireNonNull(mapper);", Objects.class);
        Variable value = new Variable("value");
        if (mapperType.canReturnNull()) {
            Variable result = new Variable("result");
            code.addLine("  %s.ifPresent(%s -> {", this.property.getField(), value).addLine("    %s %s = mapper.%s(%s);", Primitives.wrap(this.optional.primitiveType), result, mapperType.getMethodName(), value).addLine("    if (%s != null) {", result).addLine("      %s(%s);", BuilderMethods.setter(this.property), result).addLine("    } else {", new Object[0]).addLine("      %s();", BuilderMethods.clearMethod(this.property)).addLine("    }", new Object[0]).addLine("  });", new Object[0]);
        } else {
            code.addLine("  %1$s.ifPresent(%2$s -> %3$s(mapper.%4$s(%2$s)));", this.property.getField(), value, BuilderMethods.setter(this.property), mapperType.getMethodName());
        }
        code.addLine("  return (%s) this;", this.datatype.getBuilder()).addLine("}", new Object[0]);
    }

    private void addOptionalMapper(SourceBuilder code, FunctionalType mapperType) {
        code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Replaces the value to be returned by %s", this.datatype.getType().javadocNoArgMethodLink(this.property.getGetterName())).addLine(" * by applying {@code mapper} to it and using the result.", new Object[0]).addLine(" *", new Object[0]).addLine(" * @return this {@code %s} object", this.datatype.getBuilder().getSimpleName()).addLine(" * @throws NullPointerException if {@code mapper} is null or returns null", new Object[0]).addLine(" */", new Object[0]).addLine("public %s %s(%s mapper) {", this.datatype.getBuilder(), BuilderMethods.mapper(this.property), mapperType.getFunctionalInterface()).addLine("  return %s(mapper.%s(%s()));", BuilderMethods.setter(this.property), mapperType.getMethodName(), BuilderMethods.getter(this.property)).addLine("}", new Object[0]);
    }

    private void addClear(SourceBuilder code) {
        code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Sets the value to be returned by %s to %s.", this.datatype.getType().javadocNoArgMethodLink(this.property.getGetterName()), this.optional.type.javadocNoArgMethodLink("empty")).addLine(" *", new Object[0]).addLine(" * @return this {@code %s} object", this.datatype.getBuilder().getSimpleName()).addLine(" */", new Object[0]).addLine("public %s %s() {", this.datatype.getBuilder(), BuilderMethods.clearMethod(this.property)).addLine("  %s = %s.empty();", this.property.getField(), this.optional.type).addLine("  return (%s) this;", this.datatype.getBuilder()).addLine("}", new Object[0]);
    }

    private void addGetter(SourceBuilder code) {
        code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Returns the value that will be returned by %s.", this.datatype.getType().javadocNoArgMethodLink(this.property.getGetterName())).addLine(" */", new Object[0]).addLine("public %s %s() {", this.property.getType(), BuilderMethods.getter(this.property)).addLine("  return %s;", this.property.getField()).addLine("}", new Object[0]);
    }

    @Override
    public void addFinalFieldAssignment(SourceBuilder code, Excerpt finalField, String builder) {
        code.addLine("%s = %s;", finalField, this.property.getField().on(builder));
    }

    @Override
    public void addMergeFromValue(SourceBuilder code, String value) {
        code.addLine("%s.%s().ifPresent(this::%s);", value, this.property.getGetterName(), BuilderMethods.setter(this.property));
    }

    @Override
    public void addMergeFromBuilder(SourceBuilder code, String builder) {
        code.addLine("%s.%s().ifPresent(this::%s);", builder, BuilderMethods.getter(this.property), BuilderMethods.setter(this.property));
    }

    @Override
    public void addSetFromResult(SourceBuilder code, Excerpt builder, Excerpt variable) {
        code.addLine("%s.%s(%s);", builder, BuilderMethods.setter(this.property), variable);
    }

    @Override
    public void addClearField(SourceBuilder code) {
        Optional<Variable> defaults = Declarations.freshBuilder(code, this.datatype);
        if (defaults.isPresent()) {
            code.addLine("%s = %s;", this.property.getField(), this.property.getField().on(defaults.get()));
        } else {
            code.addLine("%s = %s.empty();", this.property.getField(), this.optional.type);
        }
    }

    @Override
    public void addToStringCondition(SourceBuilder code) {
        code.add("%s.isPresent()", this.property.getField());
    }

    @Override
    public void addToStringValue(SourceBuilder code) {
        code.add("%s.%s()", this.property.getField(), this.optional.getter);
    }

    @VisibleForTesting
    static enum OptionalType {
        INT(OptionalInt.class, Integer.TYPE, TypeKind.INT, "getAsInt"),
        LONG(OptionalLong.class, Long.TYPE, TypeKind.LONG, "getAsLong"),
        DOUBLE(OptionalDouble.class, Double.TYPE, TypeKind.DOUBLE, "getAsDouble");

        private final TypeClass type;
        private final Class<?> primitiveType;
        private final TypeKind primitiveKind;
        private final String getter;

        private OptionalType(Class<?> optionalType, Class<?> primitiveType, TypeKind primitiveKind, String getter) {
            this.type = TypeClass.fromNonGeneric(optionalType);
            this.primitiveType = primitiveType;
            this.primitiveKind = primitiveKind;
            this.getter = getter;
        }
    }

    static class Factory
    implements PropertyCodeGenerator.Factory {
        Factory() {
        }

        public Optional<PrimitiveOptionalProperty> create(PropertyCodeGenerator.Config config) {
            DeclaredType type = ModelUtils.maybeDeclared(config.getProperty().getType()).orElse(null);
            if (type == null || !type.getTypeArguments().isEmpty()) {
                return Optional.empty();
            }
            QualifiedName typename = QualifiedName.of(ModelUtils.asElement(type));
            OptionalType optionalType = Arrays.stream(OptionalType.values()).filter(candidate -> ((OptionalType)candidate).type.getQualifiedName().equals(typename)).findAny().orElse(null);
            if (optionalType == null) {
                return Optional.empty();
            }
            Factory.checkForInfiniteLoop(config, optionalType);
            PrimitiveType primitiveType = config.getTypes().getPrimitiveType(optionalType.primitiveKind);
            FunctionalType primitiveOperator = FunctionalType.primitiveUnaryOperator(primitiveType);
            FunctionalType optionalOperator = FunctionalType.unaryOperator(type);
            List<FunctionalType> declaredOperators = FunctionalType.functionalTypesAcceptedByMethod(config.getBuilder(), BuilderMethods.mapper(config.getProperty()), config.getElements(), config.getTypes());
            Optional<FunctionalType> declaredPrimitiveOperator = declaredOperators.stream().filter(t -> FunctionalType.isAssignable(t, primitiveOperator, config.getTypes())).findAny();
            Optional<FunctionalType> declaredOptionalOperator = declaredOperators.stream().filter(t -> FunctionalType.isAssignable(t, optionalOperator, config.getTypes())).findAny();
            if (!declaredPrimitiveOperator.isPresent() && !declaredOptionalOperator.isPresent()) {
                declaredPrimitiveOperator = Optional.of(primitiveOperator);
            }
            return Optional.of(new PrimitiveOptionalProperty(config.getDatatype(), config.getProperty(), optionalType, declaredPrimitiveOperator, declaredOptionalOperator));
        }

        private static void checkForInfiniteLoop(PropertyCodeGenerator.Config config, OptionalType optional) {
            ExecutableElement override = ModelUtils.override(config.getBuilder(), config.getTypes(), BuilderMethods.setter(config.getProperty()), config.getTypes().getPrimitiveType(optional.primitiveKind)).orElse(null);
            if (override == null) {
                return;
            }
            MethodIntrospector.instance(config.getEnvironment()).visitAllOwnMethodInvocations(override, (methodName, logger) -> {
                if (BuilderMethods.setter(config.getProperty()).contentEquals(methodName)) {
                    logger.logMessage(Diagnostic.Kind.ERROR, "Infinite recursive loop detected");
                }
            });
        }
    }
}

