/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.freebuilder.processor.property;

import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.inferred.freebuilder.processor.Datatype;
import org.inferred.freebuilder.processor.property.Property;
import org.inferred.freebuilder.processor.source.Excerpt;
import org.inferred.freebuilder.processor.source.FieldAccess;
import org.inferred.freebuilder.processor.source.SourceBuilder;
import org.inferred.freebuilder.processor.source.Variable;
import org.inferred.freebuilder.shaded.com.google.common.base.MoreObjects;
import org.inferred.freebuilder.shaded.com.google.common.base.Preconditions;
import org.inferred.freebuilder.shaded.com.google.common.collect.ImmutableList;
import org.inferred.freebuilder.shaded.com.google.common.collect.ImmutableMap;

public abstract class PropertyCodeGenerator {
    protected final Datatype datatype;
    protected final Property property;

    public PropertyCodeGenerator(Datatype datatype, Property property) {
        this.datatype = datatype;
        this.property = property;
    }

    public Initially initialState() {
        return Initially.HAS_DEFAULT;
    }

    public void addValueFieldDeclaration(SourceBuilder code, FieldAccess finalField) {
        code.addLine("private final %s %s;", this.property.getType(), finalField);
    }

    public abstract void addBuilderFieldDeclaration(SourceBuilder var1);

    public abstract void addBuilderFieldAccessors(SourceBuilder var1);

    public abstract void addFinalFieldAssignment(SourceBuilder var1, Excerpt var2, String var3);

    public void addPartialFieldAssignment(SourceBuilder code, Excerpt finalField, String builder) {
        this.addFinalFieldAssignment(code, finalField, builder);
    }

    public abstract void addMergeFromValue(SourceBuilder var1, String var2);

    public abstract void addMergeFromBuilder(SourceBuilder var1, String var2);

    public void addSetBuilderFromPartial(SourceBuilder code, Variable builder) {
        this.addSetFromResult(code, builder, this.property.getField());
    }

    public void addGetterAnnotations(SourceBuilder code) {
    }

    public void addReadValueFragment(SourceBuilder code, Excerpt finalField) {
        code.add("%s", finalField);
    }

    public abstract void addSetFromResult(SourceBuilder var1, Excerpt var2, Excerpt var3);

    public abstract void addClearField(SourceBuilder var1);

    public void addToStringCondition(SourceBuilder code) {
        Preconditions.checkState(this.initialState() == Initially.OPTIONAL);
        code.add("%s != null", this.property.getField());
    }

    public void addToStringValue(SourceBuilder code) {
        code.add(this.property.getField());
    }

    public void addAccessorAnnotations(SourceBuilder code) {
        for (Excerpt annotation : this.property.getAccessorAnnotations()) {
            code.add(annotation);
        }
    }

    public boolean equals(Object obj) {
        if (obj == null || !this.getClass().isInstance(obj)) {
            return false;
        }
        PropertyCodeGenerator other = (PropertyCodeGenerator)obj;
        return this.fieldValues().equals(other.fieldValues());
    }

    public int hashCode() {
        return ImmutableList.copyOf(this.fieldValues().values()).hashCode();
    }

    public String toString() {
        MoreObjects.ToStringHelper stringHelper = MoreObjects.toStringHelper(this);
        for (Map.Entry<String, Object> fieldValue : this.fieldValues().entrySet()) {
            stringHelper.add(fieldValue.getKey(), fieldValue.getValue());
        }
        return stringHelper.toString();
    }

    private Map<String, Object> fieldValues() {
        ImmutableMap.Builder<String, Object> valuesBuilder = ImmutableMap.builder();
        this.addFieldValues(this.getClass(), valuesBuilder);
        return valuesBuilder.build();
    }

    private void addFieldValues(Class<?> cls, ImmutableMap.Builder<String, Object> valuesBuilder) {
        try {
            if (cls.getSuperclass() != null) {
                this.addFieldValues(cls.getSuperclass(), valuesBuilder);
            }
            for (Field field : cls.getDeclaredFields()) {
                field.setAccessible(true);
                valuesBuilder.put(field.getName(), field.get(this));
            }
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static enum Initially {
        REQUIRED,
        OPTIONAL,
        HAS_DEFAULT;

    }

    public static interface Factory {
        public Optional<? extends PropertyCodeGenerator> create(Config var1);
    }

    public static interface Config {
        public ExecutableElement getSourceElement();

        public Datatype getDatatype();

        public Property getProperty();

        public List<? extends AnnotationMirror> getAnnotations();

        public DeclaredType getBuilder();

        public Set<String> getMethodsInvokedInBuilderConstructor();

        public ProcessingEnvironment getEnvironment();

        public Elements getElements();

        public Types getTypes();
    }
}

