/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.freebuilder.processor.property;

import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.inferred.freebuilder.processor.BuilderMethods;
import org.inferred.freebuilder.processor.Datatype;
import org.inferred.freebuilder.processor.Declarations;
import org.inferred.freebuilder.processor.excerpt.CheckedSetMultimap;
import org.inferred.freebuilder.processor.model.ModelUtils;
import org.inferred.freebuilder.processor.property.Property;
import org.inferred.freebuilder.processor.property.PropertyCodeGenerator;
import org.inferred.freebuilder.processor.source.Excerpt;
import org.inferred.freebuilder.processor.source.FunctionalType;
import org.inferred.freebuilder.processor.source.SourceBuilder;
import org.inferred.freebuilder.processor.source.Variable;
import org.inferred.freebuilder.shaded.com.google.common.base.Preconditions;
import org.inferred.freebuilder.shaded.com.google.common.collect.ImmutableSetMultimap;
import org.inferred.freebuilder.shaded.com.google.common.collect.LinkedHashMultimap;
import org.inferred.freebuilder.shaded.com.google.common.collect.Multimap;
import org.inferred.freebuilder.shaded.com.google.common.collect.Multimaps;
import org.inferred.freebuilder.shaded.com.google.common.collect.SetMultimap;

class SetMultimapProperty
extends PropertyCodeGenerator {
    private final boolean overridesPutMethod;
    private final TypeMirror keyType;
    private final Optional<TypeMirror> unboxedKeyType;
    private final TypeMirror valueType;
    private final Optional<TypeMirror> unboxedValueType;
    private final FunctionalType mutatorType;

    SetMultimapProperty(Datatype datatype, Property property, boolean overridesPutMethod, TypeMirror keyType, Optional<TypeMirror> unboxedKeyType, TypeMirror valueType, Optional<TypeMirror> unboxedValueType, FunctionalType mutatorType) {
        super(datatype, property);
        this.overridesPutMethod = overridesPutMethod;
        this.keyType = keyType;
        this.unboxedKeyType = unboxedKeyType;
        this.valueType = valueType;
        this.unboxedValueType = unboxedValueType;
        this.mutatorType = mutatorType;
    }

    @Override
    public void addBuilderFieldDeclaration(SourceBuilder code) {
        code.addLine("private final %1$s<%2$s, %3$s> %4$s = %1$s.create();", LinkedHashMultimap.class, this.keyType, this.valueType, this.property.getField());
    }

    @Override
    public void addBuilderFieldAccessors(SourceBuilder code) {
        this.addPut(code);
        this.addSingleKeyPutAll(code);
        this.addMultimapPutAll(code);
        this.addRemove(code);
        this.addRemoveAll(code);
        this.addMutate(code);
        this.addClear(code);
        this.addGetter(code);
    }

    private void addPut(SourceBuilder code) {
        code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Adds a {@code key}-{@code value} mapping to the multimap to be returned", new Object[0]).addLine(" * from %s.", this.datatype.getType().javadocNoArgMethodLink(this.property.getGetterName())).addLine(" * If the multimap already contains this mapping, then {@code %s}", BuilderMethods.putMethod(this.property)).addLine(" * has no effect (only the previously added mapping is retained).", new Object[0]).addLine(" *", new Object[0]).addLine(" * @return this {@code %s} object", this.datatype.getBuilder().getSimpleName());
        if (!this.unboxedKeyType.isPresent() || !this.unboxedValueType.isPresent()) {
            code.add(" * @throws NullPointerException if ", new Object[0]);
            if (this.unboxedKeyType.isPresent()) {
                code.add("{@code value}", new Object[0]);
            } else if (this.unboxedValueType.isPresent()) {
                code.add("{@code key}", new Object[0]);
            } else {
                code.add("either {@code key} or {@code value}", new Object[0]);
            }
            code.add(" is null\n", new Object[0]);
        }
        code.addLine(" */", new Object[0]).addLine("public %s %s(%s key, %s value) {", this.datatype.getBuilder(), BuilderMethods.putMethod(this.property), this.unboxedKeyType.orElse(this.keyType), this.unboxedValueType.orElse(this.valueType));
        if (!this.unboxedKeyType.isPresent()) {
            code.addLine("  %s.checkNotNull(key);", Preconditions.class);
        }
        if (!this.unboxedValueType.isPresent()) {
            code.addLine("  %s.checkNotNull(value);", Preconditions.class);
        }
        code.addLine("  %s.put(key, value);", this.property.getField()).addLine("  return (%s) this;", this.datatype.getBuilder()).addLine("}", new Object[0]);
    }

    private void addSingleKeyPutAll(SourceBuilder code) {
        code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Adds a collection of {@code values} with the same {@code key} to the", new Object[0]).addLine(" * multimap to be returned from %s, ignoring duplicate values", this.datatype.getType().javadocNoArgMethodLink(this.property.getGetterName())).addLine(" * (only the first duplicate value is added).", new Object[0]).addLine(" *", new Object[0]).addLine(" * @return this {@code %s} object", this.datatype.getBuilder().getSimpleName());
        if (this.unboxedKeyType.isPresent()) {
            code.addLine(" * @throws NullPointerException if {@code values} is null or contains a null element", new Object[0]);
        } else {
            code.addLine(" * @throws NullPointerException if either {@code key} or {@code values} is", new Object[0]).addLine(" *     null, or if {@code values} contains a null element", new Object[0]);
        }
        code.addLine(" */", new Object[0]).addLine("public %s %s(%s key, %s<? extends %s> values) {", this.datatype.getBuilder(), BuilderMethods.putAllMethod(this.property), this.unboxedKeyType.orElse(this.keyType), Iterable.class, this.valueType).addLine("  for (%s value : values) {", this.unboxedValueType.orElse(this.valueType)).addLine("    %s(key, value);", BuilderMethods.putMethod(this.property)).addLine("  }", new Object[0]).addLine("  return (%s) this;", this.datatype.getBuilder()).addLine("}", new Object[0]);
    }

    private void addMultimapPutAll(SourceBuilder code) {
        code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Adds each mapping in {@code multimap} to the multimap to be returned from", new Object[0]).addLine(" * %s, ignoring duplicate mappings", this.datatype.getType().javadocNoArgMethodLink(this.property.getGetterName())).addLine(" * (only the first duplicate mapping is added).", new Object[0]).addLine(" *", new Object[0]).addLine(" * @return this {@code %s} object", this.datatype.getBuilder().getSimpleName()).addLine(" * @throws NullPointerException if {@code multimap} is null or contains a", new Object[0]).addLine(" *     null key or value", new Object[0]).addLine(" */", new Object[0]);
        this.addAccessorAnnotations(code);
        code.addLine("public %s %s(%s<? extends %s, ? extends %s> multimap) {", this.datatype.getBuilder(), BuilderMethods.putAllMethod(this.property), Multimap.class, this.keyType, this.valueType).addLine("  for (%s<? extends %s, ? extends %s<? extends %s>> entry", Map.Entry.class, this.keyType, Collection.class, this.valueType).addLine("      : multimap.asMap().entrySet()) {", new Object[0]).addLine("    %s(entry.getKey(), entry.getValue());", BuilderMethods.putAllMethod(this.property), this.property.getCapitalizedName()).addLine("  }", new Object[0]).addLine("  return (%s) this;", this.datatype.getBuilder()).addLine("}", new Object[0]);
    }

    private void addRemove(SourceBuilder code) {
        code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Removes a single key-value pair with the key {@code key} and the value {@code value}", new Object[0]).addLine(" * from the multimap to be returned from %s.", this.datatype.getType().javadocNoArgMethodLink(this.property.getGetterName())).addLine(" *", new Object[0]).addLine(" * @return this {@code %s} object", this.datatype.getBuilder().getSimpleName());
        if (!this.unboxedKeyType.isPresent() || !this.unboxedValueType.isPresent()) {
            code.add(" * @throws NullPointerException if ", new Object[0]);
            if (this.unboxedKeyType.isPresent()) {
                code.add("{@code value}", new Object[0]);
            } else if (this.unboxedValueType.isPresent()) {
                code.add("{@code key}", new Object[0]);
            } else {
                code.add("either {@code key} or {@code value}", new Object[0]);
            }
            code.add(" is null\n", new Object[0]);
        }
        code.addLine(" */", new Object[0]).addLine("public %s %s(%s key, %s value) {", this.datatype.getBuilder(), BuilderMethods.removeMethod(this.property), this.unboxedKeyType.orElse(this.keyType), this.unboxedValueType.orElse(this.valueType));
        if (!this.unboxedKeyType.isPresent()) {
            code.addLine("  %s.checkNotNull(key);", Preconditions.class);
        }
        if (!this.unboxedValueType.isPresent()) {
            code.addLine("  %s.checkNotNull(value);", Preconditions.class);
        }
        code.addLine("  %s.remove(key, value);", this.property.getField()).addLine("  return (%s) this;", this.datatype.getBuilder()).addLine("}", new Object[0]);
    }

    private void addRemoveAll(SourceBuilder code) {
        code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Removes all values associated with the key {@code key} from the multimap to", new Object[0]).addLine(" * be returned from %s.", this.datatype.getType().javadocNoArgMethodLink(this.property.getGetterName())).addLine(" *", new Object[0]).addLine(" * @return this {@code %s} object", this.datatype.getBuilder().getSimpleName());
        if (!this.unboxedKeyType.isPresent()) {
            code.add(" * @throws NullPointerException if {@code key} is null\n", new Object[0]);
        }
        code.addLine(" */", new Object[0]).addLine("public %s %s(%s key) {", this.datatype.getBuilder(), BuilderMethods.removeAllMethod(this.property), this.unboxedKeyType.orElse(this.keyType));
        if (!this.unboxedKeyType.isPresent()) {
            code.addLine("  %s.checkNotNull(key);", Preconditions.class);
        }
        code.addLine("  %s.removeAll(key);", this.property.getField()).addLine("  return (%s) this;", this.datatype.getBuilder()).addLine("}", new Object[0]);
    }

    private void addMutate(SourceBuilder code) {
        code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Applies {@code mutator} to the multimap to be returned from %s.", this.datatype.getType().javadocNoArgMethodLink(this.property.getGetterName())).addLine(" *", new Object[0]).addLine(" * <p>This method mutates the multimap in-place. {@code mutator} is a void", new Object[0]).addLine(" * consumer, so any value returned from a lambda will be ignored.", new Object[0]).addLine(" *", new Object[0]).addLine(" * @return this {@code Builder} object", new Object[0]).addLine(" * @throws NullPointerException if {@code mutator} is null", new Object[0]).addLine(" */", new Object[0]).addLine("public %s %s(%s mutator) {", this.datatype.getBuilder(), BuilderMethods.mutator(this.property), this.mutatorType.getFunctionalInterface());
        if (this.overridesPutMethod) {
            code.addLine("  mutator.%s(new %s<>(%s, this::%s));", this.mutatorType.getMethodName(), CheckedSetMultimap.TYPE, this.property.getField(), BuilderMethods.putMethod(this.property));
        } else {
            code.addLine("  // If %s is overridden, this method will be updated to delegate to it", BuilderMethods.putMethod(this.property)).addLine("  mutator.%s(%s);", this.mutatorType.getMethodName(), this.property.getField());
        }
        code.addLine("  return (%s) this;", this.datatype.getBuilder()).addLine("}", new Object[0]);
    }

    private void addClear(SourceBuilder code) {
        code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Removes all of the mappings from the multimap to be returned from", new Object[0]).addLine(" * %s.", this.datatype.getType().javadocNoArgMethodLink(this.property.getGetterName())).addLine(" *", new Object[0]).addLine(" * @return this {@code %s} object", this.datatype.getBuilder().getSimpleName()).addLine(" */", new Object[0]).addLine("public %s %s() {", this.datatype.getBuilder(), BuilderMethods.clearMethod(this.property)).addLine("  %s.clear();", this.property.getField()).addLine("  return (%s) this;", this.datatype.getBuilder()).addLine("}", new Object[0]);
    }

    private void addGetter(SourceBuilder code) {
        code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Returns an unmodifiable view of the multimap that will be returned by", new Object[0]).addLine(" * %s.", this.datatype.getType().javadocNoArgMethodLink(this.property.getGetterName())).addLine(" * Changes to this builder will be reflected in the view.", new Object[0]).addLine(" */", new Object[0]).addLine("public %s<%s, %s> %s() {", SetMultimap.class, this.keyType, this.valueType, BuilderMethods.getter(this.property)).addLine("  return %s.unmodifiableSetMultimap(%s);", Multimaps.class, this.property.getField()).addLine("}", new Object[0]);
    }

    @Override
    public void addFinalFieldAssignment(SourceBuilder code, Excerpt finalField, String builder) {
        code.addLine("%s = %s.copyOf(%s);", finalField, ImmutableSetMultimap.class, this.property.getField().on(builder));
    }

    @Override
    public void addMergeFromValue(SourceBuilder code, String value) {
        code.addLine("%s(%s.%s());", BuilderMethods.putAllMethod(this.property), value, this.property.getGetterName());
    }

    @Override
    public void addMergeFromBuilder(SourceBuilder code, String builder) {
        Variable base = Declarations.upcastToGeneratedBuilder(code, this.datatype, builder);
        code.addLine("%s(%s);", BuilderMethods.putAllMethod(this.property), this.property.getField().on(base));
    }

    @Override
    public void addSetFromResult(SourceBuilder code, Excerpt builder, Excerpt variable) {
        code.addLine("%s.%s(%s);", builder, BuilderMethods.putAllMethod(this.property), variable);
    }

    @Override
    public void addClearField(SourceBuilder code) {
        code.addLine("%s.clear();", this.property.getField());
    }

    static class Factory
    implements PropertyCodeGenerator.Factory {
        Factory() {
        }

        public Optional<SetMultimapProperty> create(PropertyCodeGenerator.Config config) {
            Property property = config.getProperty();
            DeclaredType type = ModelUtils.maybeDeclared(property.getType()).orElse(null);
            if (!ModelUtils.erasesToAnyOf(type, SetMultimap.class, ImmutableSetMultimap.class)) {
                return Optional.empty();
            }
            TypeMirror keyType = ModelUtils.upperBound(config.getElements(), type.getTypeArguments().get(0));
            TypeMirror valueType = ModelUtils.upperBound(config.getElements(), type.getTypeArguments().get(1));
            Optional<TypeMirror> unboxedKeyType = ModelUtils.maybeUnbox(keyType, config.getTypes());
            Optional<TypeMirror> unboxedValueType = ModelUtils.maybeUnbox(valueType, config.getTypes());
            boolean overridesPutMethod = Factory.hasPutMethodOverride(config, unboxedKeyType.orElse(keyType), unboxedValueType.orElse(valueType));
            FunctionalType mutatorType = FunctionalType.functionalTypeAcceptedByMethod(config.getBuilder(), BuilderMethods.mutator(property), FunctionalType.consumer(Factory.setMultimap(keyType, valueType, config.getElements(), config.getTypes())), config.getElements(), config.getTypes());
            return Optional.of(new SetMultimapProperty(config.getDatatype(), property, overridesPutMethod, keyType, unboxedKeyType, valueType, unboxedValueType, mutatorType));
        }

        private static boolean hasPutMethodOverride(PropertyCodeGenerator.Config config, TypeMirror keyType, TypeMirror valueType) {
            return ModelUtils.overrides(config.getBuilder(), config.getTypes(), BuilderMethods.putMethod(config.getProperty()), keyType, valueType);
        }

        private static TypeMirror setMultimap(TypeMirror keyType, TypeMirror valueType, Elements elements, Types types) {
            TypeElement setMultimapType = elements.getTypeElement(SetMultimap.class.getName());
            return types.getDeclaredType(setMultimapType, keyType, valueType);
        }
    }
}

