/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.freebuilder.processor.source;

import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Stream;
import org.inferred.freebuilder.processor.source.QualifiedName;
import org.inferred.freebuilder.processor.source.ScopeHandler;

class RuntimeReflection
implements ScopeHandler.Reflection {
    private final ClassLoader classLoader;

    RuntimeReflection(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    public Optional<ScopeHandler.TypeInfo> find(String typename) {
        try {
            return Optional.of(this.classLoader.loadClass(typename)).map(x$0 -> new RuntimeTypeInfo((Class<?>)x$0));
        }
        catch (ClassNotFoundException e) {
            return Optional.empty();
        }
    }

    private static <T> Stream<T> stream(T value) {
        return value != null ? Stream.of(value) : Stream.of(new Object[0]);
    }

    private class RuntimeTypeInfo
    implements ScopeHandler.TypeInfo {
        private final Class<?> cls;
        private final QualifiedName name;

        RuntimeTypeInfo(Class<?> cls) {
            this.cls = cls;
            this.name = QualifiedName.of(cls);
        }

        @Override
        public QualifiedName name() {
            return this.name;
        }

        @Override
        public ScopeHandler.Visibility visibility() {
            int modifiers = this.cls.getModifiers();
            if (Modifier.isPublic(modifiers)) {
                return ScopeHandler.Visibility.PUBLIC;
            }
            if (Modifier.isProtected(modifiers)) {
                return ScopeHandler.Visibility.PROTECTED;
            }
            if (Modifier.isPrivate(modifiers)) {
                return ScopeHandler.Visibility.PRIVATE;
            }
            if (this.cls.getEnclosingClass() != null && this.cls.getEnclosingClass().isInterface()) {
                return ScopeHandler.Visibility.PUBLIC;
            }
            return ScopeHandler.Visibility.PROTECTED;
        }

        @Override
        public Stream<ScopeHandler.TypeInfo> supertypes() {
            return Stream.concat(RuntimeReflection.stream(this.cls.getSuperclass()), Arrays.stream(this.cls.getInterfaces())).map(x$0 -> new RuntimeTypeInfo((Class<?>)x$0));
        }

        @Override
        public Stream<ScopeHandler.TypeInfo> nestedTypes() {
            return Arrays.stream(this.cls.getDeclaredClasses()).map(x$0 -> new RuntimeTypeInfo((Class<?>)x$0));
        }
    }
}

