/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.freebuilder.processor.source;

import java.util.EnumSet;
import java.util.Objects;
import java.util.Optional;
import java.util.function.IntUnaryOperator;
import java.util.function.UnaryOperator;
import org.inferred.freebuilder.processor.source.QualifiedName;
import org.inferred.freebuilder.processor.source.TypeUsage;
import org.inferred.freebuilder.shaded.com.google.common.annotations.VisibleForTesting;
import org.inferred.freebuilder.shaded.com.google.common.base.Preconditions;

abstract class TypeUsage_Builder {
    private int start;
    private int end;
    private QualifiedName type;
    private QualifiedName scope = null;
    private final EnumSet<Property> _unsetProperties = EnumSet.allOf(Property.class);

    TypeUsage_Builder() {
    }

    public static TypeUsage.Builder from(TypeUsage value) {
        return new TypeUsage.Builder().mergeFrom(value);
    }

    public TypeUsage.Builder start(int start) {
        this.start = start;
        this._unsetProperties.remove((Object)Property.START);
        return (TypeUsage.Builder)this;
    }

    public TypeUsage.Builder mapStart(IntUnaryOperator mapper) {
        Objects.requireNonNull(mapper);
        return this.start(mapper.applyAsInt(this.start()));
    }

    public int start() {
        Preconditions.checkState(!this._unsetProperties.contains((Object)Property.START), "start not set");
        return this.start;
    }

    public TypeUsage.Builder end(int end) {
        this.end = end;
        this._unsetProperties.remove((Object)Property.END);
        return (TypeUsage.Builder)this;
    }

    public TypeUsage.Builder mapEnd(IntUnaryOperator mapper) {
        Objects.requireNonNull(mapper);
        return this.end(mapper.applyAsInt(this.end()));
    }

    public int end() {
        Preconditions.checkState(!this._unsetProperties.contains((Object)Property.END), "end not set");
        return this.end;
    }

    public TypeUsage.Builder type(QualifiedName type) {
        this.type = Objects.requireNonNull(type);
        this._unsetProperties.remove((Object)Property.TYPE);
        return (TypeUsage.Builder)this;
    }

    public TypeUsage.Builder mapType(UnaryOperator<QualifiedName> mapper) {
        Objects.requireNonNull(mapper);
        return this.type((QualifiedName)mapper.apply(this.type()));
    }

    public QualifiedName type() {
        Preconditions.checkState(!this._unsetProperties.contains((Object)Property.TYPE), "type not set");
        return this.type;
    }

    public TypeUsage.Builder scope(QualifiedName scope) {
        this.scope = Objects.requireNonNull(scope);
        return (TypeUsage.Builder)this;
    }

    public TypeUsage.Builder scope(Optional<? extends QualifiedName> scope) {
        if (scope.isPresent()) {
            return this.scope(scope.get());
        }
        return this.clearScope();
    }

    public TypeUsage.Builder nullableScope(QualifiedName scope) {
        if (scope != null) {
            return this.scope(scope);
        }
        return this.clearScope();
    }

    public TypeUsage.Builder mapScope(UnaryOperator<QualifiedName> mapper) {
        return this.scope(this.scope().map(mapper));
    }

    public TypeUsage.Builder clearScope() {
        this.scope = null;
        return (TypeUsage.Builder)this;
    }

    public Optional<QualifiedName> scope() {
        return Optional.ofNullable(this.scope);
    }

    public TypeUsage.Builder mergeFrom(TypeUsage value) {
        TypeUsage.Builder defaults = new TypeUsage.Builder();
        if (defaults._unsetProperties.contains((Object)Property.START) || value.start() != ((TypeUsage_Builder)defaults).start()) {
            this.start(value.start());
        }
        if (defaults._unsetProperties.contains((Object)Property.END) || value.end() != ((TypeUsage_Builder)defaults).end()) {
            this.end(value.end());
        }
        if (defaults._unsetProperties.contains((Object)Property.TYPE) || !Objects.equals(value.type(), ((TypeUsage_Builder)defaults).type())) {
            this.type(value.type());
        }
        value.scope().ifPresent(this::scope);
        return (TypeUsage.Builder)this;
    }

    public TypeUsage.Builder mergeFrom(TypeUsage.Builder template) {
        TypeUsage.Builder base = template;
        TypeUsage.Builder defaults = new TypeUsage.Builder();
        if (!base._unsetProperties.contains((Object)Property.START) && (defaults._unsetProperties.contains((Object)Property.START) || template.start() != ((TypeUsage_Builder)defaults).start())) {
            this.start(template.start());
        }
        if (!base._unsetProperties.contains((Object)Property.END) && (defaults._unsetProperties.contains((Object)Property.END) || template.end() != ((TypeUsage_Builder)defaults).end())) {
            this.end(template.end());
        }
        if (!(base._unsetProperties.contains((Object)Property.TYPE) || !defaults._unsetProperties.contains((Object)Property.TYPE) && Objects.equals(template.type(), ((TypeUsage_Builder)defaults).type()))) {
            this.type(template.type());
        }
        template.scope().ifPresent(this::scope);
        return (TypeUsage.Builder)this;
    }

    public TypeUsage.Builder clear() {
        TypeUsage.Builder defaults = new TypeUsage.Builder();
        this.start = defaults.start;
        this.end = defaults.end;
        this.type = defaults.type;
        this.scope = defaults.scope;
        this._unsetProperties.clear();
        this._unsetProperties.addAll(defaults._unsetProperties);
        return (TypeUsage.Builder)this;
    }

    public TypeUsage build() {
        Preconditions.checkState(this._unsetProperties.isEmpty(), "Not set: %s", this._unsetProperties);
        return new Value(this);
    }

    @VisibleForTesting
    public TypeUsage buildPartial() {
        return new Partial(this);
    }

    private static final class Partial
    implements TypeUsage {
        private final int start;
        private final int end;
        private final QualifiedName type;
        private final QualifiedName scope;
        private final EnumSet<Property> _unsetProperties;

        Partial(TypeUsage_Builder builder) {
            this.start = builder.start;
            this.end = builder.end;
            this.type = builder.type;
            this.scope = builder.scope;
            this._unsetProperties = builder._unsetProperties.clone();
        }

        @Override
        public int start() {
            if (this._unsetProperties.contains((Object)Property.START)) {
                throw new UnsupportedOperationException("start not set");
            }
            return this.start;
        }

        @Override
        public int end() {
            if (this._unsetProperties.contains((Object)Property.END)) {
                throw new UnsupportedOperationException("end not set");
            }
            return this.end;
        }

        @Override
        public QualifiedName type() {
            if (this._unsetProperties.contains((Object)Property.TYPE)) {
                throw new UnsupportedOperationException("type not set");
            }
            return this.type;
        }

        @Override
        public Optional<QualifiedName> scope() {
            return Optional.ofNullable(this.scope);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Partial)) {
                return false;
            }
            Partial other = (Partial)obj;
            return this.start == other.start && this.end == other.end && Objects.equals(this.type, other.type) && Objects.equals(this.scope, other.scope) && Objects.equals(this._unsetProperties, other._unsetProperties);
        }

        public int hashCode() {
            return Objects.hash(this.start, this.end, this.type, this.scope, this._unsetProperties);
        }

        public String toString() {
            StringBuilder result = new StringBuilder("partial TypeUsage{");
            String separator = "";
            if (!this._unsetProperties.contains((Object)Property.START)) {
                result.append("start=").append(this.start);
                separator = ", ";
            }
            if (!this._unsetProperties.contains((Object)Property.END)) {
                result.append(separator).append("end=").append(this.end);
                separator = ", ";
            }
            if (!this._unsetProperties.contains((Object)Property.TYPE)) {
                result.append(separator).append("type=").append(this.type);
                separator = ", ";
            }
            if (this.scope != null) {
                result.append(separator).append("scope=").append(this.scope);
            }
            return result.append("}").toString();
        }
    }

    private static final class Value
    implements TypeUsage {
        private final int start;
        private final int end;
        private final QualifiedName type;
        private final QualifiedName scope;

        private Value(TypeUsage_Builder builder) {
            this.start = builder.start;
            this.end = builder.end;
            this.type = builder.type;
            this.scope = builder.scope;
        }

        @Override
        public int start() {
            return this.start;
        }

        @Override
        public int end() {
            return this.end;
        }

        @Override
        public QualifiedName type() {
            return this.type;
        }

        @Override
        public Optional<QualifiedName> scope() {
            return Optional.ofNullable(this.scope);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Value)) {
                return false;
            }
            Value other = (Value)obj;
            return this.start == other.start && this.end == other.end && Objects.equals(this.type, other.type) && Objects.equals(this.scope, other.scope);
        }

        public int hashCode() {
            return Objects.hash(this.start, this.end, this.type, this.scope);
        }

        public String toString() {
            StringBuilder result = new StringBuilder("TypeUsage{start=").append(this.start).append(", end=").append(this.end).append(", type=").append(this.type);
            if (this.scope != null) {
                result.append(", scope=").append(this.scope);
            }
            return result.append("}").toString();
        }
    }

    private static enum Property {
        START("start"),
        END("end"),
        TYPE("type");

        private final String name;

        private Property(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

