/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.freebuilder.shaded.com.google.googlejavaformat.java;

import java.io.IOError;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.DiagnosticListener;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import javax.tools.StandardLocation;
import org.inferred.freebuilder.shaded.com.google.common.base.Predicate;
import org.inferred.freebuilder.shaded.com.google.common.collect.ImmutableList;
import org.inferred.freebuilder.shaded.com.google.common.collect.Iterables;
import org.inferred.freebuilder.shaded.com.google.common.collect.Iterators;
import org.inferred.freebuilder.shaded.com.google.common.collect.Range;
import org.inferred.freebuilder.shaded.com.google.common.collect.RangeSet;
import org.inferred.freebuilder.shaded.com.google.common.collect.TreeRangeSet;
import org.inferred.freebuilder.shaded.com.google.common.io.CharSink;
import org.inferred.freebuilder.shaded.com.google.common.io.CharSource;
import org.inferred.freebuilder.shaded.com.google.errorprone.annotations.Immutable;
import org.inferred.freebuilder.shaded.com.google.googlejavaformat.Doc;
import org.inferred.freebuilder.shaded.com.google.googlejavaformat.DocBuilder;
import org.inferred.freebuilder.shaded.com.google.googlejavaformat.FormattingError;
import org.inferred.freebuilder.shaded.com.google.googlejavaformat.Newlines;
import org.inferred.freebuilder.shaded.com.google.googlejavaformat.OpsBuilder;
import org.inferred.freebuilder.shaded.com.google.googlejavaformat.java.FormatterException;
import org.inferred.freebuilder.shaded.com.google.googlejavaformat.java.JavaCommentsHelper;
import org.inferred.freebuilder.shaded.com.google.googlejavaformat.java.JavaFormatterOptions;
import org.inferred.freebuilder.shaded.com.google.googlejavaformat.java.JavaInput;
import org.inferred.freebuilder.shaded.com.google.googlejavaformat.java.JavaInputAstVisitor;
import org.inferred.freebuilder.shaded.com.google.googlejavaformat.java.JavaOutput;
import org.inferred.freebuilder.shaded.com.google.googlejavaformat.java.ModifierOrderer;
import org.inferred.freebuilder.shaded.com.google.googlejavaformat.java.Replacement;
import org.inferred.freebuilder.shaded.org.openjdk.source.tree.Tree;
import org.inferred.freebuilder.shaded.org.openjdk.tools.javac.file.JavacFileManager;
import org.inferred.freebuilder.shaded.org.openjdk.tools.javac.parser.JavacParser;
import org.inferred.freebuilder.shaded.org.openjdk.tools.javac.parser.ParserFactory;
import org.inferred.freebuilder.shaded.org.openjdk.tools.javac.tree.JCTree;
import org.inferred.freebuilder.shaded.org.openjdk.tools.javac.util.Context;
import org.inferred.freebuilder.shaded.org.openjdk.tools.javac.util.Log;
import org.inferred.freebuilder.shaded.org.openjdk.tools.javac.util.Options;

@Immutable
public final class Formatter {
    static final Range<Integer> EMPTY_RANGE = Range.closedOpen(-1, -1);
    static final Predicate<Diagnostic<?>> ERROR_DIAGNOSTIC = new Predicate<Diagnostic<?>>(){

        @Override
        public boolean apply(Diagnostic<?> input) {
            if (input.getKind() != Diagnostic.Kind.ERROR) {
                return false;
            }
            switch (input.getCode()) {
                case "compiler.err.invalid.meth.decl.ret.type.req": {
                    return false;
                }
            }
            return true;
        }
    };
    private final JavaFormatterOptions options;

    public Formatter() {
        this(JavaFormatterOptions.defaultOptions());
    }

    public Formatter(JavaFormatterOptions options) {
        this.options = options;
    }

    static void format(final JavaInput javaInput, JavaOutput javaOutput, JavaFormatterOptions options) {
        Context context = new Context();
        DiagnosticCollector diagnostics = new DiagnosticCollector();
        context.put(DiagnosticListener.class, diagnostics);
        Options.instance(context).put("allowStringFolding", "false");
        JavacFileManager fileManager = new JavacFileManager(context, true, StandardCharsets.UTF_8);
        try {
            fileManager.setLocation(StandardLocation.PLATFORM_CLASS_PATH, ImmutableList.of());
        }
        catch (IOException e) {
            throw new IOError(e);
        }
        SimpleJavaFileObject source = new SimpleJavaFileObject(URI.create("source"), JavaFileObject.Kind.SOURCE){

            @Override
            public CharSequence getCharContent(boolean ignoreEncodingErrors) throws IOException {
                return javaInput.getText();
            }
        };
        Log.instance(context).useSource(source);
        ParserFactory parserFactory = ParserFactory.instance(context);
        JavacParser parser = parserFactory.newParser(javaInput.getText(), true, true, true);
        JCTree.JCCompilationUnit unit = parser.parseCompilationUnit();
        unit.sourcefile = source;
        javaInput.setCompilationUnit(unit);
        Iterable<Diagnostic<? extends JavaFileObject>> errorDiagnostics = Iterables.filter(diagnostics.getDiagnostics(), ERROR_DIAGNOSTIC);
        if (!Iterables.isEmpty(errorDiagnostics)) {
            throw FormattingError.fromJavacDiagnostics(errorDiagnostics);
        }
        OpsBuilder builder = new OpsBuilder(javaInput, javaOutput);
        new JavaInputAstVisitor(builder, options.indentationMultiplier()).scan((Tree)unit, null);
        builder.sync(javaInput.getText().length());
        builder.drain();
        Doc doc = new DocBuilder().withOps(builder.build()).build();
        doc.computeBreaks(javaOutput.getCommentsHelper(), options.maxLineLength(), new Doc.State(0, 0));
        doc.write(javaOutput);
        javaOutput.flush();
    }

    public void formatSource(CharSource input, CharSink output) throws FormatterException, IOException {
        output.write(this.formatSource(input.read()));
    }

    public String formatSource(String input) throws FormatterException {
        return this.formatSource(input, Collections.singleton(Range.closedOpen(0, input.length())));
    }

    public String formatSource(String input, Collection<Range<Integer>> characterRanges) throws FormatterException {
        return JavaOutput.applyReplacements(input, this.getFormatReplacements(input, characterRanges));
    }

    public ImmutableList<Replacement> getFormatReplacements(String input, Collection<Range<Integer>> characterRanges) throws FormatterException {
        JavaInput javaInput = new JavaInput(input);
        javaInput = ModifierOrderer.reorderModifiers(javaInput, characterRanges);
        String lineSeparator = Newlines.guessLineSeparator(input);
        JavaOutput javaOutput = new JavaOutput(lineSeparator, javaInput, new JavaCommentsHelper(lineSeparator, this.options));
        try {
            Formatter.format(javaInput, javaOutput, this.options);
        }
        catch (FormattingError e) {
            throw new FormatterException(e.diagnostics());
        }
        RangeSet<Integer> tokenRangeSet = javaInput.characterRangesToTokenRanges(characterRanges);
        return javaOutput.getFormatReplacements(tokenRangeSet);
    }

    public static RangeSet<Integer> lineRangesToCharRanges(String input, RangeSet<Integer> lineRanges) {
        ArrayList<Integer> lines = new ArrayList<Integer>();
        Iterators.addAll(lines, Newlines.lineOffsetIterator(input));
        lines.add(input.length() + 1);
        TreeRangeSet<Integer> characterRanges = TreeRangeSet.create();
        for (Range<Integer> lineRange : lineRanges.subRangeSet(Range.closedOpen(0, lines.size() - 1)).asRanges()) {
            int lineStart = (Integer)lines.get(lineRange.lowerEndpoint());
            int lineEnd = (Integer)lines.get(lineRange.upperEndpoint()) - 1;
            Range<Integer> range = Range.closedOpen(lineStart, lineEnd);
            characterRanges.add(range);
        }
        return characterRanges;
    }
}

