/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.freebuilder.shaded.org.openjdk.source.util;

import org.inferred.freebuilder.shaded.org.openjdk.source.tree.AnnotatedTypeTree;
import org.inferred.freebuilder.shaded.org.openjdk.source.tree.AnnotationTree;
import org.inferred.freebuilder.shaded.org.openjdk.source.tree.ArrayAccessTree;
import org.inferred.freebuilder.shaded.org.openjdk.source.tree.ArrayTypeTree;
import org.inferred.freebuilder.shaded.org.openjdk.source.tree.AssertTree;
import org.inferred.freebuilder.shaded.org.openjdk.source.tree.AssignmentTree;
import org.inferred.freebuilder.shaded.org.openjdk.source.tree.BinaryTree;
import org.inferred.freebuilder.shaded.org.openjdk.source.tree.BlockTree;
import org.inferred.freebuilder.shaded.org.openjdk.source.tree.BreakTree;
import org.inferred.freebuilder.shaded.org.openjdk.source.tree.CaseTree;
import org.inferred.freebuilder.shaded.org.openjdk.source.tree.CatchTree;
import org.inferred.freebuilder.shaded.org.openjdk.source.tree.ClassTree;
import org.inferred.freebuilder.shaded.org.openjdk.source.tree.CompilationUnitTree;
import org.inferred.freebuilder.shaded.org.openjdk.source.tree.CompoundAssignmentTree;
import org.inferred.freebuilder.shaded.org.openjdk.source.tree.ConditionalExpressionTree;
import org.inferred.freebuilder.shaded.org.openjdk.source.tree.ContinueTree;
import org.inferred.freebuilder.shaded.org.openjdk.source.tree.DoWhileLoopTree;
import org.inferred.freebuilder.shaded.org.openjdk.source.tree.EmptyStatementTree;
import org.inferred.freebuilder.shaded.org.openjdk.source.tree.EnhancedForLoopTree;
import org.inferred.freebuilder.shaded.org.openjdk.source.tree.ErroneousTree;
import org.inferred.freebuilder.shaded.org.openjdk.source.tree.ExpressionStatementTree;
import org.inferred.freebuilder.shaded.org.openjdk.source.tree.ForLoopTree;
import org.inferred.freebuilder.shaded.org.openjdk.source.tree.IdentifierTree;
import org.inferred.freebuilder.shaded.org.openjdk.source.tree.IfTree;
import org.inferred.freebuilder.shaded.org.openjdk.source.tree.ImportTree;
import org.inferred.freebuilder.shaded.org.openjdk.source.tree.InstanceOfTree;
import org.inferred.freebuilder.shaded.org.openjdk.source.tree.IntersectionTypeTree;
import org.inferred.freebuilder.shaded.org.openjdk.source.tree.LabeledStatementTree;
import org.inferred.freebuilder.shaded.org.openjdk.source.tree.LambdaExpressionTree;
import org.inferred.freebuilder.shaded.org.openjdk.source.tree.LiteralTree;
import org.inferred.freebuilder.shaded.org.openjdk.source.tree.MemberReferenceTree;
import org.inferred.freebuilder.shaded.org.openjdk.source.tree.MemberSelectTree;
import org.inferred.freebuilder.shaded.org.openjdk.source.tree.MethodInvocationTree;
import org.inferred.freebuilder.shaded.org.openjdk.source.tree.MethodTree;
import org.inferred.freebuilder.shaded.org.openjdk.source.tree.ModifiersTree;
import org.inferred.freebuilder.shaded.org.openjdk.source.tree.NewArrayTree;
import org.inferred.freebuilder.shaded.org.openjdk.source.tree.NewClassTree;
import org.inferred.freebuilder.shaded.org.openjdk.source.tree.PackageTree;
import org.inferred.freebuilder.shaded.org.openjdk.source.tree.ParameterizedTypeTree;
import org.inferred.freebuilder.shaded.org.openjdk.source.tree.ParenthesizedTree;
import org.inferred.freebuilder.shaded.org.openjdk.source.tree.PrimitiveTypeTree;
import org.inferred.freebuilder.shaded.org.openjdk.source.tree.ReturnTree;
import org.inferred.freebuilder.shaded.org.openjdk.source.tree.SwitchTree;
import org.inferred.freebuilder.shaded.org.openjdk.source.tree.SynchronizedTree;
import org.inferred.freebuilder.shaded.org.openjdk.source.tree.ThrowTree;
import org.inferred.freebuilder.shaded.org.openjdk.source.tree.Tree;
import org.inferred.freebuilder.shaded.org.openjdk.source.tree.TreeVisitor;
import org.inferred.freebuilder.shaded.org.openjdk.source.tree.TryTree;
import org.inferred.freebuilder.shaded.org.openjdk.source.tree.TypeCastTree;
import org.inferred.freebuilder.shaded.org.openjdk.source.tree.TypeParameterTree;
import org.inferred.freebuilder.shaded.org.openjdk.source.tree.UnaryTree;
import org.inferred.freebuilder.shaded.org.openjdk.source.tree.UnionTypeTree;
import org.inferred.freebuilder.shaded.org.openjdk.source.tree.VariableTree;
import org.inferred.freebuilder.shaded.org.openjdk.source.tree.WhileLoopTree;
import org.inferred.freebuilder.shaded.org.openjdk.source.tree.WildcardTree;

public class TreeScanner<R, P>
implements TreeVisitor<R, P> {
    public R scan(Tree tree, P p) {
        return tree == null ? null : (R)tree.accept(this, p);
    }

    private R scanAndReduce(Tree node, P p, R r) {
        return this.reduce(this.scan(node, p), r);
    }

    public R scan(Iterable<? extends Tree> nodes, P p) {
        R r = null;
        if (nodes != null) {
            boolean first = true;
            for (Tree tree : nodes) {
                r = (R)(first ? this.scan(tree, p) : this.scanAndReduce(tree, p, r));
                first = false;
            }
        }
        return r;
    }

    private R scanAndReduce(Iterable<? extends Tree> nodes, P p, R r) {
        return this.reduce(this.scan(nodes, p), r);
    }

    public R reduce(R r1, R r2) {
        return r1;
    }

    @Override
    public R visitCompilationUnit(CompilationUnitTree node, P p) {
        R r = this.scan(node.getPackage(), p);
        r = this.scanAndReduce(node.getImports(), p, r);
        r = this.scanAndReduce(node.getTypeDecls(), p, r);
        return r;
    }

    @Override
    public R visitPackage(PackageTree node, P p) {
        R r = this.scan(node.getAnnotations(), p);
        r = this.scanAndReduce(node.getPackageName(), p, r);
        return r;
    }

    @Override
    public R visitImport(ImportTree node, P p) {
        return this.scan(node.getQualifiedIdentifier(), p);
    }

    @Override
    public R visitClass(ClassTree node, P p) {
        R r = this.scan(node.getModifiers(), p);
        r = this.scanAndReduce(node.getTypeParameters(), p, r);
        r = this.scanAndReduce(node.getExtendsClause(), p, r);
        r = this.scanAndReduce(node.getImplementsClause(), p, r);
        r = this.scanAndReduce(node.getMembers(), p, r);
        return r;
    }

    @Override
    public R visitMethod(MethodTree node, P p) {
        R r = this.scan(node.getModifiers(), p);
        r = this.scanAndReduce(node.getReturnType(), p, r);
        r = this.scanAndReduce(node.getTypeParameters(), p, r);
        r = this.scanAndReduce(node.getParameters(), p, r);
        r = this.scanAndReduce(node.getReceiverParameter(), p, r);
        r = this.scanAndReduce(node.getThrows(), p, r);
        r = this.scanAndReduce(node.getBody(), p, r);
        r = this.scanAndReduce(node.getDefaultValue(), p, r);
        return r;
    }

    @Override
    public R visitVariable(VariableTree node, P p) {
        R r = this.scan(node.getModifiers(), p);
        r = this.scanAndReduce(node.getType(), p, r);
        r = this.scanAndReduce(node.getNameExpression(), p, r);
        r = this.scanAndReduce(node.getInitializer(), p, r);
        return r;
    }

    @Override
    public R visitEmptyStatement(EmptyStatementTree node, P p) {
        return null;
    }

    @Override
    public R visitBlock(BlockTree node, P p) {
        return this.scan(node.getStatements(), p);
    }

    @Override
    public R visitDoWhileLoop(DoWhileLoopTree node, P p) {
        R r = this.scan(node.getStatement(), p);
        r = this.scanAndReduce(node.getCondition(), p, r);
        return r;
    }

    @Override
    public R visitWhileLoop(WhileLoopTree node, P p) {
        R r = this.scan(node.getCondition(), p);
        r = this.scanAndReduce(node.getStatement(), p, r);
        return r;
    }

    @Override
    public R visitForLoop(ForLoopTree node, P p) {
        R r = this.scan(node.getInitializer(), p);
        r = this.scanAndReduce(node.getCondition(), p, r);
        r = this.scanAndReduce(node.getUpdate(), p, r);
        r = this.scanAndReduce(node.getStatement(), p, r);
        return r;
    }

    @Override
    public R visitEnhancedForLoop(EnhancedForLoopTree node, P p) {
        R r = this.scan(node.getVariable(), p);
        r = this.scanAndReduce(node.getExpression(), p, r);
        r = this.scanAndReduce(node.getStatement(), p, r);
        return r;
    }

    @Override
    public R visitLabeledStatement(LabeledStatementTree node, P p) {
        return this.scan(node.getStatement(), p);
    }

    @Override
    public R visitSwitch(SwitchTree node, P p) {
        R r = this.scan(node.getExpression(), p);
        r = this.scanAndReduce(node.getCases(), p, r);
        return r;
    }

    @Override
    public R visitCase(CaseTree node, P p) {
        R r = this.scan(node.getExpression(), p);
        r = this.scanAndReduce(node.getStatements(), p, r);
        return r;
    }

    @Override
    public R visitSynchronized(SynchronizedTree node, P p) {
        R r = this.scan(node.getExpression(), p);
        r = this.scanAndReduce(node.getBlock(), p, r);
        return r;
    }

    @Override
    public R visitTry(TryTree node, P p) {
        R r = this.scan(node.getResources(), p);
        r = this.scanAndReduce(node.getBlock(), p, r);
        r = this.scanAndReduce(node.getCatches(), p, r);
        r = this.scanAndReduce(node.getFinallyBlock(), p, r);
        return r;
    }

    @Override
    public R visitCatch(CatchTree node, P p) {
        R r = this.scan(node.getParameter(), p);
        r = this.scanAndReduce(node.getBlock(), p, r);
        return r;
    }

    @Override
    public R visitConditionalExpression(ConditionalExpressionTree node, P p) {
        R r = this.scan(node.getCondition(), p);
        r = this.scanAndReduce(node.getTrueExpression(), p, r);
        r = this.scanAndReduce(node.getFalseExpression(), p, r);
        return r;
    }

    @Override
    public R visitIf(IfTree node, P p) {
        R r = this.scan(node.getCondition(), p);
        r = this.scanAndReduce(node.getThenStatement(), p, r);
        r = this.scanAndReduce(node.getElseStatement(), p, r);
        return r;
    }

    @Override
    public R visitExpressionStatement(ExpressionStatementTree node, P p) {
        return this.scan(node.getExpression(), p);
    }

    @Override
    public R visitBreak(BreakTree node, P p) {
        return null;
    }

    @Override
    public R visitContinue(ContinueTree node, P p) {
        return null;
    }

    @Override
    public R visitReturn(ReturnTree node, P p) {
        return this.scan(node.getExpression(), p);
    }

    @Override
    public R visitThrow(ThrowTree node, P p) {
        return this.scan(node.getExpression(), p);
    }

    @Override
    public R visitAssert(AssertTree node, P p) {
        R r = this.scan(node.getCondition(), p);
        r = this.scanAndReduce(node.getDetail(), p, r);
        return r;
    }

    @Override
    public R visitMethodInvocation(MethodInvocationTree node, P p) {
        R r = this.scan(node.getTypeArguments(), p);
        r = this.scanAndReduce(node.getMethodSelect(), p, r);
        r = this.scanAndReduce(node.getArguments(), p, r);
        return r;
    }

    @Override
    public R visitNewClass(NewClassTree node, P p) {
        R r = this.scan(node.getEnclosingExpression(), p);
        r = this.scanAndReduce(node.getIdentifier(), p, r);
        r = this.scanAndReduce(node.getTypeArguments(), p, r);
        r = this.scanAndReduce(node.getArguments(), p, r);
        r = this.scanAndReduce(node.getClassBody(), p, r);
        return r;
    }

    @Override
    public R visitNewArray(NewArrayTree node, P p) {
        R r = this.scan(node.getType(), p);
        r = this.scanAndReduce(node.getDimensions(), p, r);
        r = this.scanAndReduce(node.getInitializers(), p, r);
        r = this.scanAndReduce(node.getAnnotations(), p, r);
        for (Iterable iterable : node.getDimAnnotations()) {
            r = this.scanAndReduce(iterable, p, r);
        }
        return r;
    }

    @Override
    public R visitLambdaExpression(LambdaExpressionTree node, P p) {
        R r = this.scan(node.getParameters(), p);
        r = this.scanAndReduce(node.getBody(), p, r);
        return r;
    }

    @Override
    public R visitParenthesized(ParenthesizedTree node, P p) {
        return this.scan(node.getExpression(), p);
    }

    @Override
    public R visitAssignment(AssignmentTree node, P p) {
        R r = this.scan(node.getVariable(), p);
        r = this.scanAndReduce(node.getExpression(), p, r);
        return r;
    }

    @Override
    public R visitCompoundAssignment(CompoundAssignmentTree node, P p) {
        R r = this.scan(node.getVariable(), p);
        r = this.scanAndReduce(node.getExpression(), p, r);
        return r;
    }

    @Override
    public R visitUnary(UnaryTree node, P p) {
        return this.scan(node.getExpression(), p);
    }

    @Override
    public R visitBinary(BinaryTree node, P p) {
        R r = this.scan(node.getLeftOperand(), p);
        r = this.scanAndReduce(node.getRightOperand(), p, r);
        return r;
    }

    @Override
    public R visitTypeCast(TypeCastTree node, P p) {
        R r = this.scan(node.getType(), p);
        r = this.scanAndReduce(node.getExpression(), p, r);
        return r;
    }

    @Override
    public R visitInstanceOf(InstanceOfTree node, P p) {
        R r = this.scan(node.getExpression(), p);
        r = this.scanAndReduce(node.getType(), p, r);
        return r;
    }

    @Override
    public R visitArrayAccess(ArrayAccessTree node, P p) {
        R r = this.scan(node.getExpression(), p);
        r = this.scanAndReduce(node.getIndex(), p, r);
        return r;
    }

    @Override
    public R visitMemberSelect(MemberSelectTree node, P p) {
        return this.scan(node.getExpression(), p);
    }

    @Override
    public R visitMemberReference(MemberReferenceTree node, P p) {
        R r = this.scan(node.getQualifierExpression(), p);
        r = this.scanAndReduce(node.getTypeArguments(), p, r);
        return r;
    }

    @Override
    public R visitIdentifier(IdentifierTree node, P p) {
        return null;
    }

    @Override
    public R visitLiteral(LiteralTree node, P p) {
        return null;
    }

    @Override
    public R visitPrimitiveType(PrimitiveTypeTree node, P p) {
        return null;
    }

    @Override
    public R visitArrayType(ArrayTypeTree node, P p) {
        return this.scan(node.getType(), p);
    }

    @Override
    public R visitParameterizedType(ParameterizedTypeTree node, P p) {
        R r = this.scan(node.getType(), p);
        r = this.scanAndReduce(node.getTypeArguments(), p, r);
        return r;
    }

    @Override
    public R visitUnionType(UnionTypeTree node, P p) {
        return this.scan(node.getTypeAlternatives(), p);
    }

    @Override
    public R visitIntersectionType(IntersectionTypeTree node, P p) {
        return this.scan(node.getBounds(), p);
    }

    @Override
    public R visitTypeParameter(TypeParameterTree node, P p) {
        R r = this.scan(node.getAnnotations(), p);
        r = this.scanAndReduce(node.getBounds(), p, r);
        return r;
    }

    @Override
    public R visitWildcard(WildcardTree node, P p) {
        return this.scan(node.getBound(), p);
    }

    @Override
    public R visitModifiers(ModifiersTree node, P p) {
        return this.scan(node.getAnnotations(), p);
    }

    @Override
    public R visitAnnotation(AnnotationTree node, P p) {
        R r = this.scan(node.getAnnotationType(), p);
        r = this.scanAndReduce(node.getArguments(), p, r);
        return r;
    }

    @Override
    public R visitAnnotatedType(AnnotatedTypeTree node, P p) {
        R r = this.scan(node.getAnnotations(), p);
        r = this.scanAndReduce(node.getUnderlyingType(), p, r);
        return r;
    }

    @Override
    public R visitOther(Tree node, P p) {
        return null;
    }

    @Override
    public R visitErroneous(ErroneousTree node, P p) {
        return null;
    }
}

