/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.freebuilder.shaded.org.openjdk.tools.jshell;

import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.Collectors;
import org.inferred.freebuilder.shaded.org.openjdk.tools.jshell.Diag;
import org.inferred.freebuilder.shaded.org.openjdk.tools.jshell.Unit;

final class DiagList
extends ArrayList<Diag> {
    private int cntNotStmt = 0;
    private int cntUnreach = 0;
    private int cntResolve = 0;
    private int cntOther = 0;

    DiagList() {
    }

    DiagList(Diag d) {
        this.add(d);
    }

    DiagList(Collection<? extends Diag> c) {
        this.addAll(c);
    }

    private void tally(Diag d) {
        if (d.isError()) {
            if (d.isUnreachableError()) {
                ++this.cntUnreach;
            } else if (d.isNotAStatementError()) {
                ++this.cntNotStmt;
            } else if (d.isResolutionError()) {
                ++this.cntResolve;
            } else {
                ++this.cntOther;
            }
        }
    }

    @Override
    public boolean addAll(Collection<? extends Diag> c) {
        return c.stream().filter(d -> this.add((Diag)d)).count() > 0L;
    }

    @Override
    public Diag set(int index, Diag element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(int index, Diag element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean add(Diag d) {
        boolean added = super.add(d);
        if (added) {
            this.tally(d);
        }
        return added;
    }

    @Override
    public boolean addAll(int index, Collection<? extends Diag> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    DiagList ofUnit(Unit u) {
        return this.stream().filter(d -> d.unitOrNull() == u).collect(Collectors.toCollection(() -> new DiagList()));
    }

    boolean hasErrors() {
        return this.cntNotStmt + this.cntResolve + this.cntUnreach + this.cntOther > 0;
    }

    boolean hasResolutionErrorsAndNoOthers() {
        return this.cntResolve > 0 && this.cntNotStmt + this.cntUnreach + this.cntOther == 0;
    }

    boolean hasUnreachableError() {
        return this.cntUnreach > 0;
    }

    boolean hasNotStatement() {
        return this.cntNotStmt > 0;
    }

    boolean hasOtherThanNotStatementErrors() {
        return this.cntResolve + this.cntUnreach + this.cntOther > 0;
    }
}

