/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.freebuilder.processor;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ErrorType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.SimpleTypeVisitor8;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import org.inferred.freebuilder.processor.BuilderFactory;
import org.inferred.freebuilder.processor.Datatype;
import org.inferred.freebuilder.processor.GeneratedBuilder;
import org.inferred.freebuilder.processor.GeneratedStub;
import org.inferred.freebuilder.processor.GeneratedType;
import org.inferred.freebuilder.processor.GwtSupport;
import org.inferred.freebuilder.processor.JacksonSupport;
import org.inferred.freebuilder.processor.model.MethodFinder;
import org.inferred.freebuilder.processor.model.MethodIntrospector;
import org.inferred.freebuilder.processor.model.ModelUtils;
import org.inferred.freebuilder.processor.naming.NamingConvention;
import org.inferred.freebuilder.processor.naming.NamingConventions;
import org.inferred.freebuilder.processor.property.Factories;
import org.inferred.freebuilder.processor.property.Property;
import org.inferred.freebuilder.processor.property.PropertyCodeGenerator;
import org.inferred.freebuilder.processor.source.QualifiedName;
import org.inferred.freebuilder.processor.source.Type;
import org.inferred.freebuilder.shaded.com.google.common.base.Functions;
import org.inferred.freebuilder.shaded.com.google.common.base.Objects;
import org.inferred.freebuilder.shaded.com.google.common.base.Preconditions;
import org.inferred.freebuilder.shaded.com.google.common.collect.ImmutableMap;
import org.inferred.freebuilder.shaded.com.google.common.collect.ImmutableSet;
import org.inferred.freebuilder.shaded.com.google.common.collect.Iterables;
import org.inferred.freebuilder.shaded.com.google.common.collect.Sets;

class Analyser {
    private static final String BUILDER_SIMPLE_NAME_TEMPLATE = "%s_Builder";
    private static final String USER_BUILDER_NAME = "Builder";
    private final ProcessingEnvironment env;
    private final Elements elements;
    private final Messager messager;
    private final Types types;
    private static final SimpleTypeVisitor8<Boolean, ?> CAST_IS_FULLY_CHECKED = new SimpleTypeVisitor8<Boolean, Void>(){

        @Override
        public Boolean visitArray(ArrayType t, Void p) {
            return (Boolean)this.visit(t.getComponentType());
        }

        @Override
        public Boolean visitDeclared(DeclaredType t, Void p) {
            for (TypeMirror typeMirror : t.getTypeArguments()) {
                if (((Boolean)IS_UNBOUNDED_WILDCARD.visit(typeMirror)).booleanValue()) continue;
                return false;
            }
            return true;
        }

        @Override
        protected Boolean defaultAction(TypeMirror e, Void p) {
            return true;
        }
    };
    private static final SimpleTypeVisitor8<Boolean, ?> IS_UNBOUNDED_WILDCARD = new SimpleTypeVisitor8<Boolean, Void>(){

        @Override
        public Boolean visitWildcard(WildcardType t, Void p) {
            return t.getExtendsBound() == null || t.getExtendsBound().toString().equals("java.lang.Object");
        }

        @Override
        protected Boolean defaultAction(TypeMirror e, Void p) {
            return false;
        }
    };

    Analyser(ProcessingEnvironment env, Messager messager) {
        this.env = env;
        this.elements = env.getElementUtils();
        this.messager = messager;
        this.types = env.getTypeUtils();
    }

    GeneratedType analyse(TypeElement type) throws CannotGenerateCodeException {
        PackageElement pkg = this.elements.getPackageOf(type);
        this.verifyType(type, pkg);
        QualifiedName generatedBuilder = QualifiedName.of(pkg.getQualifiedName().toString(), this.generatedBuilderSimpleName(type), new String[0]);
        List<? extends TypeParameterElement> typeParameters = type.getTypeParameters();
        DeclaredType builder = this.tryFindBuilder(generatedBuilder, type).orElse(null);
        if (builder == null) {
            return new GeneratedStub(QualifiedName.of(type), generatedBuilder.withParameters(typeParameters));
        }
        ImmutableSet<ExecutableElement> methods = MethodFinder.methodsOn(type, this.elements, errorType -> {
            throw new CannotGenerateCodeException();
        });
        Datatype.Builder constructionAndExtension = this.constructionAndExtension(builder);
        QualifiedName valueType = generatedBuilder.nestedType("Value");
        QualifiedName partialType = generatedBuilder.nestedType("Partial");
        QualifiedName propertyType = generatedBuilder.nestedType("Property");
        Datatype.Builder datatypeBuilder = new Datatype.Builder().setType(QualifiedName.of(type).withParameters(typeParameters)).setInterfaceType(type.getKind().isInterface()).mergeFrom(constructionAndExtension).setGeneratedBuilder(generatedBuilder.withParameters(typeParameters)).setValueType(valueType.withParameters(typeParameters)).setPartialType(partialType.withParameters(typeParameters)).setPropertyEnum(propertyType.withParameters(new TypeParameterElement[0])).putAllStandardMethodUnderrides(this.findUnderriddenMethods(methods)).setHasToBuilderMethod(this.hasToBuilderMethod(builder, constructionAndExtension.isExtensible(), methods)).setBuilderSerializable(this.shouldBuilderBeSerializable(builder)).setBuilder(Type.from(builder));
        Datatype baseDatatype = datatypeBuilder.build();
        Map<Property, PropertyCodeGenerator> generatorsByProperty = this.pickPropertyGenerators(type, baseDatatype, builder, this.removeNonGetterMethods(builder, methods));
        datatypeBuilder.mergeFrom(GwtSupport.gwtMetadata(type, baseDatatype, generatorsByProperty));
        return new GeneratedBuilder(datatypeBuilder.build(), generatorsByProperty);
    }

    private void verifyType(TypeElement type, PackageElement pkg) throws CannotGenerateCodeException {
        if (pkg.isUnnamed()) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, "FreeBuilder does not support types in unnamed packages", type);
            throw new CannotGenerateCodeException();
        }
        switch (type.getNestingKind()) {
            case TOP_LEVEL: {
                break;
            }
            case MEMBER: {
                if (!type.getModifiers().contains((Object)Modifier.STATIC)) {
                    this.messager.printMessage(Diagnostic.Kind.ERROR, "Inner classes cannot be FreeBuilder types (did you forget the static keyword?)", type);
                    throw new CannotGenerateCodeException();
                }
                if (type.getModifiers().contains((Object)Modifier.PRIVATE)) {
                    this.messager.printMessage(Diagnostic.Kind.ERROR, "FreeBuilder types cannot be private", type);
                    throw new CannotGenerateCodeException();
                }
                for (Element e = type.getEnclosingElement(); e != null; e = e.getEnclosingElement()) {
                    if (!e.getModifiers().contains((Object)Modifier.PRIVATE)) continue;
                    this.messager.printMessage(Diagnostic.Kind.ERROR, "FreeBuilder types cannot be private, but enclosing type " + e.getSimpleName() + " is inaccessible", type);
                    throw new CannotGenerateCodeException();
                }
                break;
            }
            default: {
                this.messager.printMessage(Diagnostic.Kind.ERROR, "Only top-level or static nested types can be FreeBuilder types", type);
                throw new CannotGenerateCodeException();
            }
        }
        switch (type.getKind()) {
            case ANNOTATION_TYPE: {
                this.messager.printMessage(Diagnostic.Kind.ERROR, "FreeBuilder does not support annotation types", type);
                throw new CannotGenerateCodeException();
            }
            case CLASS: {
                this.verifyTypeIsConstructible(type);
                break;
            }
            case ENUM: {
                this.messager.printMessage(Diagnostic.Kind.ERROR, "FreeBuilder does not support enum types", type);
                throw new CannotGenerateCodeException();
            }
            case INTERFACE: {
                break;
            }
            default: {
                throw new AssertionError((Object)("Unexpected element kind " + (Object)((Object)type.getKind())));
            }
        }
    }

    private void verifyTypeIsConstructible(TypeElement type) throws CannotGenerateCodeException {
        List<ExecutableElement> constructors = ElementFilter.constructorsIn(type.getEnclosedElements());
        if (constructors.isEmpty()) {
            return;
        }
        for (ExecutableElement constructor : constructors) {
            if (!constructor.getParameters().isEmpty()) continue;
            if (constructor.getModifiers().contains((Object)Modifier.PRIVATE)) {
                this.messager.printMessage(Diagnostic.Kind.ERROR, "FreeBuilder types must have a package-visible no-args constructor", constructor);
                throw new CannotGenerateCodeException();
            }
            return;
        }
        this.messager.printMessage(Diagnostic.Kind.ERROR, "FreeBuilder types must have a package-visible no-args constructor", type);
        throw new CannotGenerateCodeException();
    }

    private Map<Datatype.StandardMethod, Datatype.UnderrideLevel> findUnderriddenMethods(Iterable<ExecutableElement> methods) {
        LinkedHashMap<Datatype.StandardMethod, ExecutableElement> standardMethods = new LinkedHashMap<Datatype.StandardMethod, ExecutableElement>();
        for (ExecutableElement method : methods) {
            Object standardMethod = Analyser.maybeStandardMethod(method);
            if (!standardMethod.isPresent() || !Analyser.isUnderride(method)) continue;
            standardMethods.put(standardMethod.get(), method);
        }
        if (standardMethods.containsKey((Object)Datatype.StandardMethod.EQUALS) != standardMethods.containsKey((Object)Datatype.StandardMethod.HASH_CODE)) {
            ExecutableElement underriddenMethod = standardMethods.containsKey((Object)Datatype.StandardMethod.EQUALS) ? (ExecutableElement)standardMethods.get((Object)Datatype.StandardMethod.EQUALS) : (ExecutableElement)standardMethods.get((Object)Datatype.StandardMethod.HASH_CODE);
            this.messager.printMessage(Diagnostic.Kind.ERROR, "hashCode and equals must be implemented together on FreeBuilder types", underriddenMethod);
        }
        ImmutableMap.Builder<Optional<Datatype.StandardMethod>, Datatype.UnderrideLevel> result = ImmutableMap.builder();
        for (Object standardMethod : standardMethods.keySet()) {
            if (((ExecutableElement)standardMethods.get(standardMethod)).getModifiers().contains((Object)Modifier.FINAL)) {
                result.put((Optional<Datatype.StandardMethod>)standardMethod, Datatype.UnderrideLevel.FINAL);
                continue;
            }
            result.put((Optional<Datatype.StandardMethod>)standardMethod, Datatype.UnderrideLevel.OVERRIDEABLE);
        }
        return result.build();
    }

    private boolean hasToBuilderMethod(DeclaredType builder, boolean isExtensible, Iterable<ExecutableElement> methods) {
        for (ExecutableElement method : methods) {
            if (!this.isToBuilderMethod(builder, method)) continue;
            if (!isExtensible) {
                this.messager.printMessage(Diagnostic.Kind.ERROR, "No accessible no-args Builder constructor available to implement toBuilder", method);
            }
            return true;
        }
        return false;
    }

    private boolean isToBuilderMethod(DeclaredType declaredType, ExecutableElement method) {
        return method.getSimpleName().contentEquals("toBuilder") && method.getModifiers().contains((Object)Modifier.ABSTRACT) && method.getParameters().isEmpty() && this.types.isSameType(method.getReturnType(), declaredType);
    }

    private Set<ExecutableElement> removeNonGetterMethods(DeclaredType builder, Iterable<ExecutableElement> methods) {
        ImmutableSet.Builder nonUnderriddenMethods = ImmutableSet.builder();
        for (ExecutableElement method : methods) {
            boolean isAbstract = method.getModifiers().contains((Object)Modifier.ABSTRACT);
            boolean isStandardMethod = Analyser.maybeStandardMethod(method).isPresent();
            boolean isToBuilderMethod = this.isToBuilderMethod(builder, method);
            if (!isAbstract || isStandardMethod || isToBuilderMethod) continue;
            nonUnderriddenMethods.add(method);
        }
        return nonUnderriddenMethods.build();
    }

    private static boolean isUnderride(ExecutableElement method) {
        return !method.getModifiers().contains((Object)Modifier.ABSTRACT);
    }

    private Optional<DeclaredType> tryFindBuilder(QualifiedName superclass, TypeElement valueType) {
        TypeElement builderType = ElementFilter.typesIn(valueType.getEnclosedElements()).stream().filter(element -> element.getSimpleName().contentEquals(USER_BUILDER_NAME)).findAny().orElse(null);
        if (builderType == null) {
            if (valueType.getKind() == ElementKind.INTERFACE) {
                this.messager.printMessage(Diagnostic.Kind.NOTE, "Add \"class Builder extends " + superclass.getSimpleName() + " {}\" to your interface to enable the FreeBuilder API", valueType);
            } else {
                this.messager.printMessage(Diagnostic.Kind.NOTE, "Add \"public static class Builder extends " + superclass.getSimpleName() + " {}\" to your class to enable the FreeBuilder API", valueType);
            }
            return Optional.empty();
        }
        boolean extendsSuperclass = (Boolean)new IsSubclassOfGeneratedTypeVisitor(superclass, valueType.getTypeParameters()).visit(builderType.getSuperclass());
        if (!extendsSuperclass) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, "Builder extends the wrong type (should be " + superclass.getSimpleName() + ")", builderType);
            return Optional.empty();
        }
        if (builderType.getTypeParameters().size() != valueType.getTypeParameters().size()) {
            if (builderType.getTypeParameters().isEmpty()) {
                this.messager.printMessage(Diagnostic.Kind.ERROR, "Builder must be generic", builderType);
            } else {
                this.messager.printMessage(Diagnostic.Kind.ERROR, "Builder has the wrong type parameters", builderType);
            }
            return Optional.empty();
        }
        DeclaredType declaredValueType = (DeclaredType)valueType.asType();
        DeclaredType declaredBuilderType = this.types.getDeclaredType(builderType, declaredValueType.getTypeArguments().toArray(new TypeMirror[0]));
        return Optional.of(declaredBuilderType);
    }

    private Datatype.Builder constructionAndExtension(DeclaredType builder) {
        TypeElement builderElement = ModelUtils.asElement(builder);
        if (!builderElement.getModifiers().contains((Object)Modifier.STATIC)) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, "Builder must be static on FreeBuilder types", builderElement);
            return new Datatype.Builder().setExtensible(false);
        }
        return new Datatype.Builder().setExtensible(BuilderFactory.hasNoArgsConstructor(builderElement)).setBuilderFactory(BuilderFactory.from(builderElement));
    }

    private Map<Property, PropertyCodeGenerator> pickPropertyGenerators(TypeElement type, Datatype datatype, DeclaredType builder, Iterable<ExecutableElement> methods) {
        NamingConvention namingConvention = NamingConventions.determineNamingConvention(type, methods, this.messager, this.types);
        Optional<JacksonSupport> jacksonSupport = JacksonSupport.create(type, this.elements);
        Set<String> methodsInvokedInBuilderConstructor = this.getMethodsInvokedInBuilderConstructor(ModelUtils.asElement(builder));
        ImmutableMap.Builder generatorsByProperty = ImmutableMap.builder();
        for (ExecutableElement method : methods) {
            namingConvention.getPropertyNames(type, method).ifPresent(propertyBuilder -> {
                this.addPropertyData((Property.Builder)propertyBuilder, type, method, jacksonSupport);
                Property property = propertyBuilder.build();
                ConfigImpl config = new ConfigImpl(builder, datatype, property, method, methodsInvokedInBuilderConstructor);
                generatorsByProperty.put(property, Analyser.createCodeGenerator(config));
            });
        }
        return generatorsByProperty.build();
    }

    private Set<String> getMethodsInvokedInBuilderConstructor(TypeElement builder) {
        MethodIntrospector methodIntrospector = MethodIntrospector.instance(this.env);
        List<ExecutableElement> constructors = ElementFilter.constructorsIn(builder.getEnclosedElements());
        Set<Name> result = null;
        for (ExecutableElement constructor : constructors) {
            if (result == null) {
                result = methodIntrospector.getOwnMethodInvocations(constructor);
                continue;
            }
            result = Sets.intersection(result, methodIntrospector.getOwnMethodInvocations(constructor));
        }
        return ImmutableSet.copyOf(Iterables.transform(result, Functions.toStringFunction()));
    }

    private void addPropertyData(Property.Builder propertyBuilder, TypeElement valueType, ExecutableElement method, Optional<JacksonSupport> jacksonSupport) {
        TypeMirror propertyType = ModelUtils.getReturnType(valueType, method, this.types);
        propertyBuilder.setAllCapsName(Analyser.camelCaseToAllCaps(propertyBuilder.getName())).setType(propertyType).setFullyCheckedCast((Boolean)CAST_IS_FULLY_CHECKED.visit(propertyType));
        if (jacksonSupport.isPresent()) {
            jacksonSupport.get().addJacksonAnnotations(propertyBuilder, method);
        }
        if (propertyType.getKind().isPrimitive()) {
            PrimitiveType unboxedType = this.types.getPrimitiveType(propertyType.getKind());
            TypeMirror boxedType = this.types.erasure(this.types.boxedClass(unboxedType).asType());
            propertyBuilder.setBoxedType(boxedType);
        }
    }

    private static PropertyCodeGenerator createCodeGenerator(PropertyCodeGenerator.Config config) {
        for (PropertyCodeGenerator.Factory factory : Factories.PROPERTY_FACTORIES) {
            Optional<? extends PropertyCodeGenerator> codeGenerator = factory.create(config);
            if (!codeGenerator.isPresent()) continue;
            return codeGenerator.get();
        }
        throw new AssertionError((Object)"DefaultPropertyFactory not registered");
    }

    private String generatedBuilderSimpleName(TypeElement type) {
        String packageName = this.elements.getPackageOf(type).getQualifiedName().toString();
        String originalName = type.getQualifiedName().toString();
        Preconditions.checkState(originalName.startsWith(packageName + "."));
        String nameWithoutPackage = originalName.substring(packageName.length() + 1);
        return String.format(BUILDER_SIMPLE_NAME_TEMPLATE, nameWithoutPackage.replaceAll("\\.", "_"));
    }

    private boolean shouldBuilderBeSerializable(DeclaredType builder) {
        return ModelUtils.asElement(builder).getInterfaces().stream().anyMatch(this.isEqualTo(Serializable.class));
    }

    private static Optional<Datatype.StandardMethod> maybeStandardMethod(ExecutableElement method) {
        String methodName = method.getSimpleName().toString();
        if (methodName.equals("equals")) {
            if (method.getParameters().size() == 1 && method.getParameters().get(0).asType().toString().equals("java.lang.Object")) {
                return Optional.of(Datatype.StandardMethod.EQUALS);
            }
            return Optional.empty();
        }
        if (methodName.equals("hashCode")) {
            if (method.getParameters().isEmpty()) {
                return Optional.of(Datatype.StandardMethod.HASH_CODE);
            }
            return Optional.empty();
        }
        if (methodName.equals("toString")) {
            if (method.getParameters().isEmpty()) {
                return Optional.of(Datatype.StandardMethod.TO_STRING);
            }
            return Optional.empty();
        }
        return Optional.empty();
    }

    private static String camelCaseToAllCaps(String camelCase) {
        return camelCase.replaceAll("(?<=[^A-Z])(?=[A-Z])|(?<=[A-Z])(?=[A-Z][^A-Z])", "_").toUpperCase();
    }

    private Predicate<TypeMirror> isEqualTo(Class<?> cls) {
        TypeMirror typeMirror = this.elements.getTypeElement(cls.getCanonicalName()).asType();
        return input -> this.types.isSameType((TypeMirror)input, typeMirror);
    }

    private static final class IsSubclassOfGeneratedTypeVisitor
    extends SimpleTypeVisitor8<Boolean, Void> {
        private final QualifiedName superclass;
        private final List<? extends TypeParameterElement> typeParameters;

        private IsSubclassOfGeneratedTypeVisitor(QualifiedName superclass, List<? extends TypeParameterElement> typeParameters) {
            super(false);
            this.superclass = superclass;
            this.typeParameters = typeParameters;
        }

        @Override
        public Boolean visitError(ErrorType t, Void p) {
            if (this.typeParameters.isEmpty()) {
                String simpleName = t.toString();
                return Objects.equal(simpleName, this.superclass.getSimpleName());
            }
            return true;
        }

        @Override
        public Boolean visitDeclared(DeclaredType t, Void p) {
            return ModelUtils.asElement(t).getQualifiedName().contentEquals(this.superclass.toString());
        }
    }

    private class ConfigImpl
    implements PropertyCodeGenerator.Config {
        private final DeclaredType builder;
        private final Datatype datatype;
        private final Property property;
        private final ExecutableElement getterMethod;
        private final Set<String> methodsInvokedInBuilderConstructor;

        ConfigImpl(DeclaredType builder, Datatype datatype, Property property, ExecutableElement getterMethod, Set<String> methodsInvokedInBuilderConstructor) {
            this.builder = builder;
            this.datatype = datatype;
            this.property = property;
            this.getterMethod = getterMethod;
            this.methodsInvokedInBuilderConstructor = methodsInvokedInBuilderConstructor;
        }

        @Override
        public ExecutableElement getSourceElement() {
            return this.getterMethod;
        }

        @Override
        public DeclaredType getBuilder() {
            return this.builder;
        }

        @Override
        public Datatype getDatatype() {
            return this.datatype;
        }

        @Override
        public Property getProperty() {
            return this.property;
        }

        @Override
        public List<? extends AnnotationMirror> getAnnotations() {
            return this.getterMethod.getAnnotationMirrors();
        }

        @Override
        public Set<String> getMethodsInvokedInBuilderConstructor() {
            return this.methodsInvokedInBuilderConstructor;
        }

        @Override
        public ProcessingEnvironment getEnvironment() {
            return Analyser.this.env;
        }

        @Override
        public Elements getElements() {
            return Analyser.this.elements;
        }

        @Override
        public Types getTypes() {
            return Analyser.this.types;
        }
    }

    public static class CannotGenerateCodeException
    extends Exception {
    }
}

