/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.freebuilder.processor.property;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.inferred.freebuilder.processor.BuilderMethods;
import org.inferred.freebuilder.processor.Datatype;
import org.inferred.freebuilder.processor.Declarations;
import org.inferred.freebuilder.processor.excerpt.CheckedMap;
import org.inferred.freebuilder.processor.model.ModelUtils;
import org.inferred.freebuilder.processor.property.MergeAction;
import org.inferred.freebuilder.processor.property.Property;
import org.inferred.freebuilder.processor.property.PropertyCodeGenerator;
import org.inferred.freebuilder.processor.source.Excerpt;
import org.inferred.freebuilder.processor.source.Excerpts;
import org.inferred.freebuilder.processor.source.FunctionalType;
import org.inferred.freebuilder.processor.source.LazyName;
import org.inferred.freebuilder.processor.source.SourceBuilder;
import org.inferred.freebuilder.processor.source.Type;
import org.inferred.freebuilder.processor.source.ValueType;
import org.inferred.freebuilder.processor.source.Variable;
import org.inferred.freebuilder.processor.source.feature.GuavaLibrary;
import org.inferred.freebuilder.shaded.com.google.common.collect.ImmutableMap;
import org.inferred.freebuilder.shaded.com.google.common.collect.ImmutableSet;

class MapProperty
extends PropertyCodeGenerator {
    private final boolean overridesPutMethod;
    private final TypeMirror keyType;
    private final Optional<TypeMirror> unboxedKeyType;
    private final TypeMirror valueType;
    private final Optional<TypeMirror> unboxedValueType;
    private final FunctionalType mutatorType;

    MapProperty(Datatype datatype, Property property, boolean overridesPutMethod, TypeMirror keyType, Optional<TypeMirror> unboxedKeyType, TypeMirror valueType, Optional<TypeMirror> unboxedValueType, FunctionalType mutatorType) {
        super(datatype, property);
        this.overridesPutMethod = overridesPutMethod;
        this.keyType = keyType;
        this.unboxedKeyType = unboxedKeyType;
        this.valueType = valueType;
        this.unboxedValueType = unboxedValueType;
        this.mutatorType = mutatorType;
    }

    @Override
    public void addBuilderFieldDeclaration(SourceBuilder code) {
        code.addLine("private final %1$s<%2$s, %3$s> %4$s = new %1$s<>();", LinkedHashMap.class, this.keyType, this.valueType, this.property.getField());
    }

    @Override
    public void addBuilderFieldAccessors(SourceBuilder code) {
        this.addPut(code);
        this.addPutAll(code);
        this.addRemove(code);
        this.addMutate(code);
        this.addClear(code);
        this.addGetter(code);
    }

    private void addPut(SourceBuilder code) {
        code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Associates {@code key} with {@code value} in the map to be returned from", new Object[0]).addLine(" * %s.", this.datatype.getType().javadocNoArgMethodLink(this.property.getGetterName())).addLine(" * If the map previously contained a mapping for the key,", new Object[0]).addLine(" * the old value is replaced by the specified value.", new Object[0]).addLine(" *", new Object[0]).addLine(" * @return this {@code %s} object", this.datatype.getBuilder().getSimpleName());
        if (!this.unboxedKeyType.isPresent() || !this.unboxedValueType.isPresent()) {
            code.add(" * @throws NullPointerException if ", new Object[0]);
            if (this.unboxedKeyType.isPresent()) {
                code.add("{@code value} is", new Object[0]);
            } else if (this.unboxedValueType.isPresent()) {
                code.add("{@code key} is", new Object[0]);
            } else {
                code.add("either {@code key} or {@code value} are", new Object[0]);
            }
            code.add(" null\n", new Object[0]);
        }
        code.addLine(" */", new Object[0]).addLine("public %s %s(%s key, %s value) {", this.datatype.getBuilder(), BuilderMethods.putMethod(this.property), this.unboxedKeyType.orElse(this.keyType), this.unboxedValueType.orElse(this.valueType));
        if (!this.unboxedKeyType.isPresent()) {
            code.addLine("  %s.requireNonNull(key);", Objects.class);
        }
        if (!this.unboxedValueType.isPresent()) {
            code.addLine("  %s.requireNonNull(value);", Objects.class);
        }
        code.addLine("  %s.put(key, value);", this.property.getField()).addLine("  return (%s) this;", this.datatype.getBuilder()).addLine("}", new Object[0]);
    }

    private void addPutAll(SourceBuilder code) {
        code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Copies all of the mappings from {@code map} to the map to be returned from", new Object[0]).addLine(" * %s.", this.datatype.getType().javadocNoArgMethodLink(this.property.getGetterName())).addLine(" *", new Object[0]).addLine(" * @return this {@code %s} object", this.datatype.getBuilder().getSimpleName()).addLine(" * @throws NullPointerException if {@code map} is null or contains a", new Object[0]).addLine(" *     null key or value", new Object[0]).addLine(" */", new Object[0]);
        this.addAccessorAnnotations(code);
        code.addLine("public %s %s(%s<? extends %s, ? extends %s> map) {", this.datatype.getBuilder(), BuilderMethods.putAllMethod(this.property), Map.class, this.keyType, this.valueType).addLine("  for (%s<? extends %s, ? extends %s> entry : map.entrySet()) {", Map.Entry.class, this.keyType, this.valueType).addLine("    %s(entry.getKey(), entry.getValue());", BuilderMethods.putMethod(this.property)).addLine("  }", new Object[0]).addLine("  return (%s) this;", this.datatype.getBuilder()).addLine("}", new Object[0]);
    }

    private void addRemove(SourceBuilder code) {
        code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Removes the mapping for {@code key} from the map to be returned from", new Object[0]).addLine(" * %s, if one is present.", this.datatype.getType().javadocNoArgMethodLink(this.property.getGetterName())).addLine(" *", new Object[0]).addLine(" * @return this {@code %s} object", this.datatype.getBuilder().getSimpleName());
        if (!this.unboxedKeyType.isPresent()) {
            code.addLine(" * @throws NullPointerException if {@code key} is null", new Object[0]);
        }
        code.addLine(" */", new Object[0]).addLine("public %s %s(%s key) {", this.datatype.getBuilder(), BuilderMethods.removeMethod(this.property), this.unboxedKeyType.orElse(this.keyType));
        if (!this.unboxedKeyType.isPresent()) {
            code.addLine("  %s.requireNonNull(key);", Objects.class);
        }
        code.addLine("  %s.remove(key);", this.property.getField()).addLine("  return (%s) this;", this.datatype.getBuilder()).addLine("}", new Object[0]);
    }

    private void addMutate(SourceBuilder code) {
        code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Invokes {@code mutator} with the map to be returned from", new Object[0]).addLine(" * %s.", this.datatype.getType().javadocNoArgMethodLink(this.property.getGetterName())).addLine(" *", new Object[0]).addLine(" * <p>This method mutates the map in-place. {@code mutator} is a void", new Object[0]).addLine(" * consumer, so any value returned from a lambda will be ignored. Take care", new Object[0]).addLine(" * not to call pure functions, like %s.", Type.from(Collection.class).javadocNoArgMethodLink("stream")).addLine(" *", new Object[0]).addLine(" * @return this {@code Builder} object", new Object[0]).addLine(" * @throws NullPointerException if {@code mutator} is null", new Object[0]).addLine(" */", new Object[0]).addLine("public %s %s(%s mutator) {", this.datatype.getBuilder(), BuilderMethods.mutator(this.property), this.mutatorType.getFunctionalInterface());
        if (this.overridesPutMethod) {
            code.addLine("  mutator.%s(new %s<>(%s, this::%s));", this.mutatorType.getMethodName(), CheckedMap.TYPE, this.property.getField(), BuilderMethods.putMethod(this.property));
        } else {
            code.addLine("  // If %s is overridden, this method will be updated to delegate to it", BuilderMethods.putMethod(this.property)).addLine("  mutator.%s(%s);", this.mutatorType.getMethodName(), this.property.getField());
        }
        code.addLine("  return (%s) this;", this.datatype.getBuilder()).addLine("}", new Object[0]);
    }

    private void addClear(SourceBuilder code) {
        code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Removes all of the mappings from the map to be returned from ", new Object[0]).addLine(" * %s.", this.datatype.getType().javadocNoArgMethodLink(this.property.getGetterName())).addLine(" *", new Object[0]).addLine(" * @return this {@code %s} object", this.datatype.getBuilder().getSimpleName()).addLine(" */", new Object[0]).addLine("public %s %s() {", this.datatype.getBuilder(), BuilderMethods.clearMethod(this.property)).addLine("  %s.clear();", this.property.getField()).addLine("  return (%s) this;", this.datatype.getBuilder()).addLine("}", new Object[0]);
    }

    private void addGetter(SourceBuilder code) {
        code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Returns an unmodifiable view of the map that will be returned by", new Object[0]).addLine(" * %s.", this.datatype.getType().javadocNoArgMethodLink(this.property.getGetterName())).addLine(" * Changes to this builder will be reflected in the view.", new Object[0]).addLine(" */", new Object[0]).addLine("public %s<%s, %s> %s() {", Map.class, this.keyType, this.valueType, BuilderMethods.getter(this.property)).addLine("  return %s.unmodifiableMap(%s);", Collections.class, this.property.getField()).addLine("}", new Object[0]);
    }

    @Override
    public void addFinalFieldAssignment(SourceBuilder code, Excerpt finalField, String builder) {
        Excerpt immutableMapMethod = code.feature(GuavaLibrary.GUAVA).isAvailable() ? Excerpts.add("%s.copyOf", ImmutableMap.class) : ImmutableMapMethod.REFERENCE;
        code.addLine("%s = %s(%s);", finalField, immutableMapMethod, this.property.getField().on(builder));
    }

    @Override
    public void addAssignToBuilder(SourceBuilder code, Variable builder) {
        code.addLine("%s.putAll(%s);", this.property.getField().on(builder), this.property.getField());
    }

    @Override
    public void addMergeFromValue(SourceBuilder code, String value) {
        code.addLine("%s(%s.%s());", BuilderMethods.putAllMethod(this.property), value, this.property.getGetterName());
    }

    @Override
    public void addMergeFromBuilder(SourceBuilder code, String builder) {
        Variable base = Declarations.upcastToGeneratedBuilder(code, this.datatype, builder);
        code.addLine("%s(%s);", BuilderMethods.putAllMethod(this.property), this.property.getField().on(base));
    }

    @Override
    public Set<MergeAction> getMergeActions() {
        return ImmutableSet.of(MergeAction.appendingToCollections());
    }

    @Override
    public void addSetFromResult(SourceBuilder code, Excerpt builder, Excerpt variable) {
        code.addLine("%s.%s(%s);", builder, BuilderMethods.putAllMethod(this.property), variable);
    }

    @Override
    public void addClearField(SourceBuilder code) {
        code.addLine("%s.clear();", this.property.getField());
    }

    private static class ImmutableMapMethod
    extends ValueType
    implements Excerpt {
        static final LazyName REFERENCE = LazyName.of("immutableMap", new ImmutableMapMethod());

        private ImmutableMapMethod() {
        }

        @Override
        public void addTo(SourceBuilder code) {
            code.addLine("", new Object[0]).addLine("private static <K, V> %1$s<K, V> %2$s(%1$s<K, V> entries) {", Map.class, REFERENCE).addLine("  switch (entries.size()) {", new Object[0]).addLine("  case 0:", new Object[0]).addLine("    return %s.emptyMap();", Collections.class).addLine("  case 1:", new Object[0]).addLine("    %s<K, V> entry = entries.entrySet().iterator().next();", Map.Entry.class).addLine("    return %s.singletonMap(entry.getKey(), entry.getValue());", Collections.class).addLine("  default:", new Object[0]).addLine("    return %s.unmodifiableMap(new %s<>(entries));", Collections.class, LinkedHashMap.class).addLine("  }", new Object[0]).addLine("}", new Object[0]);
        }

        @Override
        protected void addFields(ValueType.FieldReceiver fields) {
        }
    }

    static class Factory
    implements PropertyCodeGenerator.Factory {
        Factory() {
        }

        public Optional<MapProperty> create(PropertyCodeGenerator.Config config) {
            Property property = config.getProperty();
            DeclaredType type = ModelUtils.maybeDeclared(property.getType()).orElse(null);
            if (!ModelUtils.erasesToAnyOf(type, Map.class, ImmutableMap.class)) {
                return Optional.empty();
            }
            TypeMirror keyType = ModelUtils.upperBound(config.getElements(), type.getTypeArguments().get(0));
            TypeMirror valueType = ModelUtils.upperBound(config.getElements(), type.getTypeArguments().get(1));
            Optional<TypeMirror> unboxedKeyType = ModelUtils.maybeUnbox(keyType, config.getTypes());
            Optional<TypeMirror> unboxedValueType = ModelUtils.maybeUnbox(valueType, config.getTypes());
            boolean overridesPutMethod = Factory.hasPutMethodOverride(config, unboxedKeyType.orElse(keyType), unboxedValueType.orElse(valueType));
            FunctionalType mutatorType = FunctionalType.functionalTypeAcceptedByMethod(config.getBuilder(), BuilderMethods.mutator(property), FunctionalType.consumer(Factory.wildcardSuperMap(keyType, valueType, config.getElements(), config.getTypes())), config.getElements(), config.getTypes());
            return Optional.of(new MapProperty(config.getDatatype(), property, overridesPutMethod, keyType, unboxedKeyType, valueType, unboxedValueType, mutatorType));
        }

        private static boolean hasPutMethodOverride(PropertyCodeGenerator.Config config, TypeMirror keyType, TypeMirror valueType) {
            return ModelUtils.overrides(config.getBuilder(), config.getTypes(), BuilderMethods.putMethod(config.getProperty()), keyType, valueType);
        }

        private static TypeMirror wildcardSuperMap(TypeMirror keyType, TypeMirror valueType, Elements elements, Types types) {
            TypeElement mapType = elements.getTypeElement(Map.class.getName());
            return types.getWildcardType(null, types.getDeclaredType(mapType, keyType, valueType));
        }
    }
}

