/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.freebuilder.processor.property;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.Spliterator;
import java.util.TreeSet;
import java.util.stream.BaseStream;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.inferred.freebuilder.processor.BuilderMethods;
import org.inferred.freebuilder.processor.Datatype;
import org.inferred.freebuilder.processor.Declarations;
import org.inferred.freebuilder.processor.excerpt.CheckedNavigableSet;
import org.inferred.freebuilder.processor.model.ModelUtils;
import org.inferred.freebuilder.processor.property.MergeAction;
import org.inferred.freebuilder.processor.property.Property;
import org.inferred.freebuilder.processor.property.PropertyCodeGenerator;
import org.inferred.freebuilder.processor.source.Excerpt;
import org.inferred.freebuilder.processor.source.FieldAccess;
import org.inferred.freebuilder.processor.source.FunctionalType;
import org.inferred.freebuilder.processor.source.PreconditionExcerpts;
import org.inferred.freebuilder.processor.source.SourceBuilder;
import org.inferred.freebuilder.processor.source.Type;
import org.inferred.freebuilder.processor.source.Variable;
import org.inferred.freebuilder.processor.source.feature.GuavaLibrary;
import org.inferred.freebuilder.shaded.com.google.common.collect.ImmutableSet;
import org.inferred.freebuilder.shaded.com.google.common.collect.ImmutableSortedSet;

class SortedSetProperty
extends PropertyCodeGenerator {
    private final TypeMirror elementType;
    private final Optional<TypeMirror> unboxedType;
    private final FunctionalType mutatorType;
    private final boolean needsSafeVarargs;
    private final boolean overridesAddMethod;
    private final boolean overridesVarargsAddMethod;

    SortedSetProperty(Datatype datatype, Property property, TypeMirror elementType, Optional<TypeMirror> unboxedType, FunctionalType mutatorType, boolean needsSafeVarargs, boolean overridesAddMethod, boolean overridesVarargsAddMethod) {
        super(datatype, property);
        this.elementType = elementType;
        this.unboxedType = unboxedType;
        this.mutatorType = mutatorType;
        this.needsSafeVarargs = needsSafeVarargs;
        this.overridesAddMethod = overridesAddMethod;
        this.overridesVarargsAddMethod = overridesVarargsAddMethod;
    }

    @Override
    public void addBuilderFieldDeclaration(SourceBuilder code) {
        code.addLine("private %s<%s> %s = null;", NavigableSet.class, this.elementType, this.property.getField());
    }

    @Override
    public void addBuilderFieldAccessors(SourceBuilder code) {
        this.addSetComparator(code);
        this.addAdd(code);
        this.addVarargsAdd(code);
        this.addSpliteratorAddAll(code);
        this.addStreamAddAll(code);
        this.addIterableAddAll(code);
        this.addRemove(code);
        this.addMutator(code);
        this.addClear(code);
        this.addGetter(code);
    }

    private void addSetComparator(SourceBuilder code) {
        code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Sets the comparator of the set to be returned from %s.", this.datatype.getType().javadocNoArgMethodLink(this.property.getGetterName())).addLine(" *", new Object[0]).addLine(" * Pass in {@code null} to use the {@linkplain %s natural ordering}", Comparable.class).addLine(" * of the elements.", new Object[0]).addLine(" *", new Object[0]).addLine(" * <p>If the set is accessed without calling this method first, the comparator", new Object[0]).addLine(" * will default to {@code null}, and cannot subsequently be changed.", new Object[0]).addLine(" * (Note that this immutability is an implementation detail that may change in", new Object[0]).addLine(" * future; it should not be relied on for correctness.)", new Object[0]).addLine(" *", new Object[0]).addLine(" * @return this {@code %s} object", this.datatype.getBuilder().getSimpleName()).addLine(" * @throws IllegalStateException if the set has been accessed at all,", new Object[0]).addLine(" *     whether by adding an element, setting the comparator, or calling", new Object[0]).addLine(" *     {@link #%s()}.", BuilderMethods.getter(this.property));
        code.addLine(" */", new Object[0]).addLine("protected %s %s(%s<? super %s> comparator) {", this.datatype.getBuilder(), BuilderMethods.setComparatorMethod(this.property), Comparator.class, this.elementType).add(PreconditionExcerpts.checkState("%1$s == null", "Comparator already set for %1$s", this.property.getField()));
        if (code.feature(GuavaLibrary.GUAVA).isAvailable()) {
            code.addLine("  if (comparator == null) {", new Object[0]).addLine("    %s = %s.of();", this.property.getField(), ImmutableSortedSet.class).addLine("  } else {", new Object[0]).addLine("    %s = new %s<%s>(comparator).build();", this.property.getField(), ImmutableSortedSet.Builder.class, this.elementType).addLine("  }", new Object[0]);
        } else {
            code.addLine("  %s = new %s<>(comparator);", this.property.getField(), TreeSet.class);
        }
        code.addLine("  return (%s) this;", this.datatype.getBuilder()).addLine("}", new Object[0]);
    }

    private void addAdd(SourceBuilder code) {
        code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Adds {@code element} to the set to be returned from %s.", this.datatype.getType().javadocNoArgMethodLink(this.property.getGetterName())).addLine(" * If the set already contains {@code element}, then {@code %s}", BuilderMethods.addMethod(this.property)).addLine(" * has no effect (only the previously added element is retained).", new Object[0]).addLine(" *", new Object[0]).addLine(" * @return this {@code %s} object", this.datatype.getBuilder().getSimpleName());
        if (!this.unboxedType.isPresent()) {
            code.addLine(" * @throws NullPointerException if {@code element} is null", new Object[0]);
        }
        code.addLine(" */", new Object[0]).addLine("public %s %s(%s element) {", this.datatype.getBuilder(), BuilderMethods.addMethod(this.property), this.unboxedType.orElse(this.elementType));
        this.addConvertToTreeSet(code);
        if (this.unboxedType.isPresent()) {
            code.addLine("  %s.add(element);", this.property.getField());
        } else {
            code.addLine("  %s.add(%s.requireNonNull(element));", this.property.getField(), Objects.class);
        }
        code.addLine("  return (%s) this;", this.datatype.getBuilder()).addLine("}", new Object[0]);
    }

    private void addConvertToTreeSet(SourceBuilder code) {
        code.addLine("  if (%s == null) {", this.property.getField()).addLine("    // Use default comparator", new Object[0]).addLine("    %s = new %s<>();", this.property.getField(), TreeSet.class);
        if (code.feature(GuavaLibrary.GUAVA).isAvailable()) {
            code.addLine("  } else if (%s instanceof %s) {", this.property.getField(), ImmutableSortedSet.class).addLine("    %1$s = new %2$s<>(%1$s);", this.property.getField(), TreeSet.class);
        }
        code.addLine("  }", new Object[0]);
    }

    private void addVarargsAdd(SourceBuilder code) {
        code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Adds each element of {@code elements} to the set to be returned from", new Object[0]).addLine(" * %s, ignoring duplicate elements", this.datatype.getType().javadocNoArgMethodLink(this.property.getGetterName())).addLine(" * (only the first duplicate element is added).", new Object[0]).addLine(" *", new Object[0]).addLine(" * @return this {@code %s} object", this.datatype.getBuilder().getSimpleName());
        if (!this.unboxedType.isPresent()) {
            code.addLine(" * @throws NullPointerException if {@code elements} is null or contains a", new Object[0]).addLine(" *     null element", new Object[0]);
        }
        code.addLine(" */", new Object[0]);
        if (this.needsSafeVarargs) {
            if (!this.overridesVarargsAddMethod) {
                code.addLine("@%s", SafeVarargs.class).addLine("@%s({\"varargs\"})", SuppressWarnings.class);
            } else {
                code.addLine("@%s({\"unchecked\", \"varargs\"})", SuppressWarnings.class);
            }
        }
        code.add("public ", new Object[0]);
        if (this.needsSafeVarargs && !this.overridesVarargsAddMethod) {
            code.add("final ", new Object[0]);
        }
        code.add("%s %s(%s... elements) {\n", this.datatype.getBuilder(), BuilderMethods.addMethod(this.property), this.unboxedType.orElse(this.elementType));
        Optional<Class<?>> arrayUtils = code.feature(GuavaLibrary.GUAVA).arrayUtils(this.unboxedType.orElse(this.elementType));
        if (arrayUtils.isPresent()) {
            code.addLine("  return %s(%s.asList(elements));", BuilderMethods.addAllMethod(this.property), arrayUtils.get());
        } else {
            code.addLine("  for (%s element : elements) {", this.elementType).addLine("    %s(element);", BuilderMethods.addMethod(this.property)).addLine("  }", new Object[0]).addLine("  return (%s) this;", this.datatype.getBuilder());
        }
        code.addLine("}", new Object[0]);
    }

    private void addSpliteratorAddAll(SourceBuilder code) {
        this.addJavadocForAddAll(code);
        code.addLine("public %s %s(%s<? extends %s> elements) {", this.datatype.getBuilder(), BuilderMethods.addAllMethod(this.property), Spliterator.class, this.elementType).addLine("  elements.forEachRemaining(this::%s);", BuilderMethods.addMethod(this.property)).addLine("  return (%s) this;", this.datatype.getBuilder()).addLine("}", new Object[0]);
    }

    private void addStreamAddAll(SourceBuilder code) {
        this.addJavadocForAddAll(code);
        code.addLine("public %s %s(%s<? extends %s, ?> elements) {", this.datatype.getBuilder(), BuilderMethods.addAllMethod(this.property), BaseStream.class, this.elementType).addLine("  return %s(elements.spliterator());", BuilderMethods.addAllMethod(this.property)).addLine("}", new Object[0]);
    }

    private void addIterableAddAll(SourceBuilder code) {
        this.addJavadocForAddAll(code);
        this.addAccessorAnnotations(code);
        code.addLine("public %s %s(%s<? extends %s> elements) {", this.datatype.getBuilder(), BuilderMethods.addAllMethod(this.property), Iterable.class, this.elementType).addLine("  elements.forEach(this::%s);", BuilderMethods.addMethod(this.property)).addLine("  return (%s) this;", this.datatype.getBuilder()).addLine("}", new Object[0]);
    }

    private void addJavadocForAddAll(SourceBuilder code) {
        code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Adds each element of {@code elements} to the set to be returned from", new Object[0]).addLine(" * %s, ignoring duplicate elements", this.datatype.getType().javadocNoArgMethodLink(this.property.getGetterName())).addLine(" * (only the first duplicate element is added).", new Object[0]).addLine(" *", new Object[0]).addLine(" * @return this {@code %s} object", this.datatype.getBuilder().getSimpleName()).addLine(" * @throws NullPointerException if {@code elements} is null or contains a", new Object[0]).addLine(" *     null element", new Object[0]).addLine(" */", new Object[0]);
    }

    private void addRemove(SourceBuilder code) {
        code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Removes {@code element} from the set to be returned from %s.", this.datatype.getType().javadocNoArgMethodLink(this.property.getGetterName())).addLine(" * Does nothing if {@code element} is not a member of the set.", new Object[0]).addLine(" *", new Object[0]).addLine(" * @return this {@code %s} object", this.datatype.getBuilder().getSimpleName());
        if (!this.unboxedType.isPresent()) {
            code.addLine(" * @throws NullPointerException if {@code element} is null", new Object[0]);
        }
        code.addLine(" */", new Object[0]).addLine("public %s %s(%s element) {", this.datatype.getBuilder(), BuilderMethods.removeMethod(this.property), this.unboxedType.orElse(this.elementType));
        this.addConvertToTreeSet(code);
        if (this.unboxedType.isPresent()) {
            code.addLine("  %s.remove(element);", this.property.getField());
        } else {
            code.addLine("  %s.remove(%s.requireNonNull(element));", this.property.getField(), Objects.class);
        }
        code.addLine("  return (%s) this;", this.datatype.getBuilder()).addLine("}", new Object[0]);
    }

    private void addMutator(SourceBuilder code) {
        code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Applies {@code mutator} to the set to be returned from %s.", this.datatype.getType().javadocNoArgMethodLink(this.property.getGetterName())).addLine(" *", new Object[0]).addLine(" * <p>This method mutates the set in-place. {@code mutator} is a void", new Object[0]).addLine(" * consumer, so any value returned from a lambda will be ignored. Take care", new Object[0]).addLine(" * not to call pure functions, like %s.", Type.from(Collection.class).javadocNoArgMethodLink("stream")).addLine(" *", new Object[0]).addLine(" * @return this {@code Builder} object", new Object[0]).addLine(" * @throws NullPointerException if {@code mutator} is null", new Object[0]).addLine(" */", new Object[0]).addLine("public %s %s(%s mutator) {", this.datatype.getBuilder(), BuilderMethods.mutator(this.property), this.mutatorType.getFunctionalInterface());
        this.addConvertToTreeSet(code);
        if (this.overridesAddMethod) {
            code.addLine("  mutator.%s(new %s<%s>(%s, this::%s));", this.mutatorType.getMethodName(), CheckedNavigableSet.TYPE, this.elementType, this.property.getField(), BuilderMethods.addMethod(this.property));
        } else {
            code.addLine("  // If %s is overridden, this method will be updated to delegate to it", BuilderMethods.addMethod(this.property)).addLine("  mutator.%s(%s);", this.mutatorType.getMethodName(), this.property.getField());
        }
        code.addLine("  return (%s) this;", this.datatype.getBuilder()).addLine("}", new Object[0]);
    }

    private void addClear(SourceBuilder code) {
        code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Clears the set to be returned from %s.", this.datatype.getType().javadocNoArgMethodLink(this.property.getGetterName())).addLine(" *", new Object[0]).addLine(" * @return this {@code %s} object", this.datatype.getBuilder().getSimpleName()).addLine(" */", new Object[0]).addLine("public %s %s() {", this.datatype.getBuilder(), BuilderMethods.clearMethod(this.property));
        if (code.feature(GuavaLibrary.GUAVA).isAvailable()) {
            code.addLine("  if (%s instanceof %s) {", this.property.getField(), ImmutableSortedSet.class).addLine("    if (%s.isEmpty()) {", this.property.getField()).addLine("       // Do nothing", new Object[0]).addLine("    } else if (%s.comparator() != null) {", this.property.getField()).addLine("      %1$s = new %2$s<%3$s>(%1$s.comparator()).build();", this.property.getField(), ImmutableSortedSet.Builder.class, this.elementType).addLine("    } else {", new Object[0]).addLine("      %s = %s.of();", this.property.getField(), ImmutableSortedSet.class).addLine("    }", new Object[0]).add("  } else ", new Object[0]);
        }
        code.addLine("  if (%s != null) {", this.property.getField()).addLine("    %s.clear();", this.property.getField()).addLine("  }", new Object[0]).addLine("  return (%s) this;", this.datatype.getBuilder()).addLine("}", new Object[0]);
    }

    private void addGetter(SourceBuilder code) {
        code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Returns an unmodifiable view of the set that will be returned by", new Object[0]).addLine(" * %s.", this.datatype.getType().javadocNoArgMethodLink(this.property.getGetterName())).addLine(" * Changes to this builder will be reflected in the view.", new Object[0]).addLine(" */", new Object[0]).addLine("public %s<%s> %s() {", SortedSet.class, this.elementType, BuilderMethods.getter(this.property));
        this.addConvertToTreeSet(code);
        code.addLine("  return %s.unmodifiableSortedSet(%s);", Collections.class, this.property.getField()).addLine("}", new Object[0]);
    }

    @Override
    public void addValueFieldDeclaration(SourceBuilder code, FieldAccess finalField) {
        if (code.feature(GuavaLibrary.GUAVA).isAvailable()) {
            code.addLine("private final %s<%s> %s;", ImmutableSortedSet.class, this.elementType, finalField);
        } else {
            code.addLine("private final %s<%s> %s;", SortedSet.class, this.elementType, finalField);
        }
    }

    @Override
    public void addFinalFieldAssignment(SourceBuilder code, Excerpt finalField, String builder) {
        code.addLine("if (%s == null) {", this.property.getField().on(builder));
        if (code.feature(GuavaLibrary.GUAVA).isAvailable()) {
            code.addLine("  %s = %s.of();", finalField, ImmutableSortedSet.class).addLine("} else if (%s instanceof %s) {", this.property.getField().on(builder), ImmutableSortedSet.class).addLine("  %s = (%s<%s>) %s;", finalField, ImmutableSortedSet.class, this.elementType, this.property.getField().on(builder)).addLine("} else {", new Object[0]).addLine("  %s = %s.copyOfSorted(%s);", finalField, ImmutableSortedSet.class, this.property.getField().on(builder));
        } else {
            code.addLine("  %s = %s.unmodifiableSortedSet(new %s<>());", finalField, Collections.class, TreeSet.class).addLine("} else {", new Object[0]).addLine("  %s = %s.unmodifiableSortedSet(new %s<>(%s));", finalField, Collections.class, TreeSet.class, this.property.getField().on(builder));
        }
        code.addLine("}", new Object[0]);
    }

    @Override
    public void addAssignToBuilder(SourceBuilder code, Variable builder) {
        if (code.feature(GuavaLibrary.GUAVA).isAvailable()) {
            code.addLine("%s = %s;", this.property.getField().on(builder), this.property.getField());
        } else {
            code.addLine("%s = new %s<>(%s);", this.property.getField().on(builder), TreeSet.class, this.property.getField());
        }
    }

    @Override
    public void addMergeFromValue(SourceBuilder code, String value) {
        if (code.feature(GuavaLibrary.GUAVA).isAvailable()) {
            code.addLine("if (%s instanceof %s", value, this.datatype.getValueType().getQualifiedName()).addLine("      && (%s == null", this.property.getField()).addLine("          || (%s instanceof %s ", this.property.getField(), ImmutableSortedSet.class).addLine("              && %s.isEmpty()", this.property.getField()).addLine("              && %s.equals(%s.comparator(), %s.%s().comparator())))) {", Objects.class, this.property.getField(), value, this.property.getGetterName()).addLine("  @%s(\"unchecked\")", SuppressWarnings.class).addLine("  %1$s<%2$s> _temporary = (%1$s<%2$s>) (%1$s<?>) %3$s.%4$s();", ImmutableSortedSet.class, this.elementType, value, this.property.getGetterName()).addLine("  %s = _temporary;", this.property.getField()).addLine("} else {", new Object[0]);
        }
        code.addLine("%s(%s.%s());", BuilderMethods.addAllMethod(this.property), value, this.property.getGetterName());
        if (code.feature(GuavaLibrary.GUAVA).isAvailable()) {
            code.addLine("}", new Object[0]);
        }
    }

    @Override
    public void addMergeFromBuilder(SourceBuilder code, String builder) {
        Variable base = Declarations.upcastToGeneratedBuilder(code, this.datatype, builder);
        code.addLine("if (%s != null) {", this.property.getField().on(base)).addLine("  %s(%s);", BuilderMethods.addAllMethod(this.property), this.property.getField().on(base)).addLine("}", new Object[0]);
    }

    @Override
    public Set<MergeAction> getMergeActions() {
        return ImmutableSet.of(MergeAction.appendingToCollections());
    }

    @Override
    public void addSetFromResult(SourceBuilder code, Excerpt builder, Excerpt variable) {
        code.addLine("%s.%s(%s);", builder, BuilderMethods.addAllMethod(this.property), variable);
    }

    @Override
    public void addClearField(SourceBuilder code) {
        code.addLine("%s();", BuilderMethods.clearMethod(this.property));
    }

    static class Factory
    implements PropertyCodeGenerator.Factory {
        Factory() {
        }

        public Optional<SortedSetProperty> create(PropertyCodeGenerator.Config config) {
            DeclaredType type = ModelUtils.maybeDeclared(config.getProperty().getType()).orElse(null);
            if (!ModelUtils.erasesToAnyOf(type, SortedSet.class, ImmutableSortedSet.class)) {
                return Optional.empty();
            }
            TypeMirror elementType = ModelUtils.upperBound(config.getElements(), type.getTypeArguments().get(0));
            Optional<TypeMirror> unboxedType = ModelUtils.maybeUnbox(elementType, config.getTypes());
            boolean needsSafeVarargs = ModelUtils.needsSafeVarargs(unboxedType.orElse(elementType));
            boolean overridesAddMethod = Factory.hasAddMethodOverride(config, unboxedType.orElse(elementType));
            boolean overridesVarargsAddMethod = Factory.hasVarargsAddMethodOverride(config, unboxedType.orElse(elementType));
            FunctionalType mutatorType = FunctionalType.functionalTypeAcceptedByMethod(config.getBuilder(), BuilderMethods.mutator(config.getProperty()), FunctionalType.consumer(Factory.wildcardSuperSortedSet(elementType, config.getElements(), config.getTypes())), config.getElements(), config.getTypes());
            return Optional.of(new SortedSetProperty(config.getDatatype(), config.getProperty(), elementType, unboxedType, mutatorType, needsSafeVarargs, overridesAddMethod, overridesVarargsAddMethod));
        }

        private static boolean hasAddMethodOverride(PropertyCodeGenerator.Config config, TypeMirror elementType) {
            return ModelUtils.overrides(config.getBuilder(), config.getTypes(), BuilderMethods.addMethod(config.getProperty()), elementType);
        }

        private static boolean hasVarargsAddMethodOverride(PropertyCodeGenerator.Config config, TypeMirror elementType) {
            return ModelUtils.overrides(config.getBuilder(), config.getTypes(), BuilderMethods.addMethod(config.getProperty()), config.getTypes().getArrayType(elementType));
        }

        private static TypeMirror wildcardSuperSortedSet(TypeMirror elementType, Elements elements, Types types) {
            TypeElement setType = elements.getTypeElement(SortedSet.class.getName());
            return types.getWildcardType(null, types.getDeclaredType(setType, elementType));
        }
    }
}

