/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.freebuilder.processor;

import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.inferred.freebuilder.FreeBuilder;
import org.inferred.freebuilder.processor.BuildableType_Builder;
import org.inferred.freebuilder.processor.BuilderFactory;
import org.inferred.freebuilder.processor.model.ModelUtils;
import org.inferred.freebuilder.processor.source.Excerpt;
import org.inferred.freebuilder.processor.source.Excerpts;
import org.inferred.freebuilder.processor.source.Type;

public abstract class BuildableType {
    private static final Function<Element, Stream<TypeElement>> TYPES = element -> element.getKind().isClass() || element.getKind().isInterface() ? Stream.of((TypeElement)element) : Stream.of(new TypeElement[0]);
    private static final Function<Element, Stream<ExecutableElement>> METHODS = element -> element.getKind() == ElementKind.METHOD ? Stream.of((ExecutableElement)element) : Stream.of(new ExecutableElement[0]);

    public abstract Type type();

    public abstract Type builderType();

    public abstract MergeBuilderMethod mergeBuilder();

    public abstract PartialToBuilderMethod partialToBuilder();

    public abstract BuilderFactory builderFactory();

    public abstract Excerpt suppressUnchecked();

    public Excerpt newBuilder(BuilderFactory.TypeInference typeInference) {
        return this.builderFactory().newBuilder(this.builderType(), typeInference);
    }

    public static Optional<DeclaredType> maybeBuilder(DeclaredType type, Elements elements, Types types) {
        TypeElement element = ModelUtils.asElement(type);
        TypeElement builder = element.getEnclosedElements().stream().flatMap(TYPES).filter(BuildableType::isBuilderType).findAny().orElse(null);
        if (builder == null) {
            return Optional.empty();
        }
        if (builder.getTypeParameters().size() != type.getTypeArguments().size()) {
            return Optional.empty();
        }
        DeclaredType builderMirror = types.getDeclaredType(builder, type.getTypeArguments().toArray(new TypeMirror[0]));
        BuilderFactory builderFactory = BuilderFactory.from(builder).orElse(null);
        if (builderFactory == null) {
            return Optional.empty();
        }
        if (!ModelUtils.findAnnotationMirror((Element)element, FreeBuilder.class).isPresent()) {
            List methods = elements.getAllMembers(builder).stream().flatMap(METHODS).filter(BuildableType::isCallableMethod).collect(Collectors.toList());
            if (!methods.stream().anyMatch(new IsBuildMethod("build", type, types))) {
                return Optional.empty();
            }
            if (!methods.stream().anyMatch(new IsBuildMethod("buildPartial", type, types))) {
                return Optional.empty();
            }
            if (!methods.stream().anyMatch(BuildableType::isClearMethod)) {
                return Optional.empty();
            }
            if (!methods.stream().anyMatch(new IsMergeFromMethod(type, builderMirror, types))) {
                return Optional.empty();
            }
        }
        return Optional.of(builderMirror);
    }

    public static BuildableType create(DeclaredType datatype, DeclaredType builder, Elements elements, Types types) {
        BuilderFactory builderFactory = BuilderFactory.from(ModelUtils.asElement(builder)).get();
        MergeBuilderMethod mergeFromBuilderMethod = BuildableType.detectMergeFromBuilderMethod(builder, elements, types, ModelUtils.asElement(datatype));
        PartialToBuilderMethod partialToBuilderMethod = BuildableType.detectPartialToBuilderMethod(datatype, builder, elements, types);
        Excerpt suppressUnchecked = BuildableType.suppressUncheckedExcerptFor(datatype);
        return new Builder().type(Type.from(datatype)).builderType(Type.from(builder)).mergeBuilder(mergeFromBuilderMethod).partialToBuilder(partialToBuilderMethod).builderFactory(builderFactory).suppressUnchecked(suppressUnchecked).build();
    }

    private static MergeBuilderMethod detectMergeFromBuilderMethod(DeclaredType builder, Elements elements, Types types, TypeElement datatypeElement) {
        if (ModelUtils.findAnnotationMirror((Element)datatypeElement, FreeBuilder.class).isPresent()) {
            return MergeBuilderMethod.MERGE_DIRECTLY;
        }
        List methods = elements.getAllMembers(ModelUtils.asElement(builder)).stream().flatMap(METHODS).filter(BuildableType::isCallableMethod).collect(Collectors.toList());
        if (methods.stream().anyMatch(new IsMergeFromMethod(builder, builder, types))) {
            return MergeBuilderMethod.MERGE_DIRECTLY;
        }
        return MergeBuilderMethod.BUILD_PARTIAL_AND_MERGE;
    }

    private static PartialToBuilderMethod detectPartialToBuilderMethod(DeclaredType datatype, DeclaredType builder, Elements elements, Types types) {
        List valueMethods = elements.getAllMembers(ModelUtils.asElement(datatype)).stream().flatMap(METHODS).filter(BuildableType::isCallableMethod).collect(Collectors.toList());
        if (valueMethods.stream().anyMatch(new IsToBuilderMethod(datatype, builder, types))) {
            return PartialToBuilderMethod.TO_BUILDER_AND_MERGE;
        }
        return PartialToBuilderMethod.MERGE_DIRECTLY;
    }

    private static Excerpt suppressUncheckedExcerptFor(DeclaredType datatype) {
        if (ModelUtils.needsSafeVarargs(datatype)) {
            return Excerpts.add("@SuppressWarnings(\"unchecked\")", new Object[0]);
        }
        return Excerpts.EMPTY;
    }

    private static boolean isCallableMethod(ExecutableElement element) {
        boolean isMethod = element.getKind() == ElementKind.METHOD;
        boolean isPublic = element.getModifiers().contains((Object)Modifier.PUBLIC);
        boolean isNotStatic = !element.getModifiers().contains((Object)Modifier.STATIC);
        boolean declaresNoExceptions = element.getThrownTypes().isEmpty();
        return isMethod && isPublic && isNotStatic && declaresNoExceptions;
    }

    private static boolean isBuilderType(TypeElement element) {
        return element.getSimpleName().contentEquals("Builder") && element.getModifiers().contains((Object)Modifier.PUBLIC);
    }

    private static boolean isClearMethod(ExecutableElement element) {
        if (!element.getParameters().isEmpty()) {
            return false;
        }
        return element.getSimpleName().contentEquals("clear");
    }

    private static final class IsToBuilderMethod
    implements Predicate<ExecutableElement> {
        final DeclaredType datatype;
        final TypeMirror builder;
        final Types types;

        IsToBuilderMethod(DeclaredType datatype, TypeMirror builder, Types types) {
            this.datatype = datatype;
            this.builder = builder;
            this.types = types;
        }

        @Override
        public boolean test(ExecutableElement element) {
            if (element.getParameters().size() != 0) {
                return false;
            }
            if (!element.getSimpleName().contentEquals("toBuilder")) {
                return false;
            }
            ExecutableType method = (ExecutableType)this.types.asMemberOf(this.datatype, element);
            return this.types.isSubtype(method.getReturnType(), this.builder);
        }
    }

    private static final class IsMergeFromMethod
    implements Predicate<ExecutableElement> {
        final DeclaredType parameter;
        final DeclaredType builder;
        final Types types;

        IsMergeFromMethod(DeclaredType parameter, DeclaredType builder, Types types) {
            this.parameter = parameter;
            this.builder = builder;
            this.types = types;
        }

        @Override
        public boolean test(ExecutableElement element) {
            if (element.getParameters().size() != 1) {
                return false;
            }
            if (!element.getSimpleName().contentEquals("mergeFrom")) {
                return false;
            }
            ExecutableType method = (ExecutableType)this.types.asMemberOf(this.builder, element);
            return this.types.isSubtype(this.parameter, method.getParameterTypes().get(0));
        }
    }

    private static final class IsBuildMethod
    implements Predicate<ExecutableElement> {
        final String methodName;
        final TypeMirror builtType;
        final Types types;

        IsBuildMethod(String methodName, TypeMirror builtType, Types types) {
            this.methodName = methodName;
            this.builtType = builtType;
            this.types = types;
        }

        @Override
        public boolean test(ExecutableElement element) {
            if (!element.getParameters().isEmpty()) {
                return false;
            }
            if (!element.getSimpleName().contentEquals(this.methodName)) {
                return false;
            }
            return this.types.isSubtype(element.getReturnType(), this.builtType);
        }
    }

    public static class Builder
    extends BuildableType_Builder {
    }

    public static enum PartialToBuilderMethod {
        MERGE_DIRECTLY,
        TO_BUILDER_AND_MERGE;

    }

    public static enum MergeBuilderMethod {
        MERGE_DIRECTLY,
        BUILD_PARTIAL_AND_MERGE;

    }
}

