/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.freebuilder.processor.property;

import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import org.inferred.freebuilder.processor.BuilderMethods;
import org.inferred.freebuilder.processor.Datatype;
import org.inferred.freebuilder.processor.Declarations;
import org.inferred.freebuilder.processor.excerpt.CheckedBiMap;
import org.inferred.freebuilder.processor.model.ModelUtils;
import org.inferred.freebuilder.processor.property.MergeAction;
import org.inferred.freebuilder.processor.property.Property;
import org.inferred.freebuilder.processor.property.PropertyCodeGenerator;
import org.inferred.freebuilder.processor.source.Excerpt;
import org.inferred.freebuilder.processor.source.FunctionalType;
import org.inferred.freebuilder.processor.source.SourceBuilder;
import org.inferred.freebuilder.processor.source.Type;
import org.inferred.freebuilder.processor.source.Variable;
import org.inferred.freebuilder.shaded.com.google.common.base.Preconditions;
import org.inferred.freebuilder.shaded.com.google.common.collect.BiMap;
import org.inferred.freebuilder.shaded.com.google.common.collect.HashBiMap;
import org.inferred.freebuilder.shaded.com.google.common.collect.ImmutableBiMap;
import org.inferred.freebuilder.shaded.com.google.common.collect.ImmutableSet;
import org.inferred.freebuilder.shaded.com.google.common.collect.Maps;

class BiMapProperty
extends PropertyCodeGenerator {
    private final boolean overridesForcePutMethod;
    private final TypeMirror keyType;
    private final Optional<TypeMirror> unboxedKeyType;
    private final TypeMirror valueType;
    private final Optional<TypeMirror> unboxedValueType;
    private final FunctionalType mutatorType;

    BiMapProperty(Datatype datatype, Property property, boolean overridesForcePutMethod, TypeMirror keyType, Optional<TypeMirror> unboxedKeyType, TypeMirror valueType, Optional<TypeMirror> unboxedValueType, FunctionalType mutatorType) {
        super(datatype, property);
        this.overridesForcePutMethod = overridesForcePutMethod;
        this.keyType = keyType;
        this.unboxedKeyType = unboxedKeyType;
        this.valueType = valueType;
        this.unboxedValueType = unboxedValueType;
        this.mutatorType = mutatorType;
    }

    @Override
    public void addValueFieldDeclaration(SourceBuilder code) {
        code.addLine("private final %s<%s, %s> %s;", ImmutableBiMap.class, this.keyType, this.valueType, this.property.getField());
    }

    @Override
    public void addBuilderFieldDeclaration(SourceBuilder code) {
        code.addLine("private final %1$s<%2$s, %3$s> %4$s = %1$s.create();", HashBiMap.class, this.keyType, this.valueType, this.property.getField());
    }

    @Override
    public void addBuilderFieldAccessors(SourceBuilder code) {
        this.addPut(code);
        this.addForcePut(code);
        this.addPutAll(code);
        this.addRemoveKeyFrom(code);
        this.addRemoveValueFrom(code);
        this.addMutate(code);
        this.addClear(code);
        this.addGetter(code);
    }

    private void addPut(SourceBuilder code) {
        code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Associates {@code key} with {@code value} in the bimap to be returned from", new Object[0]).addLine(" * %s.", this.datatype.getType().javadocNoArgMethodLink(this.property.getGetterName())).addLine(" * If the bimap previously contained a mapping for the key,", new Object[0]).addLine(" * the old value is replaced by the specified value.", new Object[0]).addLine(" *", new Object[0]).addLine(" * @return this {@code %s} object", this.datatype.getBuilder().getSimpleName()).addLine(" * @throws IllegalArgumentException if the given value is already bound to a", new Object[0]).addLine(" *     different key in this bimap. The bimap will remain unmodified in this", new Object[0]).addLine(" *     event. To avoid this exception, call {@link #forcePut} instead.", new Object[0]);
        if (!this.unboxedKeyType.isPresent() || !this.unboxedValueType.isPresent()) {
            code.add(" * @throws NullPointerException if ", new Object[0]);
            if (this.unboxedKeyType.isPresent()) {
                code.add("{@code value} is", new Object[0]);
            } else if (this.unboxedValueType.isPresent()) {
                code.add("{@code key} is", new Object[0]);
            } else {
                code.add("either {@code key} or {@code value} are", new Object[0]);
            }
            code.add(" null\n", new Object[0]);
        }
        code.addLine(" */", new Object[0]);
        this.addPutAnnotations(code);
        code.addLine("public %s %s(%s key, %s value) {", this.datatype.getBuilder(), BuilderMethods.putMethod(this.property), this.unboxedKeyType.orElse(this.keyType), this.unboxedValueType.orElse(this.valueType));
        code.addLine("  %s oldKey = %s.inverse().get(value);", this.keyType, this.property.getField()).addLine("  %s.checkArgument(", Preconditions.class).addLine("      oldKey == null || %s.equals(oldKey, key),", Objects.class).addLine("      \"value already present: %%s\", value);", new Object[0]).addLine("  %s(key, value);", BuilderMethods.forcePutMethod(this.property)).addLine("  return (%s) this;", this.datatype.getBuilder()).addLine("}", new Object[0]);
    }

    private void addForcePut(SourceBuilder code) {
        code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Associates {@code key} with {@code value} in the bimap to be returned from", new Object[0]).addLine(" * %s.", this.datatype.getType().javadocNoArgMethodLink(this.property.getGetterName())).addLine(" * See {@link BiMap#forcePut(Object, Object)}.", new Object[0]).addLine(" *", new Object[0]).addLine(" * @return this {@code %s} object", this.datatype.getBuilder().getSimpleName());
        if (!this.unboxedKeyType.isPresent() || !this.unboxedValueType.isPresent()) {
            code.add(" * @throws NullPointerException if ", new Object[0]);
            if (this.unboxedKeyType.isPresent()) {
                code.add("{@code value} is", new Object[0]);
            } else if (this.unboxedValueType.isPresent()) {
                code.add("{@code key} is", new Object[0]);
            } else {
                code.add("either {@code key} or {@code value} are", new Object[0]);
            }
            code.add(" null\n", new Object[0]);
        }
        code.addLine(" */", new Object[0]);
        this.addPutAnnotations(code);
        code.addLine("public %s %s(%s key, %s value) {", this.datatype.getBuilder(), BuilderMethods.forcePutMethod(this.property), this.unboxedKeyType.orElse(this.keyType), this.unboxedValueType.orElse(this.valueType));
        if (!this.unboxedKeyType.isPresent()) {
            code.addLine("  %s.requireNonNull(key);", Objects.class);
        }
        if (!this.unboxedValueType.isPresent()) {
            code.addLine("  %s.requireNonNull(value);", Objects.class);
        }
        code.addLine("  %s.forcePut(key, value);", this.property.getField()).addLine("  return (%s) this;", this.datatype.getBuilder()).addLine("}", new Object[0]);
    }

    private void addPutAll(SourceBuilder code) {
        code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Copies all of the mappings from {@code map} to the bimap to be returned ", new Object[0]).addLine(" * from %s.", this.datatype.getType().javadocNoArgMethodLink(this.property.getGetterName())).addLine(" *", new Object[0]).addLine(" * @return this {@code %s} object", this.datatype.getBuilder().getSimpleName()).addLine(" * @throws NullPointerException if {@code map} is null or contains a", new Object[0]).addLine(" *     null key or value", new Object[0]).addLine(" * @throws IllegalArgumentException if an attempt to {@code put} any", new Object[0]).addLine(" *     entry fails. Note that some map entries may have been added to the", new Object[0]).addLine(" *     bimap before the exception was thrown.", new Object[0]).addLine(" */", new Object[0]);
        this.addAccessorAnnotations(code);
        code.addLine("public %s %s(%s<? extends %s, ? extends %s> map) {", this.datatype.getBuilder(), BuilderMethods.putAllMethod(this.property), Map.class, this.keyType, this.valueType).addLine("  for (%s<? extends %s, ? extends %s> entry : map.entrySet()) {", Map.Entry.class, this.keyType, this.valueType).addLine("    %s(entry.getKey(), entry.getValue());", BuilderMethods.putMethod(this.property)).addLine("  }", new Object[0]).addLine("  return (%s) this;", this.datatype.getBuilder()).addLine("}", new Object[0]);
    }

    private void addRemoveKeyFrom(SourceBuilder code) {
        code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Removes the mapping for {@code key} from the bimap to be returned from", new Object[0]).addLine(" * %s, if one is present.", this.datatype.getType().javadocNoArgMethodLink(this.property.getGetterName())).addLine(" *", new Object[0]).addLine(" * @return this {@code %s} object", this.datatype.getBuilder().getSimpleName());
        if (!this.unboxedKeyType.isPresent()) {
            code.addLine(" * @throws NullPointerException if {@code key} is null", new Object[0]);
        }
        code.addLine(" */", new Object[0]).addLine("public %s %s(%s key) {", this.datatype.getBuilder(), BuilderMethods.removeKeyFromMethod(this.property), this.unboxedKeyType.orElse(this.keyType));
        if (!this.unboxedKeyType.isPresent()) {
            code.addLine("  %s.requireNonNull(key);", Objects.class);
        }
        code.addLine("  %s.remove(key);", this.property.getField()).addLine("  return (%s) this;", this.datatype.getBuilder()).addLine("}", new Object[0]);
    }

    private void addRemoveValueFrom(SourceBuilder code) {
        code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Removes the mapping for {@code value} from the bimap to be returned from", new Object[0]).addLine(" * %s, if one is present.", this.datatype.getType().javadocNoArgMethodLink(this.property.getGetterName())).addLine(" *", new Object[0]).addLine(" * @return this {@code %s} object", this.datatype.getBuilder().getSimpleName());
        if (!this.unboxedValueType.isPresent()) {
            code.addLine(" * @throws NullPointerException if {@code value} is null", new Object[0]);
        }
        code.addLine(" */", new Object[0]).addLine("public %s %s(%s value) {", this.datatype.getBuilder(), BuilderMethods.removeValueFromMethod(this.property), this.unboxedValueType.orElse(this.valueType));
        if (!this.unboxedValueType.isPresent()) {
            code.addLine("  %s.requireNonNull(value);", Objects.class);
        }
        code.addLine("  %s.inverse().remove(value);", this.property.getField()).addLine("  return (%s) this;", this.datatype.getBuilder()).addLine("}", new Object[0]);
    }

    private void addMutate(SourceBuilder code) {
        code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Invokes {@code mutator} with the bimap to be returned from", new Object[0]).addLine(" * %s.", this.datatype.getType().javadocNoArgMethodLink(this.property.getGetterName())).addLine(" *", new Object[0]).addLine(" * <p>This method mutates the bimap in-place. {@code mutator} is a void", new Object[0]).addLine(" * consumer, so any value returned from a lambda will be ignored. Take care", new Object[0]).addLine(" * not to call pure functions, like %s.", Type.from(Collection.class).javadocNoArgMethodLink("stream")).addLine(" *", new Object[0]).addLine(" * @return this {@code Builder} object", new Object[0]).addLine(" * @throws NullPointerException if {@code mutator} is null", new Object[0]).addLine(" */", new Object[0]).addLine("public %s %s(%s mutator) {", this.datatype.getBuilder(), BuilderMethods.mutator(this.property), this.mutatorType.getFunctionalInterface());
        if (this.overridesForcePutMethod) {
            code.addLine("  mutator.%s(new %s<>(%s, this::%s));", this.mutatorType.getMethodName(), CheckedBiMap.TYPE, this.property.getField(), BuilderMethods.forcePutMethod(this.property));
        } else {
            code.addLine("  // If %s is overridden, this method will be updated to delegate to it", BuilderMethods.forcePutMethod(this.property)).addLine("  mutator.%s(%s);", this.mutatorType.getMethodName(), this.property.getField());
        }
        code.addLine("  return (%s) this;", this.datatype.getBuilder()).addLine("}", new Object[0]);
    }

    private void addClear(SourceBuilder code) {
        code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Removes all of the mappings from the bimap to be returned from ", new Object[0]).addLine(" * %s.", this.datatype.getType().javadocNoArgMethodLink(this.property.getGetterName())).addLine(" *", new Object[0]).addLine(" * @return this {@code %s} object", this.datatype.getBuilder().getSimpleName()).addLine(" */", new Object[0]).addLine("public %s %s() {", this.datatype.getBuilder(), BuilderMethods.clearMethod(this.property)).addLine("  %s.clear();", this.property.getField()).addLine("  return (%s) this;", this.datatype.getBuilder()).addLine("}", new Object[0]);
    }

    private void addGetter(SourceBuilder code) {
        code.addLine("", new Object[0]).addLine("/**", new Object[0]).addLine(" * Returns an unmodifiable view of the bimap that will be returned by", new Object[0]).addLine(" * %s.", this.datatype.getType().javadocNoArgMethodLink(this.property.getGetterName())).addLine(" * Changes to this builder will be reflected in the view.", new Object[0]).addLine(" */", new Object[0]).addLine("public %s<%s, %s> %s() {", BiMap.class, this.keyType, this.valueType, BuilderMethods.getter(this.property)).addLine("  return %s.unmodifiableBiMap(%s);", Maps.class, this.property.getField()).addLine("}", new Object[0]);
    }

    @Override
    public void addFinalFieldAssignment(SourceBuilder code, Excerpt finalField, String builder) {
        code.addLine("%s = %s.copyOf(%s);", finalField, ImmutableBiMap.class, this.property.getField().on(builder));
    }

    @Override
    public void addAssignToBuilder(SourceBuilder code, Variable builder) {
        code.addLine("%s.putAll(%s);", this.property.getField().on(builder), this.property.getField());
    }

    @Override
    public void addMergeFromValue(SourceBuilder code, String value) {
        code.addLine("%s(%s.%s());", BuilderMethods.putAllMethod(this.property), value, this.property.getGetterName());
    }

    @Override
    public void addMergeFromBuilder(SourceBuilder code, String builder) {
        Variable base = Declarations.upcastToGeneratedBuilder(code, this.datatype, builder);
        code.addLine("%s(%s);", BuilderMethods.putAllMethod(this.property), this.property.getField().on(base));
    }

    @Override
    public Set<MergeAction> getMergeActions() {
        return ImmutableSet.of(MergeAction.appendingToCollections());
    }

    @Override
    public void addSetFromResult(SourceBuilder code, Excerpt builder, Excerpt variable) {
        code.addLine("%s.%s(%s);", builder, BuilderMethods.putAllMethod(this.property), variable);
    }

    @Override
    public void addClearField(SourceBuilder code) {
        code.addLine("%s.clear();", this.property.getField());
    }

    static class Factory
    implements PropertyCodeGenerator.Factory {
        Factory() {
        }

        public Optional<BiMapProperty> create(PropertyCodeGenerator.Config config) {
            Property property = config.getProperty();
            DeclaredType type = ModelUtils.maybeDeclared(property.getType()).orElse(null);
            if (!ModelUtils.erasesToAnyOf(type, BiMap.class, ImmutableBiMap.class)) {
                return Optional.empty();
            }
            TypeMirror keyType = ModelUtils.upperBound(config.getElements(), type.getTypeArguments().get(0));
            TypeMirror valueType = ModelUtils.upperBound(config.getElements(), type.getTypeArguments().get(1));
            Optional<TypeMirror> unboxedKeyType = ModelUtils.maybeUnbox(keyType, config.getTypes());
            Optional<TypeMirror> unboxedValueType = ModelUtils.maybeUnbox(valueType, config.getTypes());
            Optional<ExecutableElement> putMethodOverride = Factory.putMethodOverride(config, unboxedKeyType.orElse(keyType), unboxedValueType.orElse(valueType));
            boolean overridesForcePutMethod = Factory.hasForcePutMethodOverride(config, unboxedKeyType.orElse(keyType), unboxedValueType.orElse(valueType));
            if (putMethodOverride.isPresent() && !overridesForcePutMethod) {
                config.getEnvironment().getMessager().printMessage(Diagnostic.Kind.ERROR, "Overriding " + BuilderMethods.putMethod(property) + " will not correctly validate all inputs. Please override " + BuilderMethods.forcePutMethod(property) + ".", putMethodOverride.get());
            }
            FunctionalType mutatorType = FunctionalType.functionalTypeAcceptedByMethod(config.getBuilder(), BuilderMethods.mutator(property), FunctionalType.consumer(Factory.biMap(keyType, valueType, config.getElements(), config.getTypes())), config.getElements(), config.getTypes());
            return Optional.of(new BiMapProperty(config.getDatatype(), property, overridesForcePutMethod, keyType, unboxedKeyType, valueType, unboxedValueType, mutatorType));
        }

        private static Optional<ExecutableElement> putMethodOverride(PropertyCodeGenerator.Config config, TypeMirror keyType, TypeMirror valueType) {
            return ModelUtils.override(config.getBuilder(), config.getTypes(), BuilderMethods.putMethod(config.getProperty()), keyType, valueType);
        }

        private static boolean hasForcePutMethodOverride(PropertyCodeGenerator.Config config, TypeMirror keyType, TypeMirror valueType) {
            return ModelUtils.overrides(config.getBuilder(), config.getTypes(), BuilderMethods.forcePutMethod(config.getProperty()), keyType, valueType);
        }

        private static TypeMirror biMap(TypeMirror keyType, TypeMirror valueType, Elements elements, Types types) {
            TypeElement mapType = elements.getTypeElement(BiMap.class.getName());
            return types.getDeclaredType(mapType, keyType, valueType);
        }
    }
}

