/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.freebuilder.shaded.com.google.googlejavaformat;

import java.util.ArrayDeque;
import java.util.List;
import org.inferred.freebuilder.shaded.com.google.common.base.MoreObjects;
import org.inferred.freebuilder.shaded.com.google.googlejavaformat.Doc;
import org.inferred.freebuilder.shaded.com.google.googlejavaformat.Indent;
import org.inferred.freebuilder.shaded.com.google.googlejavaformat.Op;

public final class DocBuilder {
    private final Doc.Level base = Doc.Level.make(Indent.Const.ZERO);
    private final ArrayDeque<Doc.Level> stack = new ArrayDeque();
    private Doc.Level appendLevel = this.base;

    public DocBuilder() {
        this.stack.addLast(this.base);
    }

    public DocBuilder withOps(List<Op> ops) {
        for (Op op : ops) {
            op.add(this);
        }
        return this;
    }

    void open(Indent plusIndent) {
        Doc.Level level = Doc.Level.make(plusIndent);
        this.stack.addLast(level);
    }

    void close() {
        Doc.Level top = this.stack.removeLast();
        this.stack.peekLast().add(top);
    }

    void add(Doc doc) {
        this.appendLevel.add(doc);
    }

    void breakDoc(Doc.Break breakDoc) {
        this.appendLevel = this.stack.peekLast();
        this.appendLevel.add(breakDoc);
    }

    public Doc build() {
        return this.base;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("base", this.base).add("stack", this.stack).add("appendLevel", this.appendLevel).toString();
    }
}

