/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.freebuilder.shaded.org.openjdk.tools.javac.code;

import org.inferred.freebuilder.shaded.org.openjdk.tools.javac.code.Attribute;
import org.inferred.freebuilder.shaded.org.openjdk.tools.javac.code.Symbol;
import org.inferred.freebuilder.shaded.org.openjdk.tools.javac.util.Assert;
import org.inferred.freebuilder.shaded.org.openjdk.tools.javac.util.List;

public class SymbolMetadata {
    private static final List<Attribute.Compound> DECL_NOT_STARTED = List.of(null);
    private static final List<Attribute.Compound> DECL_IN_PROGRESS = List.of(null);
    private List<Attribute.Compound> attributes = DECL_NOT_STARTED;
    private List<Attribute.TypeCompound> type_attributes = List.nil();
    private List<Attribute.TypeCompound> init_type_attributes = List.nil();
    private List<Attribute.TypeCompound> clinit_type_attributes = List.nil();
    private final Symbol sym;

    public SymbolMetadata(Symbol sym) {
        this.sym = sym;
    }

    public List<Attribute.Compound> getDeclarationAttributes() {
        return this.filterDeclSentinels(this.attributes);
    }

    public List<Attribute.TypeCompound> getTypeAttributes() {
        return this.type_attributes;
    }

    public List<Attribute.TypeCompound> getInitTypeAttributes() {
        return this.init_type_attributes;
    }

    public List<Attribute.TypeCompound> getClassInitTypeAttributes() {
        return this.clinit_type_attributes;
    }

    public void setDeclarationAttributes(List<Attribute.Compound> a) {
        Assert.check(this.pendingCompletion() || !this.isStarted());
        if (a == null) {
            throw new NullPointerException();
        }
        this.attributes = a;
    }

    public void setTypeAttributes(List<Attribute.TypeCompound> a) {
        if (a == null) {
            throw new NullPointerException();
        }
        this.type_attributes = a;
    }

    public void setInitTypeAttributes(List<Attribute.TypeCompound> a) {
        if (a == null) {
            throw new NullPointerException();
        }
        this.init_type_attributes = a;
    }

    public void setClassInitTypeAttributes(List<Attribute.TypeCompound> a) {
        if (a == null) {
            throw new NullPointerException();
        }
        this.clinit_type_attributes = a;
    }

    public void setAttributes(SymbolMetadata other) {
        if (other == null) {
            throw new NullPointerException();
        }
        this.setDeclarationAttributes(other.getDeclarationAttributes());
        this.setTypeAttributes(other.getTypeAttributes());
        this.setInitTypeAttributes(other.getInitTypeAttributes());
        this.setClassInitTypeAttributes(other.getClassInitTypeAttributes());
    }

    public SymbolMetadata reset() {
        this.attributes = DECL_IN_PROGRESS;
        return this;
    }

    public boolean isEmpty() {
        return !this.isStarted() || this.pendingCompletion() || this.attributes.isEmpty();
    }

    public boolean isTypesEmpty() {
        return this.type_attributes.isEmpty();
    }

    public boolean pendingCompletion() {
        return this.attributes == DECL_IN_PROGRESS;
    }

    public SymbolMetadata append(List<Attribute.Compound> l) {
        this.attributes = this.filterDeclSentinels(this.attributes);
        if (!l.isEmpty()) {
            this.attributes = this.attributes.isEmpty() ? l : this.attributes.appendList(l);
        }
        return this;
    }

    public SymbolMetadata appendUniqueTypes(List<Attribute.TypeCompound> l) {
        if (!l.isEmpty()) {
            if (this.type_attributes.isEmpty()) {
                this.type_attributes = l;
            } else {
                for (Attribute.TypeCompound tc : l) {
                    if (this.type_attributes.contains(tc)) continue;
                    this.type_attributes = this.type_attributes.append(tc);
                }
            }
        }
        return this;
    }

    public SymbolMetadata appendInitTypeAttributes(List<Attribute.TypeCompound> l) {
        if (!l.isEmpty()) {
            this.init_type_attributes = this.init_type_attributes.isEmpty() ? l : this.init_type_attributes.appendList(l);
        }
        return this;
    }

    public SymbolMetadata appendClassInitTypeAttributes(List<Attribute.TypeCompound> l) {
        if (!l.isEmpty()) {
            this.clinit_type_attributes = this.clinit_type_attributes.isEmpty() ? l : this.clinit_type_attributes.appendList(l);
        }
        return this;
    }

    public SymbolMetadata prepend(List<Attribute.Compound> l) {
        this.attributes = this.filterDeclSentinels(this.attributes);
        if (!l.isEmpty()) {
            this.attributes = this.attributes.isEmpty() ? l : this.attributes.prependList(l);
        }
        return this;
    }

    private List<Attribute.Compound> filterDeclSentinels(List<Attribute.Compound> a) {
        return a == DECL_IN_PROGRESS || a == DECL_NOT_STARTED ? List.nil() : a;
    }

    private boolean isStarted() {
        return this.attributes != DECL_NOT_STARTED;
    }
}

