/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.internal.testing.integration;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;
import org.inferred.internal.testing.integration.Diagnostics;

public class CompilationException
extends RuntimeException {
    private final ImmutableList<Diagnostic<? extends JavaFileObject>> diagnostics;

    public CompilationException(List<Diagnostic<? extends JavaFileObject>> diagnostics) {
        this.diagnostics = ImmutableList.copyOf(diagnostics);
    }

    public CompilationException(CompilationException e) {
        this((List<Diagnostic<? extends JavaFileObject>>)e.diagnostics);
    }

    @Override
    public String getMessage() {
        StringBuilder fullMessage = new StringBuilder("Compilation failed");
        int i = 1;
        for (Diagnostic diagnostic : this.diagnostics) {
            fullMessage.append("\n    ").append(i++).append(") ");
            Diagnostics.appendTo(fullMessage, diagnostic, 8);
        }
        return fullMessage.toString();
    }
}

