/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.internal.testing.integration;

import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import java.io.File;
import java.util.EnumSet;
import java.util.Locale;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;

public class Diagnostics {
    public static void appendTo(StringBuilder appendable, Diagnostic<? extends JavaFileObject> diagnostic, int indentLevel) {
        String indent = "\n" + Strings.repeat((String)" ", (int)indentLevel);
        appendable.append(diagnostic.getMessage(Locale.getDefault()).replace("\n", indent));
        JavaFileObject source = diagnostic.getSource();
        long line = diagnostic.getLineNumber();
        if (source != null && line != -1L) {
            File sourceFile = new File(source.getName());
            appendable.append(" (").append(sourceFile.getName()).append(":").append(line).append(")");
        }
    }

    public static final Predicate<Diagnostic<?>> isKind(Diagnostic.Kind kind, Diagnostic.Kind ... otherKinds) {
        final EnumSet<Diagnostic.Kind[]> allKinds = EnumSet.of(kind, otherKinds);
        return new Predicate<Diagnostic<?>>(){

            public boolean apply(Diagnostic<?> diagnostic) {
                return allKinds.contains((Object)diagnostic.getKind());
            }
        };
    }

    private Diagnostics() {
    }
}

