/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.internal.testing.integration;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.reflect.TypeToken;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

public class TypeMirrors {
    private static final Pattern ARG_REF_PATTERN = Pattern.compile("%(\\d+)");
    private static final Pattern GENERIC_OR_ARRAY_PATTERN = Pattern.compile("(%\\d+)\\s*(?:(\\[\\s*\\])|<\\s*((?:%\\d+)\\s*(?:,\\s*(?:%\\d+)\\s*)*)>)");
    private static final Pattern INVALID_TYPE_SNIPPET_PATTERN = Pattern.compile(">\\s*[\\w<]|\\]\\s*[\\w<\\[]");
    private static final Pattern RAW_TYPE_PATTERN = Pattern.compile("[^\\W\\d]\\w*(\\s*[.]\\s*[^\\W\\d]\\w*)*");

    public static TypeMirror typeMirror(Types typeUtils, Elements elementUtils, Class<?> cls) {
        if (cls.equals(Void.TYPE)) {
            return typeUtils.getNoType(TypeKind.VOID);
        }
        if (cls.isPrimitive()) {
            return typeUtils.getPrimitiveType(TypeKind.valueOf(cls.getSimpleName().toUpperCase()));
        }
        if (cls.isArray()) {
            return typeUtils.getArrayType(TypeMirrors.typeMirror(typeUtils, elementUtils, cls.getComponentType()));
        }
        return TypeMirrors.rawType(typeUtils, elementUtils, cls.getCanonicalName());
    }

    public static TypeMirror typeMirror(Types typeUtils, Elements elementUtils, TypeToken<?> type) {
        return TypeMirrors.typeMirror(typeUtils, elementUtils, type.getType());
    }

    public static TypeMirror typeMirror(Types typeUtils, Elements elementUtils, Type type) {
        if (type instanceof Class) {
            return TypeMirrors.typeMirror(typeUtils, elementUtils, (Class)type);
        }
        if (type instanceof GenericArrayType) {
            Type componentType = ((GenericArrayType)type).getGenericComponentType();
            return typeUtils.getArrayType(TypeMirrors.typeMirror(typeUtils, elementUtils, componentType));
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType pType = (ParameterizedType)type;
            DeclaredType rawType = (DeclaredType)TypeMirrors.typeMirror(typeUtils, elementUtils, pType.getRawType());
            ArrayList<TypeMirror> typeArgumentMirrors = new ArrayList<TypeMirror>();
            for (Type typeArgument : pType.getActualTypeArguments()) {
                typeArgumentMirrors.add(TypeMirrors.typeMirror(typeUtils, elementUtils, typeArgument));
            }
            DeclaredType owner = (DeclaredType)TypeMirrors.typeMirror(typeUtils, elementUtils, pType.getOwnerType());
            return typeUtils.getDeclaredType(owner, (TypeElement)rawType.asElement(), typeArgumentMirrors.toArray(new TypeMirror[typeArgumentMirrors.size()]));
        }
        if (type instanceof WildcardType) {
            Type lowerBound = TypeMirrors.getOnlyType(((WildcardType)type).getLowerBounds());
            Type upperBound = TypeMirrors.getOnlyType(((WildcardType)type).getUpperBounds());
            if (Object.class.equals((Object)upperBound)) {
                upperBound = null;
            }
            return typeUtils.getWildcardType(TypeMirrors.typeMirror(typeUtils, elementUtils, upperBound), TypeMirrors.typeMirror(typeUtils, elementUtils, lowerBound));
        }
        if (type == null) {
            return null;
        }
        if (type instanceof TypeVariable) {
            throw new IllegalArgumentException("Type variables not supported");
        }
        throw new IllegalArgumentException("Unrecognized Type subclass " + type.getClass());
    }

    public static TypeMirror typeMirror(Types typeUtils, Elements elementUtils, String typeSnippet, TypeMirror ... args) {
        TypeMirrors.checkArgReferences(typeSnippet, args == null ? 0 : args.length);
        Preconditions.checkArgument((!INVALID_TYPE_SNIPPET_PATTERN.matcher(typeSnippet).find() ? 1 : 0) != 0, (String)"Invalid type string '%s'", (Object[])new Object[]{typeSnippet});
        Substitutions substitutions = new Substitutions(args);
        MutableString mutableSnippet = new MutableString(typeSnippet.trim());
        TypeMirrors.substituteRawTypes(typeUtils, elementUtils, mutableSnippet, substitutions);
        TypeMirrors.substituteGenericsAndArrays(typeUtils, mutableSnippet, substitutions);
        Preconditions.checkArgument((boolean)substitutions.containsKey(mutableSnippet.toString()), (String)"Invalid type string '%s'", (Object[])new Object[]{typeSnippet});
        return substitutions.get(mutableSnippet.toString());
    }

    private static Type getOnlyType(Type[] types) {
        Preconditions.checkArgument((types.length <= 1 ? 1 : 0) != 0, (Object)"Wildcard types with multiple bounds not supported");
        return types.length == 0 ? null : types[0];
    }

    private static void substituteRawTypes(Types typeUtils, Elements elementUtils, MutableString snippet, Substitutions substitutions) {
        for (MatchResult m : snippet.instancesOf(RAW_TYPE_PATTERN)) {
            snippet.replace(m, substitutions.put(TypeMirrors.rawType(typeUtils, elementUtils, m.group(0))));
        }
    }

    private static void substituteGenericsAndArrays(Types typeUtils, MutableString snippet, Substitutions substitutions) {
        for (MatchResult m : snippet.instancesOf(GENERIC_OR_ARRAY_PATTERN)) {
            TypeMirror type = substitutions.get(m.group(1));
            if (Strings.isNullOrEmpty((String)m.group(2))) {
                List argTypes = Lists.transform((List)Splitter.on((String)",").trimResults().splitToList((CharSequence)m.group(3)), substitutions.asFunction());
                snippet.replace(m, substitutions.put(TypeMirrors.parameterisedType(typeUtils, type, argTypes)));
                continue;
            }
            snippet.replace(m, substitutions.put(typeUtils.getArrayType(type)));
        }
    }

    private static DeclaredType parameterisedType(Types typeUtils, TypeMirror rawType, List<TypeMirror> paramTypes) {
        Preconditions.checkArgument((rawType.getKind() == TypeKind.DECLARED && ((DeclaredType)rawType).getTypeArguments().isEmpty() ? 1 : 0) != 0, (String)"Expected raw type, got '%s'", (Object[])new Object[]{rawType});
        TypeElement genericType = (TypeElement)typeUtils.asElement(rawType);
        Preconditions.checkArgument((genericType.getTypeParameters().size() == paramTypes.size() ? 1 : 0) != 0, (String)"Incorrect number of arguments for %s (expected %s, got %s)", (Object[])new Object[]{genericType, genericType.getTypeParameters().size(), paramTypes.size()});
        DeclaredType declaredType = typeUtils.getDeclaredType(genericType, paramTypes.toArray(new TypeMirror[paramTypes.size()]));
        return declaredType;
    }

    private static void checkArgReferences(String typeSnippet, int numberOfArgs) {
        Matcher argRefMatcher = ARG_REF_PATTERN.matcher(typeSnippet);
        while (argRefMatcher.find()) {
            int index = Integer.parseInt(argRefMatcher.group(1), 10) - 1;
            Preconditions.checkArgument((index >= 0 ? 1 : 0) != 0, (String)"%s not allowed, indices start at 1", (Object[])new Object[]{argRefMatcher.group(0)});
            Preconditions.checkArgument((index < numberOfArgs ? 1 : 0) != 0, (String)"%s too large for number of provided type mirrors", (Object[])new Object[]{argRefMatcher.group(0)});
        }
    }

    private static TypeMirror rawType(Types typeUtils, Elements elementUtils, String typeSnippet) {
        TypeElement typeElement = elementUtils.getTypeElement(typeSnippet);
        if (typeElement == null && !typeSnippet.contains(".")) {
            typeElement = elementUtils.getTypeElement("java.lang." + typeSnippet);
        }
        Preconditions.checkArgument((typeElement != null ? 1 : 0) != 0, (String)"Unrecognised type '%s'", (Object[])new Object[]{typeSnippet});
        return typeUtils.erasure(typeElement.asType());
    }

    private static class Substitutions {
        private final Map<String, TypeMirror> substitutions = Maps.newHashMap();

        Substitutions(TypeMirror ... args) {
            for (int i = 0; args != null && i < args.length; ++i) {
                this.substitutions.put("%" + (i + 1), args[i]);
            }
        }

        boolean containsKey(String substitute) {
            return this.substitutions.containsKey(substitute);
        }

        TypeMirror get(String substitute) {
            return this.substitutions.get(substitute);
        }

        Function<String, TypeMirror> asFunction() {
            return Functions.forMap(this.substitutions);
        }

        String put(TypeMirror t) {
            String pattern = "%" + (this.substitutions.size() + 1);
            this.substitutions.put(pattern, t);
            return pattern;
        }
    }

    private static class MutableString {
        private String value;

        MutableString(String value) {
            this.value = (String)Preconditions.checkNotNull((Object)value);
        }

        Iterable<MatchResult> instancesOf(final Pattern pattern) {
            return new Iterable<MatchResult>(){

                @Override
                public Iterator<MatchResult> iterator() {
                    return new AbstractIterator<MatchResult>(){
                        Matcher matcher;
                        String matchingAgainst;

                        protected MatchResult computeNext() {
                            if (this.matchingAgainst != value) {
                                this.matchingAgainst = value;
                                this.matcher = pattern.matcher(this.matchingAgainst);
                            }
                            if (this.matcher.find()) {
                                return this.matcher.toMatchResult();
                            }
                            return (MatchResult)this.endOfData();
                        }
                    };
                }
            };
        }

        void replace(MatchResult match, String replacement) {
            Preconditions.checkArgument((boolean)match.group().equals(this.value.substring(match.start(), match.end())), (Object)"MatchResult does not match the current value of this string");
            this.value = this.value.substring(0, match.start()) + replacement + this.value.substring(match.end());
        }

        public String toString() {
            return this.value;
        }
    }
}

