/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.internal.testing.unit;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ElementVisitor;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.NestingKind;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVisitor;
import org.inferred.internal.testing.Partial;
import org.inferred.internal.testing.unit.NameImpl;
import org.inferred.internal.testing.unit.NoTypes;
import org.inferred.internal.testing.unit.PackageElementImpl;

public abstract class ClassTypeImpl
implements DeclaredType {
    private final Element enclosingElement;
    private final TypeMirror enclosingType;
    private final String simpleName;
    private final ElementKind kind;
    private final ImmutableSet<Modifier> modifiers;
    private final ImmutableList<TypeMirror> interfaces;

    public static Builder type(String simpleName) {
        return new Builder(simpleName);
    }

    public static Builder iface(String simpleName) {
        Builder builder = new Builder(simpleName);
        builder.kind = ElementKind.INTERFACE;
        builder.modifiers.add(Modifier.ABSTRACT);
        return builder;
    }

    public static ClassTypeImpl newTopLevelClass(String qualifiedName) {
        String pkg = qualifiedName.substring(0, qualifiedName.lastIndexOf(46));
        String simpleName = qualifiedName.substring(qualifiedName.lastIndexOf(46) + 1);
        return ClassTypeImpl.type(simpleName).inPackage(pkg).asMirror();
    }

    public static ClassTypeImpl newNestedClass(TypeElement enclosingType, String simpleName) {
        return ClassTypeImpl.type(simpleName).nestedIn(enclosingType).asMirror();
    }

    public static ClassTypeImpl newInnerClass(DeclaredType enclosingType, String simpleName) {
        return ClassTypeImpl.type(simpleName).innerClassIn(enclosingType).asMirror();
    }

    ClassTypeImpl(Builder builder) {
        this.enclosingElement = builder.enclosingElement;
        this.enclosingType = builder.enclosingType;
        this.simpleName = builder.simpleName;
        this.kind = builder.kind;
        this.modifiers = ImmutableSet.copyOf(builder.modifiers);
        this.interfaces = ImmutableList.copyOf(builder.interfaces);
    }

    @Override
    public TypeKind getKind() {
        return TypeKind.DECLARED;
    }

    @Override
    public <R, P> R accept(TypeVisitor<R, P> v, P p) {
        return v.visitDeclared(this, p);
    }

    @Override
    public ClassElementImpl asElement() {
        return Partial.of(ClassElementImpl.class, this);
    }

    @Override
    public TypeMirror getEnclosingType() {
        return this.enclosingType;
    }

    @Override
    public List<? extends TypeMirror> getTypeArguments() {
        return ImmutableList.of();
    }

    @Override
    public String toString() {
        String prefix = this.enclosingElement.getKind() == ElementKind.PACKAGE ? ((PackageElement)this.enclosingElement).getQualifiedName() + "." : ((TypeElement)this.enclosingElement).getQualifiedName() + ".";
        return prefix + this.simpleName;
    }

    @Override
    public int hashCode() {
        return this.toString().hashCode();
    }

    @Override
    public boolean equals(Object o) {
        return o instanceof ClassTypeImpl && this.toString().equals(o.toString());
    }

    public abstract class ClassElementImpl
    implements TypeElement {
        @Override
        public ClassTypeImpl asType() {
            return ClassTypeImpl.this;
        }

        @Override
        public ElementKind getKind() {
            return ClassTypeImpl.this.kind;
        }

        @Override
        public <R, P> R accept(ElementVisitor<R, P> v, P p) {
            return v.visitType(this, p);
        }

        @Override
        public NestingKind getNestingKind() {
            return ClassTypeImpl.this.enclosingElement.getKind() == ElementKind.PACKAGE ? NestingKind.TOP_LEVEL : NestingKind.MEMBER;
        }

        @Override
        public Name getQualifiedName() {
            return new NameImpl(ClassTypeImpl.this.toString());
        }

        @Override
        public Name getSimpleName() {
            return new NameImpl(ClassTypeImpl.this.simpleName);
        }

        @Override
        public TypeMirror getSuperclass() {
            return NoTypes.NONE;
        }

        public ImmutableList<TypeMirror> getInterfaces() {
            return ClassTypeImpl.this.interfaces;
        }

        @Override
        public List<? extends TypeParameterElement> getTypeParameters() {
            return ImmutableList.of();
        }

        @Override
        public Element getEnclosingElement() {
            return ClassTypeImpl.this.enclosingElement;
        }

        @Override
        public Set<Modifier> getModifiers() {
            return ClassTypeImpl.this.modifiers;
        }

        public String toString() {
            return ClassTypeImpl.this.kind.toString().toLowerCase() + " " + ClassTypeImpl.this.toString();
        }

        @Override
        public int hashCode() {
            return this.toString().hashCode();
        }

        @Override
        public boolean equals(Object o) {
            return o instanceof ClassElementImpl && this.toString().equals(o.toString());
        }
    }

    public static class Builder {
        Element enclosingElement = PackageElementImpl.create("org.example");
        TypeMirror enclosingType = NoTypes.NONE;
        String simpleName;
        ElementKind kind = ElementKind.CLASS;
        EnumSet<Modifier> modifiers = EnumSet.noneOf(Modifier.class);
        List<TypeMirror> interfaces = Lists.newArrayList();

        private Builder(String simpleName) {
            this.simpleName = simpleName;
        }

        public Builder inPackage(String qualifiedName) {
            this.enclosingElement = PackageElementImpl.create(qualifiedName);
            this.enclosingType = NoTypes.NONE;
            return this;
        }

        public Builder nestedIn(TypeElement enclosingElement) {
            this.enclosingElement = enclosingElement;
            this.enclosingType = NoTypes.NONE;
            return this;
        }

        public Builder innerClassIn(DeclaredType enclosingType) {
            this.enclosingElement = enclosingType.asElement();
            this.enclosingType = enclosingType;
            return this;
        }

        public Builder implementing(TypeMirror iface) {
            this.interfaces.add(iface);
            return this;
        }

        public Builder implementing(TypeElement iface) {
            this.interfaces.add(iface.asType());
            return this;
        }

        public ClassTypeImpl asMirror() {
            return Partial.of(ClassTypeImpl.class, this);
        }

        public TypeElement asElement() {
            return this.asMirror().asElement();
        }
    }
}

