/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.internal.testing.unit;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ElementVisitor;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.NestingKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import org.inferred.internal.source.QualifiedName;
import org.inferred.internal.testing.Partial;
import org.inferred.internal.testing.unit.ClassTypeImpl;
import org.inferred.internal.testing.unit.GenericElementParameter;
import org.inferred.internal.testing.unit.GenericMirror;
import org.inferred.internal.testing.unit.NameImpl;
import org.inferred.internal.testing.unit.PackageElementImpl;

public abstract class GenericElement
implements TypeElement {
    private final QualifiedName qualifiedName;
    private final ImmutableList<GenericElementParameter> typeParameters;

    GenericElement(QualifiedName qualifiedName, Iterable<? extends GenericElementParameter.Builder> typeParameterBuilders) {
        this.qualifiedName = qualifiedName;
        ImmutableList.Builder typeParametersBuilder = ImmutableList.builder();
        for (GenericElementParameter.Builder builder : typeParameterBuilders) {
            typeParametersBuilder.add((Object)builder.build(this));
        }
        this.typeParameters = typeParametersBuilder.build();
    }

    @Override
    public GenericMirror asType() {
        ArrayList<GenericElementParameter.TypeVariableImpl> typeArguments = new ArrayList<GenericElementParameter.TypeVariableImpl>();
        for (GenericElementParameter typeParameter : this.typeParameters) {
            typeArguments.add(typeParameter.asType());
        }
        return GenericMirror.create(new AtomicReference<GenericElement>(this), typeArguments);
    }

    @Override
    public ElementKind getKind() {
        return ElementKind.CLASS;
    }

    @Override
    public List<? extends AnnotationMirror> getAnnotationMirrors() {
        return ImmutableList.of();
    }

    @Override
    public <A extends Annotation> A getAnnotation(Class<A> annotationType) {
        return null;
    }

    public ImmutableSet<Modifier> getModifiers() {
        return ImmutableSet.of();
    }

    @Override
    public <R, P> R accept(ElementVisitor<R, P> v, P p) {
        return v.visitType(this, p);
    }

    @Override
    public List<? extends Element> getEnclosedElements() {
        return ImmutableList.of();
    }

    @Override
    public NestingKind getNestingKind() {
        return NestingKind.TOP_LEVEL;
    }

    @Override
    public Name getQualifiedName() {
        return new NameImpl(this.qualifiedName.toString());
    }

    @Override
    public Name getSimpleName() {
        return new NameImpl(this.qualifiedName.getSimpleName());
    }

    @Override
    public TypeMirror getSuperclass() {
        return ClassTypeImpl.newTopLevelClass("java.lang.Object");
    }

    @Override
    public List<? extends TypeMirror> getInterfaces() {
        return ImmutableList.of();
    }

    public ImmutableList<GenericElementParameter> getTypeParameters() {
        return this.typeParameters;
    }

    @Override
    public PackageElementImpl getEnclosingElement() {
        return PackageElementImpl.create(this.qualifiedName.getPackage());
    }

    public static class Builder {
        private final QualifiedName qualifiedName;
        private final LinkedHashMap<String, GenericElementParameter.Builder> typeParameters = new LinkedHashMap();
        private AtomicReference<GenericElement> element;

        public Builder(QualifiedName qualifiedName) {
            Preconditions.checkArgument((boolean)qualifiedName.isTopLevel(), (Object)"GenericElement currently only supports creating top-level classes");
            this.qualifiedName = qualifiedName;
        }

        public Builder addTypeParameter(String simpleName, TypeMirror ... bounds) {
            Preconditions.checkState((this.element == null ? 1 : 0) != 0, (Object)"Cannot add a new type parameter after calling asType() or build()");
            Preconditions.checkState((!this.typeParameters.containsKey(simpleName) ? 1 : 0) != 0, (String)"Duplicate type parameter \"%s\"", (Object[])new Object[]{simpleName});
            GenericElementParameter.Builder typeParameter = new GenericElementParameter.Builder(simpleName);
            for (TypeMirror bound : bounds) {
                typeParameter.addBound(bound);
            }
            this.typeParameters.put(simpleName, typeParameter);
            return this;
        }

        public GenericElementParameter.Builder getTypeParameter(String simpleName) {
            GenericElementParameter.Builder typeParameter = this.typeParameters.get(simpleName);
            if (typeParameter == null) {
                Preconditions.checkState((this.element == null ? 1 : 0) != 0, (Object)"Cannot add a new type parameter after calling asType() or build()");
                typeParameter = new GenericElementParameter.Builder(simpleName);
                this.typeParameters.put(simpleName, typeParameter);
            }
            return typeParameter;
        }

        public GenericMirror asType() {
            if (this.element == null) {
                this.element = new AtomicReference();
            }
            ArrayList<GenericElementParameter.TypeVariableImpl> typeArguments = new ArrayList<GenericElementParameter.TypeVariableImpl>();
            for (GenericElementParameter.Builder typeParameter : this.typeParameters.values()) {
                typeArguments.add(typeParameter.asType());
            }
            return GenericMirror.create(this.element, typeArguments);
        }

        public GenericElement build() {
            if (this.element == null) {
                this.element = new AtomicReference();
            }
            Preconditions.checkState((this.element.get() == null ? 1 : 0) != 0, (Object)"Cannot call build() twice");
            GenericElement impl = Partial.of(GenericElement.class, this.qualifiedName, this.typeParameters.values());
            this.element.set(impl);
            return impl;
        }
    }
}

