/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.internal.testing.unit;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ElementVisitor;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.TypeVisitor;
import org.inferred.internal.testing.Partial;
import org.inferred.internal.testing.unit.ClassTypeImpl;
import org.inferred.internal.testing.unit.GenericElement;
import org.inferred.internal.testing.unit.NameImpl;
import org.inferred.internal.testing.unit.NullTypeImpl;

public abstract class GenericElementParameter
implements TypeParameterElement {
    private final GenericElement genericElement;
    private final String simpleName;
    private final ImmutableList<TypeMirror> bounds;

    GenericElementParameter(GenericElement genericElement, String simpleName, Iterable<? extends TypeMirror> bounds) {
        this.genericElement = genericElement;
        this.simpleName = simpleName;
        this.bounds = ImmutableList.copyOf(bounds);
    }

    @Override
    public TypeVariableImpl asType() {
        return Partial.of(TypeVariableImpl.class, new AtomicReference<GenericElementParameter>(this));
    }

    @Override
    public ElementKind getKind() {
        return ElementKind.TYPE_PARAMETER;
    }

    @Override
    public List<? extends AnnotationMirror> getAnnotationMirrors() {
        return ImmutableList.of();
    }

    @Override
    public <A extends Annotation> A getAnnotation(Class<A> annotationType) {
        return null;
    }

    @Override
    public Set<Modifier> getModifiers() {
        return ImmutableSet.of();
    }

    @Override
    public Name getSimpleName() {
        return new NameImpl(this.simpleName);
    }

    @Override
    public List<? extends Element> getEnclosedElements() {
        return ImmutableList.of();
    }

    @Override
    public <R, P> R accept(ElementVisitor<R, P> v, P p) {
        return v.visitTypeParameter(this, p);
    }

    @Override
    public GenericElement getGenericElement() {
        return this.genericElement;
    }

    @Override
    public List<? extends TypeMirror> getBounds() {
        return this.bounds;
    }

    @Override
    public GenericElement getEnclosingElement() {
        return this.genericElement;
    }

    public String toString() {
        return this.simpleName;
    }

    public static abstract class TypeVariableImpl
    implements TypeVariable {
        private final AtomicReference<GenericElementParameter> element;

        TypeVariableImpl(AtomicReference<GenericElementParameter> element) {
            this.element = element;
        }

        @Override
        public TypeKind getKind() {
            return TypeKind.TYPEVAR;
        }

        @Override
        public <R, P> R accept(TypeVisitor<R, P> v, P p) {
            return v.visitTypeVariable(this, p);
        }

        @Override
        public GenericElementParameter asElement() {
            GenericElementParameter impl = this.getImpl("asElement()");
            return impl;
        }

        @Override
        public TypeMirror getUpperBound() {
            GenericElementParameter impl = this.getImpl("getUpperBound()");
            switch (impl.bounds.size()) {
                case 0: {
                    return ClassTypeImpl.newTopLevelClass("java.lang.Object");
                }
                case 1: {
                    return (TypeMirror)Iterables.getOnlyElement((Iterable)impl.bounds);
                }
            }
            throw new UnsupportedOperationException();
        }

        @Override
        public TypeMirror getLowerBound() {
            return NullTypeImpl.NULL;
        }

        @Override
        public String toString() {
            return this.getImpl("toString()").simpleName;
        }

        private GenericElementParameter getImpl(String calledMethod) {
            GenericElementParameter impl = this.element.get();
            Preconditions.checkState((impl != null ? 1 : 0) != 0, (String)"Cannot call %s on a TypeVariable returned from a %s before it is built", (Object[])new Object[]{calledMethod, Builder.class.getName()});
            return impl;
        }
    }

    public static class Builder {
        private final String simpleName;
        private final List<TypeMirror> bounds = new ArrayList<TypeMirror>();
        private final AtomicReference<GenericElementParameter> element = new AtomicReference();

        Builder(String simpleName) {
            this.simpleName = simpleName;
        }

        public Builder addBound(TypeMirror bound) {
            Preconditions.checkState((this.element.get() == null ? 1 : 0) != 0, (String)"Cannot modify a %s after calling build()", (Object[])new Object[]{Builder.class.getName()});
            this.bounds.add(bound);
            return this;
        }

        public TypeVariableImpl asType() {
            return Partial.of(TypeVariableImpl.class, this.element);
        }

        GenericElementParameter build(GenericElement genericElement) {
            GenericElementParameter impl = Partial.of(GenericElementParameter.class, genericElement, this.simpleName, this.bounds);
            boolean notYetSet = this.element.compareAndSet(null, impl);
            Preconditions.checkState((boolean)notYetSet, (String)"Cannot call build() twice on a %s", (Object[])new Object[]{Builder.class.getName()});
            return impl;
        }
    }
}

