/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.internal.testing.unit;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.NoType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVisitor;
import org.inferred.internal.testing.Partial;
import org.inferred.internal.testing.unit.GenericElement;
import org.inferred.internal.testing.unit.NoTypes;

public abstract class GenericMirror
implements DeclaredType {
    private final AtomicReference<GenericElement> element;
    private final ImmutableList<TypeMirror> typeArguments;

    static GenericMirror create(AtomicReference<GenericElement> element, Iterable<? extends TypeMirror> typeArguments) {
        return Partial.of(GenericMirror.class, element, typeArguments);
    }

    GenericMirror(AtomicReference<GenericElement> element, Iterable<? extends TypeMirror> typeArguments) {
        this.element = element;
        this.typeArguments = ImmutableList.copyOf(typeArguments);
    }

    @Override
    public TypeKind getKind() {
        return TypeKind.DECLARED;
    }

    @Override
    public <R, P> R accept(TypeVisitor<R, P> v, P p) {
        return v.visitDeclared(this, p);
    }

    @Override
    public GenericElement asElement() {
        GenericElement impl = this.element.get();
        Preconditions.checkState((impl != null ? 1 : 0) != 0, (Object)"Cannot call asElement() on a GenericMirror referencing an unbuilt GenericType");
        return impl;
    }

    @Override
    public NoType getEnclosingType() {
        return NoTypes.NONE;
    }

    @Override
    public List<? extends TypeMirror> getTypeArguments() {
        return this.typeArguments;
    }
}

