/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.internal.testing.unit;

import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ElementVisitor;
import javax.lang.model.element.Name;
import javax.lang.model.element.PackageElement;
import javax.lang.model.type.NoType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVisitor;
import org.inferred.internal.testing.Partial;
import org.inferred.internal.testing.unit.NameImpl;

public abstract class PackageElementImpl
implements PackageElement {
    private final String qualifiedName;

    public static PackageElementImpl create(String qualifiedName) {
        return Partial.of(PackageElementImpl.class, qualifiedName);
    }

    PackageElementImpl(String qualifiedName) {
        this.qualifiedName = qualifiedName;
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof PackageElementImpl && this.qualifiedName.equals(((PackageElementImpl)obj).qualifiedName);
    }

    @Override
    public int hashCode() {
        return this.qualifiedName.hashCode();
    }

    public String toString() {
        return "package " + this.qualifiedName;
    }

    @Override
    public TypeMirror asType() {
        return Partial.of(PackageTypeImpl.class, this.qualifiedName);
    }

    @Override
    public ElementKind getKind() {
        return ElementKind.PACKAGE;
    }

    @Override
    public <R, P> R accept(ElementVisitor<R, P> v, P p) {
        return v.visitPackage(this, p);
    }

    @Override
    public Name getQualifiedName() {
        return new NameImpl(this.qualifiedName);
    }

    @Override
    public Name getSimpleName() {
        String simpleName = this.qualifiedName.substring(this.qualifiedName.lastIndexOf(46) + 1);
        return new NameImpl(simpleName);
    }

    @Override
    public Element getEnclosingElement() {
        return null;
    }

    @Override
    public boolean isUnnamed() {
        return false;
    }

    static abstract class PackageTypeImpl
    implements NoType {
        private final String qualifiedName;

        private PackageTypeImpl(String qualifiedName) {
            this.qualifiedName = qualifiedName;
        }

        @Override
        public TypeKind getKind() {
            return TypeKind.PACKAGE;
        }

        @Override
        public <R, P> R accept(TypeVisitor<R, P> v, P p) {
            return v.visitNoType(this, p);
        }

        @Override
        public boolean equals(Object obj) {
            return obj instanceof PackageTypeImpl && this.toString().equals(obj.toString());
        }

        @Override
        public int hashCode() {
            return this.qualifiedName.hashCode();
        }

        @Override
        public String toString() {
            return "package " + this.qualifiedName;
        }
    }
}

