/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.internal.testing.unit;

import com.google.common.base.Preconditions;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeVisitor;
import org.inferred.internal.testing.Partial;

public abstract class PrimitiveTypeImpl
implements PrimitiveType {
    public static final PrimitiveType CHAR = Partial.of(PrimitiveTypeImpl.class, new Object[]{TypeKind.CHAR});
    public static final PrimitiveType INT = Partial.of(PrimitiveTypeImpl.class, new Object[]{TypeKind.INT});
    public static final PrimitiveType FLOAT = Partial.of(PrimitiveTypeImpl.class, new Object[]{TypeKind.FLOAT});
    public static final PrimitiveType DOUBLE = Partial.of(PrimitiveTypeImpl.class, new Object[]{TypeKind.DOUBLE});
    private final TypeKind kind;

    PrimitiveTypeImpl(TypeKind kind) {
        Preconditions.checkState((boolean)kind.isPrimitive());
        this.kind = kind;
    }

    @Override
    public TypeKind getKind() {
        return this.kind;
    }

    @Override
    public <R, P> R accept(TypeVisitor<R, P> v, P p) {
        return v.visitPrimitive(this, p);
    }

    @Override
    public String toString() {
        return this.kind.toString().toLowerCase();
    }
}

