/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.internal.source;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.Map;
import org.inferred.internal.source.Excerpt;
import org.inferred.internal.source.Excerpts;
import org.inferred.internal.source.SourceBuilder;
import org.inferred.internal.source.SourceStringBuilder;
import org.inferred.internal.source.ValueType;
import org.inferred.internal.source.feature.Feature;
import org.inferred.internal.source.feature.FeatureType;

public class Block
extends Excerpt
implements SourceBuilder {
    private final Map<String, Excerpt> declarations = Maps.newLinkedHashMap();
    private final SourceStringBuilder body;

    public Block(SourceBuilder parent) {
        this.body = parent.subBuilder();
    }

    public Excerpt declare(String name, String declfmt, Object ... declArgs) {
        Excerpt declaration = Excerpts.add(declfmt, declArgs);
        Excerpt existingDeclaration = this.declarations.put(name, declaration);
        Preconditions.checkState((existingDeclaration == null || declaration.equals(existingDeclaration) ? 1 : 0) != 0, (String)"Incompatible declaration for '%s': %s vs %s", (Object[])new Object[]{name, declaration, existingDeclaration});
        return Excerpts.add("%s", name);
    }

    @Override
    public Block add(String fmt, Object ... args) {
        this.body.add(fmt, args);
        return this;
    }

    @Override
    public Block addLine(String fmt, Object ... args) {
        this.body.addLine(fmt, args);
        return this;
    }

    @Override
    public Block add(Excerpt excerpt) {
        this.body.add(excerpt);
        return this;
    }

    @Override
    public SourceStringBuilder subBuilder() {
        return this.body.subBuilder();
    }

    @Override
    public <T extends Feature<T>> T feature(FeatureType<T> featureType) {
        return this.body.feature(featureType);
    }

    @Override
    public void addTo(SourceBuilder source) {
        for (Excerpt declaration : this.declarations.values()) {
            source.add(declaration);
        }
        source.add("%s", this.body);
    }

    @Override
    protected void addFields(ValueType.FieldReceiver fields) {
        fields.add("declarations", this.declarations);
        fields.add("body", this.body.toString());
    }
}

