/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.internal.source;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.List;
import org.inferred.internal.source.Excerpt;
import org.inferred.internal.source.SourceBuilder;
import org.inferred.internal.source.ValueType;

public class Excerpts {
    private static final Excerpt EMPTY = new EmptyExcerpt();

    public static Excerpt add(String fmt, Object ... args) {
        return new AddingExcerpt(fmt, args);
    }

    public static Excerpt empty() {
        return EMPTY;
    }

    public static Object join(String separator, Iterable<?> excerpts) {
        return new JoiningExcerpt(separator, excerpts);
    }

    private Excerpts() {
    }

    private static final class JoiningExcerpt
    extends Excerpt {
        private final String separator;
        private final List<?> excerpts;

        private JoiningExcerpt(String separator, Iterable<?> excerpts) {
            this.separator = separator;
            this.excerpts = ImmutableList.copyOf(excerpts);
        }

        @Override
        public void addTo(SourceBuilder source) {
            String itemPrefix = "";
            for (Object object : this.excerpts) {
                source.add("%s%s", itemPrefix, object);
                itemPrefix = this.separator;
            }
        }

        @Override
        protected void addFields(ValueType.FieldReceiver fields) {
            fields.add("separator", this.separator);
            fields.add("excerpts", this.excerpts);
        }
    }

    private static final class EmptyExcerpt
    extends Excerpt {
        private EmptyExcerpt() {
        }

        @Override
        public void addTo(SourceBuilder source) {
        }

        @Override
        protected void addFields(ValueType.FieldReceiver fields) {
        }
    }

    private static final class AddingExcerpt
    extends Excerpt {
        private final String fmt;
        private final Object[] args;

        private AddingExcerpt(String fmt, Object[] args) {
            this.args = args;
            this.fmt = fmt;
        }

        @Override
        public void addTo(SourceBuilder source) {
            source.add(this.fmt, this.args);
        }

        @Override
        public String toString() {
            StringBuilder result = new StringBuilder().append("Excerpts.add(\"").append(this.fmt.replaceAll("[\\\"]", "\\\u0001")).append('\"');
            for (Object arg : this.args) {
                result.append(", ").append(arg);
            }
            result.append(")");
            return result.toString();
        }

        @Override
        protected void addFields(ValueType.FieldReceiver fields) {
            fields.add("fmt", this.fmt);
            fields.add("args", Arrays.asList(this.args));
        }
    }
}

