/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.internal.source;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Name;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.SimpleTypeVisitor6;
import org.inferred.internal.source.QualifiedName;
import org.inferred.internal.source.Shading;
import org.inferred.internal.source.TypeShortener;

class ImportManager
extends SimpleTypeVisitor6<String, Void>
implements Function<TypeMirror, String>,
TypeShortener {
    private static final String JAVA_LANG_PACKAGE = "java.lang";
    private static final String PACKAGE_PREFIX = "package ";
    private final Set<String> visibleSimpleNames = new HashSet<String>();
    private final ImmutableSet<String> implicitImports;
    private final Set<String> explicitImports = new TreeSet<String>();

    private ImportManager(Iterable<String> visibleSimpleNames, Iterable<String> implicitImports) {
        Iterables.addAll(this.visibleSimpleNames, visibleSimpleNames);
        this.implicitImports = ImmutableSet.copyOf(implicitImports);
    }

    public Set<String> getClassImports() {
        return Collections.unmodifiableSet(this.explicitImports);
    }

    @Override
    public String shorten(TypeMirror mirror) {
        return mirror.accept(this, null);
    }

    @Override
    public String shorten(QualifiedName type) {
        String prefix = this.getPrefixForTopLevelClass(type.getPackage(), (CharSequence)type.getSimpleNames().get(0));
        return prefix + Joiner.on((char)'.').join(type.getSimpleNames());
    }

    public String apply(TypeMirror mirror) {
        return mirror.accept(this, null);
    }

    @Override
    public String visitDeclared(DeclaredType mirror, Void p) {
        String suffix;
        String prefix;
        Name name = mirror.asElement().getSimpleName();
        Element enclosingElement = mirror.asElement().getEnclosingElement();
        if (mirror.getEnclosingType().getKind() != TypeKind.NONE) {
            prefix = (String)this.visit(mirror.getEnclosingType()) + ".";
        } else if (enclosingElement.getKind() == ElementKind.PACKAGE) {
            PackageElement pkg = (PackageElement)enclosingElement;
            prefix = this.getPrefixForTopLevelClass(pkg.getQualifiedName().toString(), name);
        } else {
            prefix = enclosingElement.getKind().isClass() || enclosingElement.getKind().isInterface() ? this.shorten(QualifiedName.of((TypeElement)enclosingElement)) + "." : enclosingElement.toString() + ".";
        }
        if (!mirror.getTypeArguments().isEmpty()) {
            List shortTypeArguments = Lists.transform(mirror.getTypeArguments(), (Function)this);
            suffix = "<" + Joiner.on((String)", ").join((Iterable)shortTypeArguments) + ">";
        } else {
            suffix = "";
        }
        return prefix + name + suffix;
    }

    private String getPrefixForTopLevelClass(String pkg, CharSequence name) {
        String qualifiedName;
        if (pkg.startsWith(PACKAGE_PREFIX)) {
            pkg = pkg.substring(PACKAGE_PREFIX.length());
        }
        if (this.implicitImports.contains((Object)(qualifiedName = (pkg = Shading.unshadedName(pkg)) + "." + name)) || this.explicitImports.contains(qualifiedName)) {
            return "";
        }
        if (this.visibleSimpleNames.contains(name.toString())) {
            return pkg + ".";
        }
        if (pkg.equals(JAVA_LANG_PACKAGE)) {
            return "";
        }
        this.visibleSimpleNames.add(name.toString());
        this.explicitImports.add(qualifiedName);
        return "";
    }

    @Override
    protected String defaultAction(TypeMirror mirror, Void p) {
        return mirror.toString();
    }

    public static class Builder {
        private final SetMultimap<String, QualifiedName> implicitImports = LinkedHashMultimap.create();

        public Builder addImplicitImport(QualifiedName type) {
            this.implicitImports.put((Object)type.getSimpleName(), (Object)type);
            return this;
        }

        public ImportManager build() {
            LinkedHashSet<String> nonConflictingImports = new LinkedHashSet<String>();
            for (Set importGroup : Multimaps.asMap(this.implicitImports).values()) {
                QualifiedName implicitImport;
                if (importGroup.size() != 1 || !(implicitImport = (QualifiedName)Iterables.getOnlyElement((Iterable)importGroup)).isTopLevel()) continue;
                nonConflictingImports.add(implicitImport.toString());
            }
            return new ImportManager(this.implicitImports.keySet(), nonConflictingImports);
        }
    }
}

