/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.internal.source;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.List;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import org.inferred.internal.source.ParameterizedType;
import org.inferred.internal.source.ValueType;

public class QualifiedName
extends ValueType {
    private final String packageName;
    private final ImmutableList<String> simpleNames;

    public static QualifiedName of(String packageName, String topLevelType, String ... nestedTypes) {
        Preconditions.checkNotNull((Object)(!packageName.isEmpty() ? 1 : 0));
        Preconditions.checkArgument((!topLevelType.isEmpty() ? 1 : 0) != 0);
        return new QualifiedName(packageName, (Iterable<String>)ImmutableList.builder().add((Object)topLevelType).add((Object[])nestedTypes).build());
    }

    public static QualifiedName of(Class<?> cls) {
        if (cls.getEnclosingClass() != null) {
            return QualifiedName.of(cls.getEnclosingClass()).nestedType(cls.getSimpleName());
        }
        if (cls.getPackage() != null) {
            return QualifiedName.of(cls.getPackage().getName(), cls.getSimpleName(), new String[0]);
        }
        return QualifiedName.of("", cls.getSimpleName(), new String[0]);
    }

    public static QualifiedName of(TypeElement type) {
        if (type.getNestingKind().isNested()) {
            QualifiedName enclosingElement = QualifiedName.of((TypeElement)type.getEnclosingElement());
            return enclosingElement.nestedType(type.getSimpleName().toString());
        }
        PackageElement pkg = (PackageElement)type.getEnclosingElement();
        return QualifiedName.of(pkg.getQualifiedName().toString(), type.getSimpleName().toString(), new String[0]);
    }

    private QualifiedName(String packageName, Iterable<String> simpleNames) {
        this.packageName = packageName;
        this.simpleNames = ImmutableList.copyOf(simpleNames);
    }

    @Override
    public String toString() {
        return this.packageName + "." + Joiner.on((char)'.').join(this.simpleNames);
    }

    public String getPackage() {
        return this.packageName;
    }

    public ImmutableList<String> getSimpleNames() {
        return this.simpleNames;
    }

    public String getSimpleName() {
        return (String)Iterables.getLast(this.simpleNames);
    }

    public boolean isTopLevel() {
        return this.simpleNames.size() == 1;
    }

    public QualifiedName nestedType(String simpleName) {
        return new QualifiedName(this.packageName, Iterables.concat(this.simpleNames, (Iterable)ImmutableList.of((Object)simpleName)));
    }

    public ParameterizedType withParameters(String ... typeParameters) {
        return new ParameterizedType(this, (List<?>)ImmutableList.copyOf((Object[])typeParameters));
    }

    public ParameterizedType withParameters(Iterable<? extends TypeParameterElement> typeParameters) {
        return new ParameterizedType(this, (List<?>)ImmutableList.copyOf(typeParameters));
    }

    public QualifiedName getEnclosingType() {
        Preconditions.checkState((!this.isTopLevel() ? 1 : 0) != 0, (String)"%s has no enclosing type", (Object[])new Object[]{this});
        return new QualifiedName(this.packageName, (Iterable<String>)this.simpleNames.subList(0, this.simpleNames.size() - 1));
    }

    @Override
    protected void addFields(ValueType.FieldReceiver fields) {
        fields.add("packageName", this.packageName);
        fields.add("simpleNames", this.simpleNames);
    }
}

