/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.internal.source;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Ordering;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.Set;
import javax.annotation.processing.Completion;
import javax.annotation.processing.Filer;
import javax.annotation.processing.FilerException;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import org.inferred.internal.source.CannotGenerateCodeException;
import org.inferred.internal.source.ModelUtils;
import org.inferred.internal.source.RoundEnvironments;

public abstract class SimpleTypeProcessor
implements Processor {
    protected Elements elements;
    protected ProcessingEnvironment env;
    protected Filer filer;
    protected Messager messager;
    protected Types types;

    protected void init() {
    }

    protected abstract SourceVersion minimumSupportedVersion();

    protected abstract Class<? extends Annotation> annotation();

    protected abstract void processAnnotatedElements(Set<? extends Element> var1, RoundEnvironment var2);

    protected void process(Iterable<? extends TypeElement> types, Processing processing) {
        for (TypeElement typeElement : types) {
            try {
                processing.process(typeElement);
            }
            catch (CannotGenerateCodeException e) {
            }
            catch (FilerException e) {
                this.messager.printMessage(Diagnostic.Kind.WARNING, "Error generating type: " + e.getMessage(), typeElement, (AnnotationMirror)ModelUtils.findAnnotationMirror((Element)typeElement, this.annotation()).get());
            }
            catch (IOException e) {
                this.messager.printMessage(Diagnostic.Kind.ERROR, "I/O error: " + Throwables.getStackTraceAsString((Throwable)e), typeElement, (AnnotationMirror)ModelUtils.findAnnotationMirror((Element)typeElement, this.annotation()).get());
            }
            catch (RuntimeException e) {
                this.messager.printMessage(Diagnostic.Kind.ERROR, "Internal error: " + Throwables.getStackTraceAsString((Throwable)e), typeElement, (AnnotationMirror)ModelUtils.findAnnotationMirror((Element)typeElement, this.annotation()).get());
            }
        }
    }

    @Override
    public void init(ProcessingEnvironment processingEnv) {
        this.elements = processingEnv.getElementUtils();
        this.env = processingEnv;
        this.filer = processingEnv.getFiler();
        this.messager = processingEnv.getMessager();
        this.types = processingEnv.getTypeUtils();
        this.init();
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return ImmutableSet.of((Object)this.annotation().getName());
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return (SourceVersion)((Object)Ordering.natural().max((Object)SourceVersion.latestSupported(), (Object)this.minimumSupportedVersion()));
    }

    @Override
    public Set<String> getSupportedOptions() {
        return ImmutableSet.of();
    }

    @Override
    public Iterable<? extends Completion> getCompletions(Element element, AnnotationMirror annotation, ExecutableElement member, String userText) {
        return ImmutableSet.of();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        this.processAnnotatedElements(RoundEnvironments.annotatedElementsIn(roundEnv, this.annotation()), roundEnv);
        return false;
    }

    protected static interface Processing {
        public void process(TypeElement var1) throws CannotGenerateCodeException, IOException;
    }
}

