/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.internal.source;

import com.google.common.base.Preconditions;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.inferred.internal.source.AnnotationSource;
import org.inferred.internal.source.Excerpt;
import org.inferred.internal.source.IsInvalidTypeVisitor;
import org.inferred.internal.source.QualifiedName;
import org.inferred.internal.source.SourceBuilder;
import org.inferred.internal.source.TypeShortener;
import org.inferred.internal.source.feature.Feature;
import org.inferred.internal.source.feature.FeatureSet;
import org.inferred.internal.source.feature.FeatureType;
import org.inferred.internal.source.feature.StaticFeatureSet;

public final class SourceStringBuilder
implements SourceBuilder {
    private final TypeShortener shortener;
    private final StringBuilder destination = new StringBuilder();
    private final FeatureSet features;

    public static SourceBuilder simple(Feature<?> ... features) {
        return new SourceStringBuilder(new TypeShortener.AlwaysShorten(), new StaticFeatureSet(features));
    }

    SourceStringBuilder(TypeShortener shortener, FeatureSet features) {
        this.shortener = shortener;
        this.features = features;
    }

    @Override
    public SourceBuilder add(Excerpt excerpt) {
        excerpt.addTo(this);
        return this;
    }

    @Override
    public SourceBuilder add(String fmt, Object ... args) {
        Object[] substituteArgs = new Object[args.length];
        for (int i = 0; i < args.length; ++i) {
            substituteArgs[i] = this.substitute(args[i]);
        }
        this.destination.append(String.format(fmt, substituteArgs));
        return this;
    }

    @Override
    public SourceBuilder addLine(String fmt, Object ... args) {
        return this.add(fmt + "\n", args);
    }

    @Override
    public SourceStringBuilder subBuilder() {
        return new SourceStringBuilder(this.shortener, this.features);
    }

    @Override
    public <T extends Feature<T>> T feature(FeatureType<T> feature) {
        return this.features.get(feature);
    }

    public String toString() {
        return this.destination.toString();
    }

    private Object substitute(Object arg) {
        if (arg instanceof Excerpt) {
            SourceStringBuilder excerptBuilder = this.subBuilder();
            ((Excerpt)arg).addTo(excerptBuilder);
            return ((Object)excerptBuilder).toString();
        }
        if (arg instanceof Package) {
            return ((Package)arg).getName();
        }
        if (arg instanceof Element) {
            ElementKind kind = ((Element)arg).getKind();
            if (kind == ElementKind.PACKAGE) {
                return ((PackageElement)arg).getQualifiedName();
            }
            if (kind.isClass() || kind.isInterface()) {
                return this.shortener.shorten(QualifiedName.of((TypeElement)arg));
            }
            return arg;
        }
        if (arg instanceof Class) {
            return this.shortener.shorten(QualifiedName.of((Class)arg));
        }
        if (arg instanceof TypeMirror && ((TypeMirror)arg).getKind() == TypeKind.DECLARED) {
            DeclaredType mirror = (DeclaredType)arg;
            Preconditions.checkArgument((boolean)SourceStringBuilder.isLegalType(mirror), (String)"Cannot write unknown type %s", (Object[])new Object[]{mirror});
            return this.shortener.shorten(mirror);
        }
        if (arg instanceof QualifiedName) {
            return this.shortener.shorten((QualifiedName)arg);
        }
        if (arg instanceof AnnotationMirror) {
            SourceStringBuilder excerptBuilder = this.subBuilder();
            AnnotationSource.addSource(excerptBuilder, (AnnotationMirror)arg);
            return ((Object)excerptBuilder).toString();
        }
        return arg;
    }

    private static boolean isLegalType(TypeMirror mirror) {
        return (Boolean)new IsInvalidTypeVisitor().visit(mirror) == false;
    }
}

