/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.internal.source;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.util.List;
import javax.lang.model.element.Name;
import javax.lang.model.element.PackageElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.SimpleTypeVisitor6;
import org.inferred.internal.source.QualifiedName;

interface TypeShortener {
    public String shorten(TypeMirror var1);

    public String shorten(QualifiedName var1);

    public static class AlwaysShorten
    extends SimpleTypeVisitor6<String, Void>
    implements Function<TypeMirror, String>,
    TypeShortener {
        @Override
        public String shorten(TypeMirror mirror) {
            return mirror.accept(this, null);
        }

        @Override
        public String shorten(QualifiedName type) {
            return type.toString().substring(type.getPackage().length() + 1);
        }

        public String apply(TypeMirror mirror) {
            return mirror.accept(this, null);
        }

        @Override
        public String visitDeclared(DeclaredType mirror, Void p) {
            String suffix;
            Name name = mirror.asElement().getSimpleName();
            String prefix = mirror.getEnclosingType().getKind() == TypeKind.NONE ? "" : (String)this.visit(mirror.getEnclosingType()) + ".";
            if (!mirror.getTypeArguments().isEmpty()) {
                List shortTypeArguments = Lists.transform(mirror.getTypeArguments(), (Function)this);
                suffix = "<" + Joiner.on((String)", ").join((Iterable)shortTypeArguments) + ">";
            } else {
                suffix = "";
            }
            return prefix + name + suffix;
        }

        @Override
        protected String defaultAction(TypeMirror mirror, Void p) {
            return mirror.toString();
        }
    }

    public static class NeverShorten
    extends SimpleTypeVisitor6<String, Void>
    implements Function<TypeMirror, String>,
    TypeShortener {
        @Override
        public String shorten(TypeMirror mirror) {
            return mirror.accept(this, null);
        }

        @Override
        public String shorten(QualifiedName type) {
            return type.toString();
        }

        public String apply(TypeMirror mirror) {
            return mirror.accept(this, null);
        }

        @Override
        public String visitDeclared(DeclaredType mirror, Void p) {
            String suffix;
            Name name = mirror.asElement().getSimpleName();
            String prefix = mirror.getEnclosingType().getKind() == TypeKind.NONE ? ((PackageElement)mirror.asElement().getEnclosingElement()).getQualifiedName() + "." : (String)this.visit(mirror.getEnclosingType()) + ".";
            if (!mirror.getTypeArguments().isEmpty()) {
                List shortTypeArguments = Lists.transform(mirror.getTypeArguments(), (Function)this);
                suffix = "<" + Joiner.on((String)", ").join((Iterable)shortTypeArguments) + ">";
            } else {
                suffix = "";
            }
            return prefix + name + suffix;
        }

        @Override
        protected String defaultAction(TypeMirror mirror, Void p) {
            return mirror.toString();
        }
    }
}

