/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.internal.source.feature;

import com.google.common.base.Optional;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.util.Elements;
import org.inferred.internal.source.ParameterizedType;
import org.inferred.internal.source.QualifiedName;
import org.inferred.internal.source.Shading;
import org.inferred.internal.source.feature.Feature;
import org.inferred.internal.source.feature.FeatureType;

public enum FunctionPackage implements Feature<FunctionPackage>
{
    AVAILABLE,
    UNAVAILABLE;

    public static final FeatureType<FunctionPackage> FUNCTION_PACKAGE;
    private static final String ECLIPSE_DISPATCHER;
    private static final ParameterizedType CONSUMER;
    private static final ParameterizedType BI_CONSUMER;
    private static final ParameterizedType UNARY_OPERATOR;

    public Optional<ParameterizedType> consumer() {
        return this.ifAvailable(CONSUMER);
    }

    public Optional<ParameterizedType> biConsumer() {
        return this.ifAvailable(BI_CONSUMER);
    }

    public Optional<ParameterizedType> unaryOperator() {
        return this.ifAvailable(UNARY_OPERATOR);
    }

    private static boolean runningInEclipse() {
        Throwable t = new Throwable();
        t.fillInStackTrace();
        for (StackTraceElement method : t.getStackTrace()) {
            if (method.getClassName().equals(ECLIPSE_DISPATCHER)) {
                return true;
            }
            if (method.getClassName().startsWith("org.inferred")) continue;
            return false;
        }
        return false;
    }

    private static boolean hasLambdas(SourceVersion version) {
        return version.ordinal() >= 8;
    }

    private static boolean hasType(Elements elements, ParameterizedType type) {
        return elements.getTypeElement(type.getQualifiedName().toString()) != null;
    }

    private <T> Optional<T> ifAvailable(T value) {
        return this == AVAILABLE ? Optional.of(value) : Optional.absent();
    }

    static {
        FUNCTION_PACKAGE = new FeatureType<FunctionPackage>(){

            @Override
            protected FunctionPackage testDefault() {
                return UNAVAILABLE;
            }

            @Override
            protected FunctionPackage forEnvironment(ProcessingEnvironment env) {
                if (FunctionPackage.runningInEclipse()) {
                    return FunctionPackage.hasType(env.getElementUtils(), CONSUMER) ? AVAILABLE : UNAVAILABLE;
                }
                return FunctionPackage.hasLambdas(env.getSourceVersion()) ? AVAILABLE : UNAVAILABLE;
            }
        };
        ECLIPSE_DISPATCHER = Shading.unshadedName("org.eclipse.jdt.internal.compiler.apt.dispatch.RoundDispatcher");
        CONSUMER = QualifiedName.of("java.util.function", "Consumer", new String[0]).withParameters("T");
        BI_CONSUMER = QualifiedName.of("java.util.function", "BiConsumer", new String[0]).withParameters("T", "U");
        UNARY_OPERATOR = QualifiedName.of("java.util.function", "UnaryOperator", new String[0]).withParameters("T");
    }
}

