/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.internal.source.feature;

import com.google.common.base.Optional;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.SourceVersion;
import org.inferred.internal.source.Excerpt;
import org.inferred.internal.source.QualifiedName;
import org.inferred.internal.source.SourceBuilder;
import org.inferred.internal.source.ValueType;
import org.inferred.internal.source.feature.Feature;
import org.inferred.internal.source.feature.FeatureType;

public enum SourceLevel implements Feature<SourceLevel>
{
    JAVA_6,
    JAVA_7;

    public static final FeatureType<SourceLevel> SOURCE_LEVEL;

    public static Excerpt diamondOperator(Object type) {
        return new DiamondOperator(type);
    }

    public Optional<QualifiedName> javaUtilObjects() {
        switch (this) {
            case JAVA_6: {
                return Optional.absent();
            }
        }
        return Optional.of((Object)QualifiedName.of("java.util", "Objects", new String[0]));
    }

    static {
        SOURCE_LEVEL = new FeatureType<SourceLevel>(){

            @Override
            protected SourceLevel testDefault() {
                return JAVA_6;
            }

            @Override
            protected SourceLevel forEnvironment(ProcessingEnvironment env) {
                if (env.getSourceVersion().compareTo(SourceVersion.RELEASE_6) <= 0) {
                    return JAVA_6;
                }
                return JAVA_7;
            }
        };
    }

    private static final class DiamondOperator
    extends Excerpt {
        private final Object type;

        private DiamondOperator(Object type) {
            this.type = type;
        }

        @Override
        public void addTo(SourceBuilder source) {
            if (source.feature(SOURCE_LEVEL).compareTo(JAVA_7) >= 0) {
                source.add("<>", new Object[0]);
            } else {
                source.add("<%s>", this.type);
            }
        }

        @Override
        public String toString() {
            return "diamondOperator(" + this.type + ")";
        }

        @Override
        protected void addFields(ValueType.FieldReceiver fields) {
            fields.add("type", this.type);
        }
    }
}

