/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.source;

import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Name;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.SimpleTypeVisitor6;
import org.inferred.source.Shading;
import org.inferred.source.TypeReference;
import org.inferred.source.TypeShortener;
import org.inferred.source.shaded.com.google.common.base.Function;
import org.inferred.source.shaded.com.google.common.base.Joiner;
import org.inferred.source.shaded.com.google.common.collect.ImmutableSet;
import org.inferred.source.shaded.com.google.common.collect.Iterables;
import org.inferred.source.shaded.com.google.common.collect.LinkedHashMultimap;
import org.inferred.source.shaded.com.google.common.collect.Lists;
import org.inferred.source.shaded.com.google.common.collect.Multimaps;
import org.inferred.source.shaded.com.google.common.collect.SetMultimap;

class ImportManager
extends SimpleTypeVisitor6<String, Void>
implements Function<TypeMirror, String>,
TypeShortener {
    private static final String JAVA_LANG_PACKAGE = "java.lang";
    private static final String PACKAGE_PREFIX = "package ";
    private final Set<String> visibleSimpleNames = new HashSet<String>();
    private final ImmutableSet<String> implicitImports;
    private final Set<String> explicitImports = new TreeSet<String>();

    private ImportManager(Iterable<String> visibleSimpleNames, Iterable<String> implicitImports) {
        Iterables.addAll(this.visibleSimpleNames, visibleSimpleNames);
        this.implicitImports = ImmutableSet.copyOf(implicitImports);
    }

    public Set<String> getClassImports() {
        return Collections.unmodifiableSet(this.explicitImports);
    }

    @Override
    public String shorten(Class<?> cls) {
        if (cls.getEnclosingClass() != null) {
            return this.shorten(cls.getEnclosingClass()) + "." + cls.getSimpleName();
        }
        if (cls.getPackage() != null) {
            return this.getPrefixForTopLevelClass(cls.getPackage().getName(), cls.getSimpleName()) + cls.getSimpleName();
        }
        return cls.getSimpleName();
    }

    @Override
    public String shorten(TypeElement type) {
        Element parent = type.getEnclosingElement();
        if (parent.getKind() == ElementKind.PACKAGE) {
            return this.getPrefixForTopLevelClass(parent.toString(), type.getSimpleName()) + type.getSimpleName();
        }
        if (parent.getKind().isInterface() || parent.getKind().isClass()) {
            return this.shorten((TypeElement)parent) + "." + type.getSimpleName();
        }
        return type.getQualifiedName().toString();
    }

    @Override
    public String shorten(TypeMirror mirror) {
        return mirror.accept(this, null);
    }

    @Override
    public String shorten(TypeReference type) {
        String prefix = this.getPrefixForTopLevelClass(type.getPackage(), type.getTopLevelTypeSimpleName());
        return prefix + type.getTopLevelTypeSimpleName() + type.getNestedSuffix();
    }

    @Override
    public String apply(TypeMirror mirror) {
        return mirror.accept(this, null);
    }

    @Override
    public String visitDeclared(DeclaredType mirror, Void p) {
        String suffix;
        String prefix;
        Name name = mirror.asElement().getSimpleName();
        Element enclosingElement = mirror.asElement().getEnclosingElement();
        if (mirror.getEnclosingType().getKind() != TypeKind.NONE) {
            prefix = (String)this.visit(mirror.getEnclosingType()) + ".";
        } else if (enclosingElement.getKind() == ElementKind.PACKAGE) {
            PackageElement pkg = (PackageElement)enclosingElement;
            prefix = this.getPrefixForTopLevelClass(pkg.getQualifiedName().toString(), name);
        } else {
            prefix = enclosingElement.getKind().isClass() || enclosingElement.getKind().isInterface() ? this.shorten((TypeElement)enclosingElement) + "." : enclosingElement.toString() + ".";
        }
        if (!mirror.getTypeArguments().isEmpty()) {
            List<String> shortTypeArguments = Lists.transform(mirror.getTypeArguments(), this);
            suffix = "<" + Joiner.on(", ").join(shortTypeArguments) + ">";
        } else {
            suffix = "";
        }
        return prefix + name + suffix;
    }

    private String getPrefixForTopLevelClass(String pkg, CharSequence name) {
        String qualifiedName;
        if (pkg.startsWith(PACKAGE_PREFIX)) {
            pkg = pkg.substring(PACKAGE_PREFIX.length());
        }
        if (this.implicitImports.contains(qualifiedName = (pkg = Shading.unshadedName(pkg)) + "." + name) || this.explicitImports.contains(qualifiedName)) {
            return "";
        }
        if (this.visibleSimpleNames.contains(name.toString())) {
            return pkg + ".";
        }
        if (pkg.equals(JAVA_LANG_PACKAGE)) {
            return "";
        }
        this.visibleSimpleNames.add(name.toString());
        this.explicitImports.add(qualifiedName);
        return "";
    }

    @Override
    protected String defaultAction(TypeMirror mirror, Void p) {
        return mirror.toString();
    }

    public static class Builder {
        private final SetMultimap<String, TypeReference> implicitImports = LinkedHashMultimap.create();

        public Builder addImplicitImport(TypeReference type) {
            this.implicitImports.put(type.getSimpleName(), type);
            return this;
        }

        public ImportManager build() {
            LinkedHashSet<String> nonConflictingImports = new LinkedHashSet<String>();
            for (Set<TypeReference> importGroup : Multimaps.asMap(this.implicitImports).values()) {
                TypeReference implicitImport;
                if (importGroup.size() != 1 || !(implicitImport = Iterables.getOnlyElement(importGroup)).isTopLevel()) continue;
                nonConflictingImports.add(implicitImport.getQualifiedName());
            }
            return new ImportManager(this.implicitImports.keySet(), nonConflictingImports);
        }
    }
}

