/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.source;

import java.io.Closeable;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import javax.annotation.processing.Filer;
import javax.annotation.processing.FilerException;
import javax.lang.model.element.Element;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import org.inferred.source.ImportManager;
import org.inferred.source.SourceBuilder;
import org.inferred.source.SourceLevel;
import org.inferred.source.SourceStringBuilder;
import org.inferred.source.TypeReference;

public class CompilationUnitWriter
implements SourceBuilder,
Closeable {
    private final Writer writer;
    private final ImportManager importManager;
    private final SourceStringBuilder source;

    public CompilationUnitWriter(Filer filer, Elements elements, SourceLevel sourceLevel, TypeReference classToWrite, Collection<TypeReference> nestedClasses, Element originatingElement) throws FilerException {
        try {
            this.writer = filer.createSourceFile(classToWrite.getQualifiedName(), originatingElement).openWriter();
            this.writer.append("// Autogenerated code. Do not modify.\n").append("package ").append(classToWrite.getPackage()).append(";\n").append("\n");
        }
        catch (FilerException e) {
            throw e;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        ImportManager.Builder importManagerBuilder = new ImportManager.Builder();
        importManagerBuilder.addImplicitImport(classToWrite);
        PackageElement pkg = elements.getPackageElement(classToWrite.getPackage());
        for (TypeElement sibling : ElementFilter.typesIn(pkg.getEnclosedElements())) {
            importManagerBuilder.addImplicitImport(TypeReference.to(sibling));
        }
        for (TypeReference nestedClass : nestedClasses) {
            importManagerBuilder.addImplicitImport(nestedClass);
        }
        this.importManager = importManagerBuilder.build();
        this.source = new SourceStringBuilder(sourceLevel, this.importManager, new StringBuilder());
    }

    @Override
    public CompilationUnitWriter add(String fmt, Object ... args) {
        this.source.add(fmt, args);
        return this;
    }

    @Override
    public CompilationUnitWriter addLine(String fmt, Object ... args) {
        this.source.addLine(fmt, args);
        return this;
    }

    @Override
    public SourceLevel getSourceLevel() {
        return this.source.getSourceLevel();
    }

    @Override
    public void close() {
        try {
            if (!this.importManager.getClassImports().isEmpty()) {
                for (String classImport : this.importManager.getClassImports()) {
                    this.writer.append("import ").append(classImport).append(";\n");
                }
                this.writer.append("\n");
            }
            this.writer.append(this.source.toString());
            this.writer.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

