/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.source;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ErrorType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.NoType;
import javax.lang.model.type.NullType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.AbstractTypeVisitor6;

public class IsInvalidTypeVisitor
extends AbstractTypeVisitor6<Boolean, Void>
implements Predicate<TypeMirror> {
    public boolean apply(TypeMirror input) {
        return input != null && input.accept(this, null) != false;
    }

    @Override
    public Boolean visitPrimitive(PrimitiveType t, Void p) {
        return false;
    }

    @Override
    public Boolean visitNull(NullType t, Void p) {
        return false;
    }

    @Override
    public Boolean visitArray(ArrayType t, Void p) {
        return this.apply(t.getComponentType());
    }

    @Override
    public Boolean visitDeclared(DeclaredType t, Void p) {
        return Iterables.any(t.getTypeArguments(), (Predicate)this);
    }

    @Override
    public Boolean visitError(ErrorType t, Void p) {
        return true;
    }

    @Override
    public Boolean visitTypeVariable(TypeVariable t, Void p) {
        TypeParameterElement element = (TypeParameterElement)t.asElement();
        return Iterables.any(element.getBounds(), (Predicate)this);
    }

    @Override
    public Boolean visitWildcard(WildcardType t, Void p) {
        return this.apply(t.getExtendsBound()) || this.apply(t.getSuperBound());
    }

    @Override
    public Boolean visitExecutable(ExecutableType t, Void p) {
        return Iterables.any(t.getParameterTypes(), (Predicate)this) || this.apply(t.getReturnType()) || Iterables.any(t.getThrownTypes(), (Predicate)this) || Iterables.any(t.getTypeVariables(), (Predicate)this);
    }

    @Override
    public Boolean visitNoType(NoType t, Void p) {
        return false;
    }
}

