/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.source;

import com.google.common.base.Strings;
import org.inferred.source.SourceBuilder;
import org.inferred.source.SourceLevel;

public class SourceBuilders {
    public static SourceBuilder withIndent(SourceBuilder delegate, int indent) {
        String indentChars = Strings.repeat((String)" ", (int)indent);
        if (delegate instanceof IndentingSourceBuilder) {
            IndentingSourceBuilder previousIndenter = (IndentingSourceBuilder)delegate;
            return new IndentingSourceBuilder(previousIndenter.delegate, String.valueOf(previousIndenter.indentChars) + indentChars);
        }
        return new IndentingSourceBuilder(delegate, indentChars);
    }

    private SourceBuilders() {
    }

    private static class IndentingSourceBuilder
    implements SourceBuilder {
        private final SourceBuilder delegate;
        private final String indentChars;
        private boolean atNewline = true;

        private IndentingSourceBuilder(SourceBuilder delegate, String indentChars) {
            this.delegate = delegate;
            this.indentChars = indentChars;
        }

        @Override
        public SourceBuilder addLine(String fmt, Object ... args) {
            StringBuilder indentedFormatString = new StringBuilder();
            if (this.atNewline && fmt.length() > 0 && fmt.charAt(0) != '\n') {
                indentedFormatString.append(this.indentChars);
            }
            indentedFormatString.append(fmt.replaceAll("(\n+)", "$1" + this.indentChars));
            indentedFormatString.append("\n");
            this.atNewline = true;
            this.delegate.add(indentedFormatString.toString(), args);
            return this;
        }

        @Override
        public SourceBuilder add(String fmt, Object ... args) {
            if (fmt.endsWith("\n")) {
                this.addLine(fmt.substring(0, fmt.length() - 1), args);
            } else {
                StringBuilder indentedFormatString = new StringBuilder();
                if (this.atNewline) {
                    indentedFormatString.append(this.indentChars);
                }
                indentedFormatString.append(fmt.replace("\n", "\n" + this.indentChars));
                this.atNewline = false;
                this.delegate.add(indentedFormatString.toString(), args);
            }
            return this;
        }

        @Override
        public SourceLevel getSourceLevel() {
            return this.delegate.getSourceLevel();
        }
    }
}

