/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.source;

import com.google.common.base.Optional;
import javax.lang.model.SourceVersion;
import org.inferred.source.TypeReference;

public enum SourceLevel {
    JAVA_6,
    JAVA_7;


    public static SourceLevel from(SourceVersion sourceVersion) {
        if (sourceVersion.compareTo(SourceVersion.RELEASE_6) <= 0) {
            return JAVA_6;
        }
        return JAVA_7;
    }

    public Optional<TypeReference> javaUtilObjects() {
        switch (this) {
            case JAVA_6: {
                return Optional.absent();
            }
        }
        return Optional.of((Object)TypeReference.to("java.util", "Objects", new String[0]));
    }

    public boolean supportsDiamondOperator() {
        return this.compareTo(JAVA_7) >= 0;
    }
}

