/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.source;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.Name;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.SimpleTypeVisitor6;
import org.inferred.source.TypeReference;

interface TypeShortener {
    public String shorten(Class<?> var1);

    public String shorten(TypeElement var1);

    public String shorten(TypeMirror var1);

    public String shorten(TypeReference var1);

    public static class AlwaysShorten
    extends SimpleTypeVisitor6<String, Void>
    implements Function<TypeMirror, String>,
    TypeShortener {
        @Override
        public String shorten(Class<?> cls) {
            if (cls.getEnclosingClass() != null) {
                return this.shorten(cls.getEnclosingClass()) + "." + cls.getSimpleName();
            }
            return cls.getSimpleName();
        }

        @Override
        public String shorten(TypeElement type) {
            Element parent = type.getEnclosingElement();
            if (parent.getKind().isInterface() || parent.getKind().isClass()) {
                return this.shorten((TypeElement)parent) + "." + type.getSimpleName();
            }
            return type.getSimpleName().toString();
        }

        @Override
        public String shorten(TypeMirror mirror) {
            return mirror.accept(this, null);
        }

        @Override
        public String shorten(TypeReference type) {
            return type.getQualifiedName().substring(type.getPackage().length() + 1);
        }

        public String apply(TypeMirror mirror) {
            return mirror.accept(this, null);
        }

        @Override
        public String visitDeclared(DeclaredType mirror, Void p) {
            String suffix;
            Name name = mirror.asElement().getSimpleName();
            String prefix = mirror.getEnclosingType().getKind() == TypeKind.NONE ? "" : (String)this.visit(mirror.getEnclosingType()) + ".";
            if (!mirror.getTypeArguments().isEmpty()) {
                List shortTypeArguments = Lists.transform(mirror.getTypeArguments(), (Function)this);
                suffix = "<" + Joiner.on((String)", ").join((Iterable)shortTypeArguments) + ">";
            } else {
                suffix = "";
            }
            return prefix + name + suffix;
        }

        @Override
        protected String defaultAction(TypeMirror mirror, Void p) {
            return mirror.toString();
        }
    }

    public static class NeverShorten
    extends SimpleTypeVisitor6<String, Void>
    implements Function<TypeMirror, String>,
    TypeShortener {
        @Override
        public String shorten(Class<?> cls) {
            return cls.getCanonicalName();
        }

        @Override
        public String shorten(TypeElement type) {
            return type.getQualifiedName().toString();
        }

        @Override
        public String shorten(TypeMirror mirror) {
            return mirror.accept(this, null);
        }

        @Override
        public String shorten(TypeReference type) {
            return type.getQualifiedName();
        }

        public String apply(TypeMirror mirror) {
            return mirror.accept(this, null);
        }

        @Override
        public String visitDeclared(DeclaredType mirror, Void p) {
            String suffix;
            Name name = mirror.asElement().getSimpleName();
            String prefix = mirror.getEnclosingType().getKind() == TypeKind.NONE ? ((PackageElement)mirror.asElement().getEnclosingElement()).getQualifiedName() + "." : (String)this.visit(mirror.getEnclosingType()) + ".";
            if (!mirror.getTypeArguments().isEmpty()) {
                List shortTypeArguments = Lists.transform(mirror.getTypeArguments(), (Function)this);
                suffix = "<" + Joiner.on((String)", ").join((Iterable)shortTypeArguments) + ">";
            } else {
                suffix = "";
            }
            return prefix + name + suffix;
        }

        @Override
        protected String defaultAction(TypeMirror mirror, Void p) {
            return mirror.toString();
        }
    }
}

