/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.source;

import javax.lang.model.element.ElementKind;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import org.inferred.source.ValueType;
import org.inferred.source.shaded.com.google.common.base.Preconditions;

public class TypeReference
extends ValueType {
    private final String packageName;
    private final String topLevelType;
    private final String nestedSuffix;

    public static TypeReference to(String packageName, String topLevelType, String ... nestedTypes) {
        Preconditions.checkArgument(!packageName.isEmpty());
        Preconditions.checkArgument(!topLevelType.isEmpty());
        StringBuilder nestedSuffix = new StringBuilder();
        for (String nestedType : nestedTypes) {
            Preconditions.checkArgument(!nestedType.isEmpty());
            nestedSuffix.append(".").append(nestedType);
        }
        return new TypeReference(packageName, topLevelType, nestedSuffix.toString());
    }

    public static TypeReference to(TypeElement type) {
        if (type.getEnclosingElement().getKind() == ElementKind.PACKAGE) {
            PackageElement pkg = (PackageElement)type.getEnclosingElement();
            return new TypeReference(pkg.getQualifiedName().toString(), type.getSimpleName().toString(), "");
        }
        TypeReference enclosingElement = TypeReference.to((TypeElement)type.getEnclosingElement());
        return enclosingElement.nestedType(type.getSimpleName().toString());
    }

    private TypeReference(String packageName, String topLevelType, String nestedSuffix) {
        this.packageName = packageName;
        this.topLevelType = topLevelType;
        this.nestedSuffix = nestedSuffix;
    }

    @Override
    protected void addFields(ValueType.FieldReceiver fields) {
        fields.add("packageName", this.packageName);
        fields.add("topLevelType", this.topLevelType);
        fields.add("nestedSuffix", this.nestedSuffix);
    }

    public String getPackage() {
        return this.packageName;
    }

    public String getTopLevelTypeSimpleName() {
        return this.topLevelType;
    }

    public String getNestedSuffix() {
        return this.nestedSuffix;
    }

    public String getQualifiedName() {
        return this.packageName + "." + this.topLevelType + this.nestedSuffix;
    }

    public String getSimpleName() {
        return this.nestedSuffix.isEmpty() ? this.topLevelType : this.nestedSuffix.substring(this.nestedSuffix.lastIndexOf(46) + 1);
    }

    public boolean isTopLevel() {
        return this.nestedSuffix.isEmpty();
    }

    public TypeReference nestedType(String simpleName) {
        return new TypeReference(this.packageName, this.topLevelType, this.nestedSuffix + "." + simpleName);
    }

    public TypeReference getEnclosingType() {
        Preconditions.checkState(!this.isTopLevel(), "%s has no enclosing type", this);
        return new TypeReference(this.packageName, this.topLevelType, this.nestedSuffix.substring(0, this.nestedSuffix.lastIndexOf(46)));
    }

    @Override
    public String toString() {
        return this.getQualifiedName();
    }
}

