/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.testing.model;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.common.reflect.TypeToken;
import com.google.common.util.concurrent.ExecutionError;
import com.google.common.util.concurrent.SettableFuture;
import com.google.common.util.concurrent.UncheckedExecutionException;
import com.google.common.util.concurrent.UncheckedTimeoutException;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.management.ManagementFactory;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.ToolProvider;
import org.inferred.testing.behavior.CompilationException;
import org.inferred.testing.behavior.SourceBuilder;
import org.inferred.testing.behavior.TempJavaFileManager;
import org.inferred.testing.model.Target;
import org.inferred.testing.model.TypeMirrors;

public class Model {
    private static final String IDENTIFYING_STRING = "--->";
    private static final String PACKAGE = "codegen.internal";
    private static final String PLACEHOLDER_TYPE = "CodegenInternalPlaceholder";
    private static final int TIMEOUT_SECONDS = Model.jvmDebugging() ? Integer.MAX_VALUE : 30;
    private static final Pattern TYPE_NAME_PATTERN = Pattern.compile("(class|[@]?interface|enum) +(\\w+)");
    private ExecutorService executorService;
    private ProcessingEnvironment processingEnv;
    private SynchronousQueue<GenerationRequest> requestQueue;

    public static Model create() {
        Model model = new Model();
        model.start();
        return model;
    }

    protected void start() {
        Preconditions.checkState((this.executorService == null ? 1 : 0) != 0, (Object)"Cannot restart a Model");
        this.executorService = Executors.newSingleThreadExecutor();
        this.requestQueue = new SynchronousQueue();
        CompilerRunner compilerRunner = new CompilerRunner();
        this.executorService.execute(compilerRunner);
        this.processingEnv = compilerRunner.getProcessingEnvironment();
    }

    private void checkRunning() {
        Preconditions.checkState((this.executorService != null && this.processingEnv != null ? 1 : 0) != 0, (Object)"Model not started");
        Preconditions.checkState((!this.executorService.isShutdown() ? 1 : 0) != 0, (Object)"Model destroyed");
    }

    public Types typeUtils() {
        this.checkRunning();
        return this.processingEnv.getTypeUtils();
    }

    public Elements elementUtils() {
        this.checkRunning();
        return this.processingEnv.getElementUtils();
    }

    public ProcessingEnvironment environment() {
        this.checkRunning();
        return this.processingEnv;
    }

    public TypeMirror typeMirror(Class<?> cls) {
        return TypeMirrors.typeMirror(this.typeUtils(), this.elementUtils(), cls);
    }

    public TypeMirror typeMirror(TypeToken<?> type) {
        return TypeMirrors.typeMirror(this.typeUtils(), this.elementUtils(), type);
    }

    public TypeMirror typeMirror(String typeSnippet, TypeMirror ... args) {
        return TypeMirrors.typeMirror(this.typeUtils(), this.elementUtils(), typeSnippet, args);
    }

    public TypeElement typeElement(Class<?> cls) {
        return Model.asTypeElement(this.typeMirror(cls));
    }

    public TypeElement typeElement(String qualifiedType) {
        return Model.asTypeElement(this.typeMirror(qualifiedType, new TypeMirror[0]));
    }

    private static TypeElement asTypeElement(TypeMirror mirror) {
        Preconditions.checkArgument((mirror.getKind() == TypeKind.DECLARED ? 1 : 0) != 0, (String)"%s is a %s, not a TypeElement", (Object[])new Object[]{mirror, mirror.getKind()});
        DeclaredType declaredType = (DeclaredType)mirror;
        ElementKind elementKind = declaredType.asElement().getKind();
        Preconditions.checkArgument((elementKind.isClass() || elementKind.isInterface() ? 1 : 0) != 0, (String)"%s is a %s, not a TypeElement", (Object[])new Object[]{mirror, elementKind});
        return (TypeElement)declaredType.asElement();
    }

    public TypeElement newType(String ... code) {
        String codeString = Joiner.on((String)"\n").join((Object[])code);
        codeString = TYPE_NAME_PATTERN.matcher(codeString).replaceFirst("@" + Target.class.getCanonicalName() + " $0");
        return (TypeElement)this.newElementAnnotatedWith(Target.class, codeString);
    }

    public Element newElementWithMarker(String ... code) {
        String codeString = Joiner.on((String)"\n").join((Object[])code);
        Model.checkMarkerPresentExactlyOnce(codeString);
        codeString = codeString.replaceFirst(IDENTIFYING_STRING, " @" + Target.class.getCanonicalName() + " ");
        return this.newElementAnnotatedWith(Target.class, codeString);
    }

    public Element newElementAnnotatedWith(Class<? extends Annotation> annotationType, String ... code) {
        try {
            String codeString = Joiner.on((String)"\n").join((Object[])code);
            GenerationRequest request = new GenerationRequest(codeString, annotationType);
            if (!this.requestQueue.offer(request, TIMEOUT_SECONDS, TimeUnit.SECONDS)) {
                throw new UncheckedTimeoutException("Code generation request timed out");
            }
            return (Element)request.resultFuture.get((long)TIMEOUT_SECONDS, TimeUnit.SECONDS);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof CompilationException) {
                throw new CompilationException((CompilationException)e.getCause());
            }
            throw new IllegalArgumentException("Code generation failed: " + e.getMessage(), e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Code generation interruped", e);
        }
        catch (TimeoutException e) {
            throw new UncheckedTimeoutException("Code generation timed out", (Throwable)e);
        }
    }

    public void destroy() {
        if (this.executorService != null) {
            this.executorService.shutdownNow();
        }
    }

    private static <T> T getUnchecked(Future<T> future, long timeout, TimeUnit unit) {
        try {
            return future.get(timeout, unit);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw Throwables.propagate((Throwable)e);
        }
        catch (TimeoutException e) {
            throw Throwables.propagate((Throwable)e);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof Error) {
                throw new ExecutionError((Error)e.getCause());
            }
            throw new UncheckedExecutionException(e.getCause());
        }
    }

    private static String getTypeName(String code) {
        Matcher matcher = TYPE_NAME_PATTERN.matcher(code);
        Preconditions.checkArgument((boolean)matcher.find());
        return matcher.group(2);
    }

    private static void checkMarkerPresentExactlyOnce(String codeString) {
        Matcher matcher = Pattern.compile(IDENTIFYING_STRING).matcher(codeString);
        Preconditions.checkArgument((boolean)matcher.find(), (Object)"Code must identify the element to be returned using '--->'");
        Preconditions.checkArgument((!matcher.find() ? 1 : 0) != 0, (Object)"Code must only contain one element marked with '--->'");
    }

    private static boolean jvmDebugging() {
        return ManagementFactory.getRuntimeMXBean().getInputArguments().toString().contains("-agentlib:jdwp");
    }

    private static class HasAnnotationOfType
    implements Predicate<Element> {
        private final Class<? extends Annotation> annotationType;

        public HasAnnotationOfType(Class<? extends Annotation> annotationType) {
            this.annotationType = annotationType;
        }

        public boolean apply(Element input) {
            return input.getAnnotation(this.annotationType) != null;
        }
    }

    private class CompilerRunner
    implements Runnable {
        private final SettableFuture<ProcessingEnvironment> processingEnvFuture = SettableFuture.create();
        private Class<? extends Annotation> annotationType = Target.class;
        private SettableFuture<Element> elementFuture = SettableFuture.create();

        private CompilerRunner() {
        }

        ProcessingEnvironment getProcessingEnvironment() {
            return (ProcessingEnvironment)Model.getUnchecked(this.processingEnvFuture, TIMEOUT_SECONDS, TimeUnit.SECONDS);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            TempJavaFileManager fileManager = new TempJavaFileManager();
            DiagnosticCollector diagnostics = new DiagnosticCollector();
            try {
                JavaFileObject bootstrapType = new SourceBuilder().addLine("package %s;", Model.PACKAGE).addLine("@%s", Target.class).addLine("class %s { }", Model.PLACEHOLDER_TYPE).build();
                JavaCompiler.CompilationTask task = ToolProvider.getSystemJavaCompiler().getTask(null, fileManager, diagnostics, (Iterable<String>)ImmutableList.of((Object)"-proc:only", (Object)"-encoding", (Object)"UTF-8"), null, (Iterable<? extends JavaFileObject>)ImmutableList.of((Object)bootstrapType));
                task.setProcessors((Iterable<? extends Processor>)ImmutableList.of((Object)new ElementCapturingProcessor()));
                task.call();
            }
            catch (RuntimeException e) {
                this.processingEnvFuture.setException((Throwable)e);
                this.elementFuture.setException((Throwable)e);
            }
            finally {
                if (!this.processingEnvFuture.isDone()) {
                    this.processingEnvFuture.setException((Throwable)new CompilationException(diagnostics.getDiagnostics()));
                }
                if (!this.elementFuture.isDone()) {
                    if (diagnostics.getDiagnostics().isEmpty()) {
                        this.elementFuture.setException((Throwable)new IllegalStateException("Code generation terminated abnormally. Was there no annotated element?"));
                    } else {
                        this.elementFuture.setException((Throwable)new CompilationException(diagnostics.getDiagnostics()));
                    }
                }
                fileManager.close();
            }
        }

        private class ElementCapturingProcessor
        extends AbstractProcessor {
            private ElementCapturingProcessor() {
            }

            @Override
            public Set<String> getSupportedAnnotationTypes() {
                return ImmutableSet.of((Object)"*");
            }

            @Override
            public SourceVersion getSupportedSourceVersion() {
                return SourceVersion.latestSupported();
            }

            @Override
            public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
                Element element;
                CompilerRunner.this.processingEnvFuture.set((Object)this.processingEnv);
                Set elements = Sets.filter(roundEnv.getElementsAnnotatedWith(CompilerRunner.this.annotationType), (Predicate)new HasAnnotationOfType(CompilerRunner.this.annotationType));
                try {
                    element = (Element)Iterables.getOnlyElement((Iterable)elements, null);
                }
                catch (IllegalArgumentException e) {
                    CompilerRunner.this.elementFuture.setException((Throwable)new IllegalArgumentException("Multiple elements annotated with @" + CompilerRunner.this.annotationType.getName() + " found"));
                    return false;
                }
                if (element != null) {
                    CompilerRunner.this.elementFuture.set((Object)element);
                    String code = this.fetchCodeForNextRequest();
                    if (code != null) {
                        this.passSourceCodeToCompiler(code);
                    }
                }
                return false;
            }

            private String fetchCodeForNextRequest() {
                try {
                    GenerationRequest request = (GenerationRequest)Model.this.requestQueue.poll(TIMEOUT_SECONDS, TimeUnit.SECONDS);
                    Preconditions.checkState((request != null ? 1 : 0) != 0, (Object)"Timed out waiting for next request");
                    CompilerRunner.this.elementFuture = request.resultFuture;
                    CompilerRunner.this.annotationType = request.annotationType;
                    return request.code;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return null;
                }
            }

            private void passSourceCodeToCompiler(String code) {
                try {
                    this.processingEnv.getFiler().createSourceFile(Model.getTypeName(code), new Element[0]).openWriter().append(code).close();
                }
                catch (IOException e) {
                    CompilerRunner.this.elementFuture.setException((Throwable)e);
                }
            }
        }
    }

    private static class GenerationRequest {
        final SettableFuture<Element> resultFuture = SettableFuture.create();
        final String code;
        final Class<? extends Annotation> annotationType;

        GenerationRequest(String code, Class<? extends Annotation> annotationType) {
            this.code = code;
            this.annotationType = annotationType;
        }
    }
}

