/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.testing.unit;

import com.google.common.collect.ImmutableList;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ElementVisitor;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.NestingKind;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVisitor;
import org.inferred.testing.unit.NameImpl;
import org.inferred.testing.unit.NoTypes;
import org.inferred.testing.unit.PackageElementImpl;

public class ClassTypeImpl
implements DeclaredType {
    private final Element enclosingElement;
    private final TypeMirror enclosingType;
    private final String simpleName;

    public static ClassTypeImpl newTopLevelClass(String qualifiedName) {
        String pkg = qualifiedName.substring(0, qualifiedName.lastIndexOf(46));
        String simpleName = qualifiedName.substring(qualifiedName.lastIndexOf(46) + 1);
        PackageElementImpl enclosingElement = new PackageElementImpl(pkg);
        return new ClassTypeImpl(enclosingElement, NoTypes.NONE, simpleName);
    }

    public static ClassTypeImpl newNestedClass(TypeElement enclosingType, String simpleName) {
        return new ClassTypeImpl(enclosingType, NoTypes.NONE, simpleName);
    }

    public static ClassTypeImpl newInnerClass(DeclaredType enclosingType, String simpleName) {
        return new ClassTypeImpl(enclosingType.asElement(), enclosingType, simpleName);
    }

    private ClassTypeImpl(Element enclosingElement, TypeMirror enclosingType, String simpleName) {
        this.enclosingElement = enclosingElement;
        this.enclosingType = enclosingType;
        this.simpleName = simpleName;
    }

    @Override
    public TypeKind getKind() {
        return TypeKind.DECLARED;
    }

    @Override
    public <R, P> R accept(TypeVisitor<R, P> v, P p) {
        return v.visitDeclared(this, p);
    }

    @Override
    public ClassElementImpl asElement() {
        return new ClassElementImpl();
    }

    @Override
    public TypeMirror getEnclosingType() {
        return this.enclosingType;
    }

    @Override
    public List<? extends TypeMirror> getTypeArguments() {
        return ImmutableList.of();
    }

    @Override
    public String toString() {
        String prefix = this.enclosingElement.getKind() == ElementKind.PACKAGE ? ((PackageElement)this.enclosingElement).getQualifiedName() + "." : ((TypeElement)this.enclosingElement).getQualifiedName() + ".";
        return prefix + this.simpleName;
    }

    @Override
    public int hashCode() {
        return this.toString().hashCode();
    }

    @Override
    public boolean equals(Object o) {
        return o instanceof ClassTypeImpl && this.toString().equals(o.toString());
    }

    public class ClassElementImpl
    implements TypeElement {
        @Override
        public ClassTypeImpl asType() {
            return ClassTypeImpl.this;
        }

        @Override
        public ElementKind getKind() {
            return ElementKind.CLASS;
        }

        @Override
        public List<? extends AnnotationMirror> getAnnotationMirrors() {
            throw new UnsupportedOperationException();
        }

        @Override
        public <A extends Annotation> A getAnnotation(Class<A> annotationType) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Set<Modifier> getModifiers() {
            throw new UnsupportedOperationException();
        }

        @Override
        public <R, P> R accept(ElementVisitor<R, P> v, P p) {
            return v.visitType(this, p);
        }

        @Override
        public List<? extends Element> getEnclosedElements() {
            throw new UnsupportedOperationException();
        }

        @Override
        public NestingKind getNestingKind() {
            return ClassTypeImpl.this.enclosingElement.getKind() == ElementKind.PACKAGE ? NestingKind.TOP_LEVEL : NestingKind.MEMBER;
        }

        @Override
        public Name getQualifiedName() {
            return new NameImpl(ClassTypeImpl.this.toString());
        }

        @Override
        public Name getSimpleName() {
            return new NameImpl(ClassTypeImpl.this.simpleName);
        }

        @Override
        public TypeMirror getSuperclass() {
            return NoTypes.NONE;
        }

        @Override
        public List<? extends TypeMirror> getInterfaces() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<? extends TypeParameterElement> getTypeParameters() {
            return ImmutableList.of();
        }

        @Override
        public Element getEnclosingElement() {
            return ClassTypeImpl.this.enclosingElement;
        }
    }
}

