/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.testing.unit;

import com.google.common.base.Preconditions;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import javassist.util.proxy.MethodFilter;
import javassist.util.proxy.MethodHandler;
import javassist.util.proxy.ProxyFactory;

class Partial {
    public static <T> T of(Class<T> cls, Object ... args) {
        Partial.checkIsValidPartial(cls);
        try {
            Constructor<?> constructor = cls.getDeclaredConstructors()[0];
            ProxyFactory factory = new ProxyFactory();
            factory.setSuperclass(cls);
            factory.setFilter(new MethodFilter(){

                public boolean isHandled(Method m) {
                    return Modifier.isAbstract(m.getModifiers());
                }
            });
            Object partial = factory.create((Class[])constructor.getParameterTypes(), args, (MethodHandler)new ThrowingMethodHandler());
            return (T)partial;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to instantiate " + cls, e);
        }
    }

    private static <T> void checkIsValidPartial(Class<T> cls) {
        Preconditions.checkArgument((boolean)Modifier.isAbstract(cls.getModifiers()), (Object)"Partial class must be abstract");
        Preconditions.checkArgument((cls.getDeclaredConstructors().length == 1 ? 1 : 0) != 0, (String)"Partial class %s must have exactly one constructor (found %s)", (Object[])new Object[]{cls, cls.getDeclaredConstructors().length});
        Constructor<?> constructor = cls.getDeclaredConstructors()[0];
        Preconditions.checkArgument((!Modifier.isPrivate(constructor.getModifiers()) ? 1 : 0) != 0, (String)"Partial class %s must have a package-visible constructor", (Object[])new Object[]{cls});
    }

    private Partial() {
    }

    private static final class ThrowingMethodHandler
    implements MethodHandler {
        private ThrowingMethodHandler() {
        }

        public Object invoke(Object self, Method thisMethod, Method proceed, Object[] args) {
            throw new UnsupportedOperationException();
        }
    }
}

