/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.testing.behavior;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.List;
import java.util.Locale;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;

public class CompilationException
extends RuntimeException {
    private final ImmutableList<Diagnostic<? extends JavaFileObject>> diagnostics;

    public CompilationException(List<Diagnostic<? extends JavaFileObject>> diagnostics) {
        this.diagnostics = ImmutableList.copyOf(diagnostics);
    }

    public CompilationException(CompilationException e) {
        this((List<Diagnostic<? extends JavaFileObject>>)e.diagnostics);
    }

    @Override
    public String getMessage() {
        StringBuilder fullMessage = new StringBuilder("Compilation failed");
        int i = 1;
        for (Diagnostic diagnostic : this.diagnostics) {
            fullMessage.append("\n    ").append(i++).append(") ").append(diagnostic.getMessage(Locale.getDefault()));
            JavaFileObject source = (JavaFileObject)diagnostic.getSource();
            long line = diagnostic.getLineNumber();
            if (source == null || line == -1L) continue;
            File sourceFile = new File(source.getName());
            fullMessage.append(" (").append(sourceFile.getName()).append(":").append(line).append(")");
        }
        return fullMessage.toString();
    }
}

