/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.testing.behavior;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;

public class SourceBuilder {
    private static final Pattern TYPE_NAME_PATTERN = Pattern.compile("(class|[@]?interface|enum)\\s+(\\w+)");
    private static final Pattern PACKAGE_PATTERN = Pattern.compile("package\\s+(\\w+(\\s*\\.\\s*\\w+)*)\\s*;");
    private final StringBuilder code = new StringBuilder();

    public SourceBuilder addLine(String fmt, Object ... args) {
        Object[] substituteArgs = new Object[args.length];
        for (int i = 0; i < args.length; ++i) {
            substituteArgs[i] = SourceBuilder.substitute(args[i]);
        }
        this.code.append(String.format(fmt, substituteArgs)).append("\n");
        return this;
    }

    public JavaFileObject build() {
        return new Source(this.code.toString());
    }

    static Object substitute(Object arg) {
        if (arg instanceof Class) {
            return ((Class)arg).getCanonicalName();
        }
        return arg;
    }

    static String getTypeNameFromSource(CharSequence source) {
        Matcher packageMatcher = PACKAGE_PATTERN.matcher(source);
        Matcher typeNameMatcher = TYPE_NAME_PATTERN.matcher(source);
        Preconditions.checkArgument((boolean)packageMatcher.find(), (Object)"Source contains no package definition");
        Preconditions.checkArgument((boolean)typeNameMatcher.find(), (Object)"Source contains no type definition");
        String typeName = packageMatcher.group(1) + "." + typeNameMatcher.group(2);
        typeName = typeName.replaceAll("\\s+", "");
        return typeName;
    }

    static URI uriForClass(String typeName) {
        try {
            return new URI("mem:///" + typeName.replaceAll("\\.", "/") + ".java");
        }
        catch (URISyntaxException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private class Source
    extends SimpleJavaFileObject {
        private final String content;

        public Source(String source) {
            super(SourceBuilder.uriForClass(SourceBuilder.getTypeNameFromSource(source)), JavaFileObject.Kind.SOURCE);
            this.content = source;
        }

        @Override
        public CharSequence getCharContent(boolean ignoreEncodingErrors) {
            return this.content;
        }
    }
}

